/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.pqc.crypto.lms.HSSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.mldsa.MLDSAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.bouncycastle.pqc.crypto.util.Utils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("privateKeyInfoData array null");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("privateKeyInfoData array empty");
        }
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(byArray)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inputStream) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inputStream).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        if (privateKeyInfo == null) {
            throw new IllegalArgumentException("keyInfo array null");
        }
        AlgorithmIdentifier algorithmIdentifier = privateKeyInfo.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_alg_hss_lms_hashsig)) {
            byte[] byArray = ASN1OctetString.getInstance(privateKeyInfo.parsePrivateKey()).getOctets();
            ASN1BitString aSN1BitString = privateKeyInfo.getPublicKeyData();
            if (Pack.bigEndianToInt(byArray, 0) == 1) {
                if (aSN1BitString != null) {
                    byte[] byArray2 = aSN1BitString.getOctets();
                    return LMSPrivateKeyParameters.getInstance(Arrays.copyOfRange(byArray, 4, byArray.length), Arrays.copyOfRange(byArray2, 4, byArray2.length));
                }
                return LMSPrivateKeyParameters.getInstance(Arrays.copyOfRange(byArray, 4, byArray.length));
            }
            if (aSN1BitString != null) {
                byte[] byArray3 = aSN1BitString.getOctets();
                return HSSPrivateKeyParameters.getInstance(Arrays.copyOfRange(byArray, 4, byArray.length), byArray3);
            }
            return HSSPrivateKeyParameters.getInstance(Arrays.copyOfRange(byArray, 4, byArray.length));
        }
        if (Utils.shldsaParams.containsKey(aSN1ObjectIdentifier)) {
            ASN1OctetString aSN1OctetString = PrivateKeyFactory.parseOctetString(privateKeyInfo.getPrivateKey());
            SLHDSAParameters sLHDSAParameters = Utils.slhdsaParamsLookup(aSN1ObjectIdentifier);
            return new SLHDSAPrivateKeyParameters(sLHDSAParameters, aSN1OctetString.getOctets());
        }
        if (aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_alg_ml_kem_512) || aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_alg_ml_kem_768) || aSN1ObjectIdentifier.equals(NISTObjectIdentifiers.id_alg_ml_kem_1024)) {
            ASN1OctetString aSN1OctetString = PrivateKeyFactory.parseOctetString(privateKeyInfo.getPrivateKey());
            MLKEMParameters mLKEMParameters = Utils.mlkemParamsLookup(aSN1ObjectIdentifier);
            return new MLKEMPrivateKeyParameters(mLKEMParameters, aSN1OctetString.getOctets());
        }
        if (Utils.mldsaParams.containsKey(aSN1ObjectIdentifier)) {
            ASN1OctetString aSN1OctetString = PrivateKeyFactory.parseOctetString(privateKeyInfo.getPrivateKey());
            MLDSAParameters mLDSAParameters = Utils.mldsaParamsLookup(aSN1ObjectIdentifier);
            if (aSN1OctetString instanceof DEROctetString) {
                byte[] byArray = ASN1OctetString.getInstance(aSN1OctetString).getOctets();
                if (privateKeyInfo.getPublicKeyData() != null) {
                    MLDSAPublicKeyParameters mLDSAPublicKeyParameters = PublicKeyFactory.MLDSAConverter.getPublicKeyParams(mLDSAParameters, privateKeyInfo.getPublicKeyData());
                    return new MLDSAPrivateKeyParameters(mLDSAParameters, byArray, mLDSAPublicKeyParameters);
                }
                return new MLDSAPrivateKeyParameters(mLDSAParameters, byArray);
            }
            throw new IOException("not supported");
        }
        throw new RuntimeException("algorithm identifier in private key not recognised");
    }

    private static ASN1OctetString parseOctetString(ASN1OctetString aSN1OctetString) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(aSN1OctetString.getOctets());
        int n = byteArrayInputStream.read();
        int n2 = PrivateKeyFactory.readLen(byteArrayInputStream);
        if (n == 4 && n2 == byteArrayInputStream.available()) {
            return ASN1OctetString.getInstance(aSN1OctetString.getOctets());
        }
        if (n == 128 && n2 == byteArrayInputStream.available()) {
            return ASN1OctetString.getInstance(ASN1TaggedObject.getInstance(aSN1OctetString.getOctets()), false);
        }
        if (n == 160 && n2 == byteArrayInputStream.available()) {
            return ASN1OctetString.getInstance(ASN1TaggedObject.getInstance(aSN1OctetString.getOctets()), true);
        }
        return aSN1OctetString;
    }

    private static int readLen(ByteArrayInputStream byteArrayInputStream) {
        int n = byteArrayInputStream.read();
        if (n != (n & 0x7F)) {
            int n2 = n & 0x7F;
            n = 0;
            while (n2-- != 0) {
                n = (n << 8) + byteArrayInputStream.read();
            }
        }
        return n;
    }

    private static short[] convert(byte[] byArray) {
        short[] sArray = new short[byArray.length / 2];
        for (int i = 0; i != sArray.length; ++i) {
            sArray[i] = Pack.littleEndianToShort(byArray, i * 2);
        }
        return sArray;
    }
}

