/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import java.nio.channels.ClosedChannelException;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConsumerExceptionHandler
implements ExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NettyConsumerExceptionHandler.class);
    private final CamelLogger logger;
    private final LoggingLevel closedLoggingLevel;

    public NettyConsumerExceptionHandler(NettyConsumer consumer) {
        this.logger = new CamelLogger(LOG, consumer.getConfiguration().getServerExceptionCaughtLogLevel());
        this.closedLoggingLevel = consumer.getConfiguration().getServerClosedChannelExceptionCaughtLogLevel();
    }

    @Override
    public void handleException(Throwable exception) {
        this.handleException(null, null, exception);
    }

    @Override
    public void handleException(String message, Throwable exception) {
        this.handleException(message, null, exception);
    }

    @Override
    public void handleException(String message, Exchange exchange, Throwable exception) {
        try {
            boolean closed;
            String msg = CamelExchangeException.createExceptionMessage(message, exchange, exception);
            boolean bl = closed = ObjectHelper.getException(ClosedChannelException.class, exception) != null;
            if (closed) {
                this.logger.log(msg, exception, this.closedLoggingLevel);
            } else {
                this.logger.log(msg, exception);
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }
}

