/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.internal.SystemPropertyUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyEndpoint;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="netty")
public class NettyComponent
extends DefaultComponent
implements SSLContextParametersAware {
    private static final Logger LOG = LoggerFactory.getLogger(NettyComponent.class);
    @Metadata
    private NettyConfiguration configuration = new NettyConfiguration();
    @Metadata(label="consumer,advanced")
    private int maximumPoolSize;
    @Metadata(label="consumer,advanced")
    private volatile EventExecutorGroup executorService;
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public NettyComponent() {
    }

    public NettyComponent(Class<? extends Endpoint> endpointClass) {
    }

    public NettyComponent(CamelContext context) {
        super(context);
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        NettyConfiguration config = this.configuration.copy();
        config = this.parseConfiguration(config, remaining, parameters);
        NettyServerBootstrapConfiguration bootstrapConfiguration = this.resolveAndRemoveReferenceParameter(parameters, "bootstrapConfiguration", NettyServerBootstrapConfiguration.class);
        if (bootstrapConfiguration != null) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            BeanIntrospection beanIntrospection = PluginHelper.getBeanIntrospection(this.getCamelContext());
            if (beanIntrospection.getProperties(bootstrapConfiguration, options, null, false)) {
                PropertyBindingSupport.bindProperties(this.getCamelContext(), config, options);
            }
        }
        if (config.getSslContextParameters() == null) {
            config.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        config.validateConfiguration();
        NettyEndpoint nettyEndpoint = new NettyEndpoint(uri, this, config);
        this.setProperties(nettyEndpoint, parameters);
        return nettyEndpoint;
    }

    protected NettyConfiguration parseConfiguration(NettyConfiguration configuration, String remaining, Map<String, Object> parameters) throws Exception {
        configuration.parseURI(new URI(remaining), parameters, this, "tcp", "udp");
        return configuration;
    }

    public NettyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(NettyConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setExecutorService(EventExecutorGroup executorService) {
        this.executorService = executorService;
    }

    @Override
    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    @Override
    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public EventExecutorGroup getExecutorService() {
        return this.executorService;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.configuration.isUsingExecutorService() && this.executorService == null) {
            int netty = SystemPropertyUtil.getInt("io.netty.eventLoopThreads", NettyRuntime.availableProcessors() * 2);
            int threads = Math.max(this.maximumPoolSize, netty + 1);
            this.executorService = NettyHelper.createExecutorGroup(this.getCamelContext(), "NettyConsumerExecutorGroup", threads);
            LOG.info("Creating shared NettyConsumerExecutorGroup with {} threads", (Object)threads);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.configuration.isUsingExecutorService() && this.executorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executorService);
            this.executorService = null;
        }
        if (this.configuration.getWorkerGroup() != null) {
            this.configuration.getWorkerGroup().shutdownGracefully();
        }
        super.doStop();
    }
}

