/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.handlers;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.netty.NettyCamelState;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyPayloadHelper;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.support.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientChannelHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(ClientChannelHandler.class);
    private final NettyProducer producer;
    private volatile boolean messageReceived;
    private volatile boolean exceptionHandled;
    private volatile boolean disconnecting;

    public ClientChannelHandler(NettyProducer producer) {
        this.producer = producer;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Channel open: {}", (Object)ctx.channel());
        }
        this.producer.getAllChannels().add(ctx.channel());
        this.disconnecting = false;
        this.messageReceived = false;
        this.exceptionHandled = false;
        super.channelActive(ctx);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Exception caught at Channel: {}", (Object)ctx.channel(), (Object)cause);
        }
        if (this.exceptionHandled) {
            return;
        }
        this.exceptionHandled = true;
        Exchange exchange = null;
        NettyCamelState state = this.getState(ctx, cause);
        if (state != null) {
            state.onExceptionCaught();
            exchange = state.getExchange();
        }
        if (exchange != null) {
            Exception initialCause = exchange.getException();
            if (initialCause != null && initialCause.getCause() == null) {
                initialCause.initCause(cause);
            } else {
                exchange.setException(cause);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing channel as an exception was thrown from Netty", cause);
            }
            NettyHelper.close(ctx.channel());
            state.callbackDoneOnce(false);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        NettyConfiguration configuration;
        NettyCamelState state;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Channel closed: {}", (Object)ctx.channel());
        }
        Exchange exchange = (state = this.getState(ctx, null)) != null ? state.getExchange() : null;
        boolean doneUoW = state != null && state.isDone();
        this.producer.getCorrelationManager().removeState(ctx, ctx.channel());
        this.producer.getAllChannels().remove(ctx.channel());
        if (!(exchange == null || this.disconnecting || !(configuration = this.producer.getConfiguration()).isSync() || doneUoW || this.messageReceived || this.exceptionHandled)) {
            this.exceptionHandled = true;
            String address = configuration.getAddress();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Channel is inactive but no message received from address: {}", (Object)address);
            }
            if (!configuration.isDisconnect()) {
                exchange.setException(new CamelExchangeException("No response received from remote server: " + address, exchange));
            }
            state.callbackDoneOnce(false);
        }
        this.disconnecting = false;
        super.channelInactive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        Message message;
        NettyCamelState state;
        Exchange exchange;
        ChannelHandler handler;
        this.messageReceived = true;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Message received: {}", msg);
        }
        if ((handler = ctx.pipeline().get("timeout")) != null) {
            LOG.trace("Removing timeout channel as we received message");
            ctx.pipeline().remove(handler);
        }
        Exchange exchange2 = exchange = (state = this.getState(ctx, msg)) != null ? state.getExchange() : null;
        if (exchange == null) {
            return;
        }
        try {
            message = this.getResponseMessage(exchange, ctx, msg);
        }
        catch (Exception e) {
            exchange.setException(e);
            state.callbackDoneOnce(false);
            return;
        }
        Boolean continueWaitForAnswer = exchange.getProperty("CamelClientContinue", Boolean.class);
        if (continueWaitForAnswer != null && continueWaitForAnswer.booleanValue()) {
            exchange.removeProperty("CamelClientContinue");
            return;
        }
        if (ExchangeHelper.isOutCapable(exchange)) {
            exchange.setOut(message);
        } else {
            exchange.setIn(message);
        }
        try {
            Boolean close = ExchangeHelper.isOutCapable(exchange) ? exchange.getOut().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class) : exchange.getIn().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class);
            if (close == null) {
                close = exchange.getProperty("CamelNettyCloseChannelWhenComplete", Boolean.class);
            }
            boolean disconnect = this.producer.getConfiguration().isDisconnect();
            if (close != null) {
                disconnect = close;
            }
            if (!this.producer.getConfiguration().isReuseChannel() && disconnect) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Closing channel when complete at address: {}", (Object)this.producer.getConfiguration().getAddress());
                }
                this.disconnecting = true;
                NettyHelper.close(ctx.channel());
            }
        }
        finally {
            state.callbackDoneOnce(false);
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.messageReceived = false;
        super.channelReadComplete(ctx);
    }

    protected Message getResponseMessage(Exchange exchange, ChannelHandlerContext ctx, Object message) throws Exception {
        Object body = message;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Channel: {} received body: {}", (Object)ctx.channel(), body);
        }
        if (this.producer.getConfiguration().isTextline()) {
            body = this.producer.getContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, message);
        }
        if (ExchangeHelper.isOutCapable(exchange)) {
            NettyPayloadHelper.setOut(exchange, body);
            return exchange.getOut();
        }
        NettyPayloadHelper.setIn(exchange, body);
        return exchange.getIn();
    }

    private NettyCamelState getState(ChannelHandlerContext ctx, Object msg) {
        return this.producer.getCorrelationManager().getState(ctx, ctx.channel(), msg);
    }

    private NettyCamelState getState(ChannelHandlerContext ctx, Throwable cause) {
        return this.producer.getCorrelationManager().getState(ctx, ctx.channel(), cause);
    }
}

