/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import java.util.regex.Matcher;
import org.apache.camel.CamelContext;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.http.HttpServerBootstrapFactory;
import org.apache.camel.component.netty.http.HttpServerConsumerChannelFactory;
import org.apache.camel.component.netty.http.HttpServerSharedInitializerFactory;
import org.apache.camel.component.netty.http.NettySharedHttpServer;
import org.apache.camel.component.netty.http.NettySharedHttpServerBootstrapConfiguration;
import org.apache.camel.component.netty.http.handlers.HttpServerMultiplexChannelHandler;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNettySharedHttpServer
extends ServiceSupport
implements NettySharedHttpServer {
    public static final String DEFAULT_PATTERN = "Camel Thread ##counter# - #name#:#port#";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNettySharedHttpServer.class);
    private NettySharedHttpServerBootstrapConfiguration configuration;
    private HttpServerConsumerChannelFactory channelFactory;
    private HttpServerBootstrapFactory bootstrapFactory;
    private CamelContext camelContext;
    private boolean startServer = true;
    private String threadPattern = "Camel Thread ##counter# - #name#:#port#";

    @Override
    public void setNettyServerBootstrapConfiguration(NettySharedHttpServerBootstrapConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public int getPort() {
        return this.configuration != null ? this.configuration.getPort() : -1;
    }

    @Override
    public HttpServerConsumerChannelFactory getConsumerChannelFactory() {
        return this.channelFactory;
    }

    @Override
    public NettyServerBootstrapFactory getServerBootstrapFactory() {
        return this.bootstrapFactory;
    }

    @Override
    public int getConsumersSize() {
        if (this.channelFactory != null) {
            return this.channelFactory.consumers();
        }
        return -1;
    }

    @Override
    public void setStartServer(boolean startServer) {
        this.startServer = startServer;
    }

    @Override
    public void setThreadNamePattern(String pattern) {
        this.threadPattern = pattern;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.configuration, "setNettyServerBootstrapConfiguration() must be called with a NettyServerBootstrapConfiguration instance", this);
        if (this.configuration.getPort() <= 0) {
            throw new IllegalArgumentException("Port must be configured on NettySharedHttpServerBootstrapConfiguration " + String.valueOf(this.configuration));
        }
        if (ObjectHelper.isEmpty(this.configuration.getHost())) {
            throw new IllegalArgumentException("Host must be configured on NettySharedHttpServerBootstrapConfiguration " + String.valueOf(this.configuration));
        }
        LOG.debug("NettySharedHttpServer using configuration: {}", (Object)this.configuration);
        this.configuration.setProtocol("tcp");
        this.channelFactory = new HttpServerMultiplexChannelHandler();
        this.channelFactory.init(this.configuration.getPort());
        HttpServerSharedInitializerFactory pipelineFactory = new HttpServerSharedInitializerFactory(this.configuration, this.channelFactory, this.camelContext);
        String port = Matcher.quoteReplacement(Integer.toString(this.configuration.getPort()));
        String pattern = this.threadPattern;
        pattern = pattern.replaceFirst("#port#", port);
        CamelThreadFactory tf = new CamelThreadFactory(pattern, "NettySharedHttpServer", true);
        this.bootstrapFactory = new HttpServerBootstrapFactory(this.channelFactory, false);
        this.bootstrapFactory.init(tf, (NettyServerBootstrapConfiguration)this.configuration, (ChannelInitializer<Channel>)pipelineFactory);
        ServiceHelper.startService((Object)this.channelFactory);
        if (this.startServer) {
            LOG.info("Starting NettySharedHttpServer on {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
            ServiceHelper.startService(this.bootstrapFactory);
        }
    }

    @Override
    protected void doStop() {
        LOG.info("Stopping NettySharedHttpServer on {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        ServiceHelper.stopService(this.bootstrapFactory, this.channelFactory);
    }
}

