/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.camel.component.netty.http.HttpPrincipal;
import org.apache.camel.component.netty.http.SecurityAuthenticatorSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAASSecurityAuthenticator
extends SecurityAuthenticatorSupport {
    private static final Logger LOG = LoggerFactory.getLogger(JAASSecurityAuthenticator.class);

    @Override
    public Subject login(HttpPrincipal principal) throws LoginException {
        if (ObjectHelper.isEmpty(this.getName())) {
            throw new IllegalArgumentException("Realm has not been configured on this SecurityAuthenticator: " + String.valueOf(this));
        }
        LOG.trace("Login username: {} using realm: {}", (Object)principal.getName(), (Object)this.getName());
        LoginContext context = new LoginContext(this.getName(), new SecurityAuthenticatorSupport.HttpPrincipalCallbackHandler(principal));
        context.login();
        Subject subject = context.getSubject();
        LOG.debug("Login username: {} successful returning Subject: {}", (Object)principal.getName(), (Object)subject);
        if (LOG.isTraceEnabled()) {
            for (Principal p : subject.getPrincipals()) {
                LOG.trace("Principal on subject {} -> {}", (Object)p.getClass().getName(), (Object)p.getName());
            }
        }
        return subject;
    }

    @Override
    public void logout(Subject subject) throws LoginException {
        if (ObjectHelper.isEmpty(this.getName())) {
            throw new LoginException("Realm has not been configured on this SecurityAuthenticator: " + String.valueOf(this));
        }
        String username = "";
        if (!subject.getPrincipals().isEmpty()) {
            username = subject.getPrincipals().iterator().next().getName();
        }
        LOG.trace("Logging out username: {} using realm: {}", (Object)username, (Object)this.getName());
        LoginContext context = new LoginContext(this.getName(), subject);
        context.logout();
        LOG.debug("Logout username: {} successful", (Object)username);
    }
}

