/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpEndpoint;
import org.apache.camel.util.ObjectHelper;

public class NettyHttpConsumer
extends NettyConsumer
implements Suspendable {
    public NettyHttpConsumer(NettyHttpEndpoint nettyEndpoint, Processor processor, NettyConfiguration configuration) {
        super(nettyEndpoint, processor, configuration);
    }

    @Override
    public NettyHttpEndpoint getEndpoint() {
        return (NettyHttpEndpoint)super.getEndpoint();
    }

    @Override
    public NettyHttpConfiguration getConfiguration() {
        return (NettyHttpConfiguration)super.getConfiguration();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ObjectHelper.notNull(this.getNettyServerBootstrapFactory(), "HttpServerBootstrapFactory", this);
        this.getNettyServerBootstrapFactory().addConsumer(this);
    }

    @Override
    protected void doStop() throws Exception {
        this.getNettyServerBootstrapFactory().removeConsumer(this);
        super.doStop();
    }

    @Override
    protected void doSuspend() throws Exception {
        if (!this.getConfiguration().isSend503whenSuspended()) {
            this.doStop();
        }
    }

    @Override
    protected void doResume() throws Exception {
        if (!this.getConfiguration().isSend503whenSuspended()) {
            this.doStart();
        }
    }
}

