/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import java.net.URI;
import java.util.Map;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyEndpoint;
import org.apache.camel.component.netty.http.HttpServerBootstrapFactory;
import org.apache.camel.component.netty.http.JAASSecurityAuthenticator;
import org.apache.camel.component.netty.http.NettyHttpBinding;
import org.apache.camel.component.netty.http.NettyHttpComponent;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpConstants;
import org.apache.camel.component.netty.http.NettyHttpConsumer;
import org.apache.camel.component.netty.http.NettyHttpProducer;
import org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration;
import org.apache.camel.component.netty.http.NettySharedHttpServer;
import org.apache.camel.http.base.cookie.CookieHandler;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.SynchronousDelegateProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.14.0", scheme="netty-http", extendsScheme="netty", title="Netty HTTP", syntax="netty-http:protocol://host:port/path", category={Category.NETWORKING, Category.HTTP}, lenientProperties=true, headersClass=NettyHttpConstants.class)
@Metadata(excludeProperties="textline,delimiter,autoAppendDelimiter,decoderMaxLineLength,encoding,allowDefaultCodec,udpConnectionlessSending,networkInterface,clientMode,reconnect,reconnectInterval,useByteBuf,udpByteArrayCodec,broadcast,correlationManager", annotations={"protocol=http"})
public class NettyHttpEndpoint
extends NettyEndpoint
implements AsyncEndpoint,
HeaderFilterStrategyAware {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpEndpoint.class);
    static final String PROXY_NOT_SUPPORTED_MESSAGE = "Netty Http Producer does not support proxy mode";
    @UriParam
    private NettyHttpConfiguration configuration;
    @UriParam(label="advanced", name="configuration", javaType="org.apache.camel.component.netty.http.NettyHttpConfiguration", description="To use a custom configured NettyHttpConfiguration for configuring this endpoint.")
    private Object httpConfiguration;
    @UriParam(label="advanced")
    private NettyHttpBinding nettyHttpBinding;
    @UriParam(label="advanced")
    private HeaderFilterStrategy headerFilterStrategy;
    @UriParam(label="consumer,advanced")
    private boolean traceEnabled;
    @UriParam(label="consumer,advanced")
    private String httpMethodRestrict;
    @UriParam(label="consumer,advanced")
    private NettySharedHttpServer nettySharedHttpServer;
    @UriParam(label="consumer,security")
    private NettyHttpSecurityConfiguration securityConfiguration;
    @UriParam(label="consumer,security", prefix="securityConfiguration.", multiValue=true)
    private Map<String, Object> securityOptions;
    @UriParam(label="producer")
    private CookieHandler cookieHandler;

    public NettyHttpEndpoint(String endpointUri, NettyHttpComponent component, NettyConfiguration configuration) {
        super(endpointUri, component, configuration);
    }

    @Override
    public NettyHttpComponent getComponent() {
        return (NettyHttpComponent)super.getComponent();
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        NettyHttpConsumer answer = new NettyHttpConsumer(this, processor, (NettyConfiguration)this.getConfiguration());
        this.configureConsumer(answer);
        if (this.nettySharedHttpServer != null) {
            answer.setNettyServerBootstrapFactory(this.nettySharedHttpServer.getServerBootstrapFactory());
            LOG.info("NettyHttpConsumer: {} is using NettySharedHttpServer on port: {}", (Object)answer, (Object)this.nettySharedHttpServer.getPort());
        } else {
            HttpServerBootstrapFactory factory = this.getComponent().getOrCreateHttpNettyServerBootstrapFactory(answer);
            answer.setNettyServerBootstrapFactory(factory);
            LOG.debug("Created NettyHttpConsumer: {} using HttpServerBootstrapFactory: {}", (Object)answer, (Object)factory);
        }
        return answer;
    }

    @Override
    public Producer createProducer() throws Exception {
        if (this.isProxyProtocol()) {
            this.doFail(new IllegalArgumentException(PROXY_NOT_SUPPORTED_MESSAGE));
        }
        NettyHttpProducer answer = new NettyHttpProducer(this, (NettyConfiguration)this.getConfiguration());
        if (this.getConfiguration().isSynchronous()) {
            return new SynchronousDelegateProducer(answer);
        }
        return answer;
    }

    @Override
    public PollingConsumer createPollingConsumer() throws Exception {
        throw new UnsupportedOperationException("This component does not support polling consumer");
    }

    @Override
    public boolean isLenientProperties() {
        return true;
    }

    @Override
    public void setConfiguration(NettyConfiguration configuration) {
        super.setConfiguration(configuration);
        this.configuration = (NettyHttpConfiguration)configuration;
    }

    @Override
    public NettyHttpConfiguration getConfiguration() {
        return (NettyHttpConfiguration)super.getConfiguration();
    }

    public NettyHttpBinding getNettyHttpBinding() {
        return this.nettyHttpBinding;
    }

    public void setNettyHttpBinding(NettyHttpBinding nettyHttpBinding) {
        this.nettyHttpBinding = nettyHttpBinding;
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
        this.getNettyHttpBinding().setHeaderFilterStrategy(headerFilterStrategy);
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
    }

    public String getHttpMethodRestrict() {
        return this.httpMethodRestrict;
    }

    public void setHttpMethodRestrict(String httpMethodRestrict) {
        this.httpMethodRestrict = httpMethodRestrict;
    }

    public NettySharedHttpServer getNettySharedHttpServer() {
        return this.nettySharedHttpServer;
    }

    public void setNettySharedHttpServer(NettySharedHttpServer nettySharedHttpServer) {
        this.nettySharedHttpServer = nettySharedHttpServer;
    }

    public NettyHttpSecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public void setSecurityConfiguration(NettyHttpSecurityConfiguration securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public Map<String, Object> getSecurityOptions() {
        return this.securityOptions;
    }

    public void setSecurityOptions(Map<String, Object> securityOptions) {
        this.securityOptions = securityOptions;
    }

    public CookieHandler getCookieHandler() {
        return this.cookieHandler;
    }

    public void setCookieHandler(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        ObjectHelper.notNull(this.nettyHttpBinding, "nettyHttpBinding", this);
        ObjectHelper.notNull(this.headerFilterStrategy, "headerFilterStrategy", this);
        if (this.securityConfiguration != null) {
            StringHelper.notEmpty(this.securityConfiguration.getRealm(), "realm", this.securityConfiguration);
            StringHelper.notEmpty(this.securityConfiguration.getConstraint(), "restricted", this.securityConfiguration);
            if (this.securityConfiguration.getSecurityAuthenticator() == null) {
                JAASSecurityAuthenticator jaas = new JAASSecurityAuthenticator();
                jaas.setName(this.securityConfiguration.getRealm());
                LOG.info("No SecurityAuthenticator configured, using JAASSecurityAuthenticator as authenticator: {}", (Object)jaas);
                this.securityConfiguration.setSecurityAuthenticator(jaas);
            }
        }
    }

    private boolean isProxyProtocol() {
        URI baseUri = URI.create(this.getEndpointBaseUri());
        String protocol = baseUri.getScheme();
        return protocol != null && protocol.equalsIgnoreCase("proxy");
    }
}

