/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class NettyHttpEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":protocol://host:port/path";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    @Override
    public boolean isEnabled(String scheme) {
        return "netty-http".equals(scheme);
    }

    @Override
    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "protocol", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "host", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "port", null, false, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "path", null, false, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    @Override
    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    @Override
    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    @Override
    public boolean isLenientProperties() {
        return true;
    }

    static {
        HashSet<String> props = new HashSet<String>(89);
        props.add("allowSerializedHeaders");
        props.add("backlog");
        props.add("bossCount");
        props.add("bossGroup");
        props.add("bridgeEndpoint");
        props.add("bridgeErrorHandler");
        props.add("channelGroup");
        props.add("chunkedMaxContentLength");
        props.add("clientInitializerFactory");
        props.add("compression");
        props.add("configuration");
        props.add("connectTimeout");
        props.add("cookieHandler");
        props.add("decoders");
        props.add("disableStreamCache");
        props.add("disconnect");
        props.add("disconnectOnNoReply");
        props.add("enabledProtocols");
        props.add("encoders");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("headerFilterStrategy");
        props.add("host");
        props.add("hostnameVerification");
        props.add("httpMethodRestrict");
        props.add("keepAlive");
        props.add("keyStoreFile");
        props.add("keyStoreFormat");
        props.add("keyStoreResource");
        props.add("lazyChannelCreation");
        props.add("lazyStartProducer");
        props.add("logWarnOnBadRequest");
        props.add("mapHeaders");
        props.add("matchOnUriPrefix");
        props.add("maxChunkSize");
        props.add("maxHeaderSize");
        props.add("maxInitialLineLength");
        props.add("muteException");
        props.add("nativeTransport");
        props.add("needClientAuth");
        props.add("nettyHttpBinding");
        props.add("nettyServerBootstrapFactory");
        props.add("nettySharedHttpServer");
        props.add("noReplyLogLevel");
        props.add("okStatusCodeRange");
        props.add("options");
        props.add("passphrase");
        props.add("path");
        props.add("port");
        props.add("producerPoolBlockWhenExhausted");
        props.add("producerPoolEnabled");
        props.add("producerPoolMaxIdle");
        props.add("producerPoolMaxTotal");
        props.add("producerPoolMaxWait");
        props.add("producerPoolMinEvictableIdle");
        props.add("producerPoolMinIdle");
        props.add("protocol");
        props.add("receiveBufferSize");
        props.add("receiveBufferSizePredictor");
        props.add("requestTimeout");
        props.add("reuseAddress");
        props.add("reuseChannel");
        props.add("securityConfiguration");
        props.add("securityOptions");
        props.add("securityProvider");
        props.add("send503whenSuspended");
        props.add("sendBufferSize");
        props.add("serverClosedChannelExceptionCaughtLogLevel");
        props.add("serverExceptionCaughtLogLevel");
        props.add("serverInitializerFactory");
        props.add("ssl");
        props.add("sslClientCertHeaders");
        props.add("sslContextParameters");
        props.add("sslHandler");
        props.add("sync");
        props.add("synchronous");
        props.add("tcpNoDelay");
        props.add("throwExceptionOnFailure");
        props.add("traceEnabled");
        props.add("transferException");
        props.add("transferExchange");
        props.add("trustStoreFile");
        props.add("trustStoreResource");
        props.add("unixDomainSocketPath");
        props.add("urlDecodeHeaders");
        props.add("useRelativePath");
        props.add("usingExecutorService");
        props.add("workerCount");
        props.add("workerGroup");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(1);
        secretProps.add("passphrase");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(2);
        prefixes.add("option.");
        prefixes.add("securityConfiguration.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

