/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.ReferenceCountUtil;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.component.netty.http.NettyHttpBinding;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpEndpoint;
import org.apache.camel.component.netty.http.NettyHttpHelper;
import org.apache.camel.component.netty.http.NettyHttpMessage;
import org.apache.camel.http.base.cookie.CookieHandler;
import org.apache.camel.support.SynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpProducer
extends NettyProducer {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpProducer.class);
    private int minOkRange;
    private int maxOkRange;

    public NettyHttpProducer(NettyHttpEndpoint nettyEndpoint, NettyConfiguration configuration) {
        super(nettyEndpoint, configuration);
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        String range = this.getEndpoint().getConfiguration().getOkStatusCodeRange();
        this.parseStatusRange(range);
    }

    private void parseStatusRange(String range) {
        if (!range.contains(",") && !org.apache.camel.support.http.HttpUtil.parseStatusRange(range, this::setRanges)) {
            this.maxOkRange = this.minOkRange = Integer.parseInt(range);
        }
    }

    private void setRanges(int minOkRange, int maxOkRange) {
        this.minOkRange = minOkRange;
        this.maxOkRange = maxOkRange;
    }

    @Override
    public NettyHttpEndpoint getEndpoint() {
        return (NettyHttpEndpoint)super.getEndpoint();
    }

    @Override
    public NettyHttpConfiguration getConfiguration() {
        return (NettyHttpConfiguration)super.getConfiguration();
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.getConfiguration().isDisableStreamCache() || this.getConfiguration().isHttpProxy()) {
            exchange.getExchangeExtension().setStreamCacheDisabled(true);
        }
        return super.process(exchange, new NettyHttpProducerCallback(exchange, callback, this.getConfiguration()));
    }

    @Override
    protected Object getRequestBody(Exchange exchange) throws Exception {
        CookieHandler cookieHandler;
        NettyHttpEndpoint endpoint = this.getEndpoint();
        String uri = NettyHttpHelper.createURL(exchange, endpoint);
        URI u = NettyHttpHelper.createURI(exchange, uri);
        NettyHttpBinding nettyHttpBinding = endpoint.getNettyHttpBinding();
        HttpRequest request = nettyHttpBinding.toNettyRequest(exchange.getIn(), u.toString(), this.getConfiguration());
        exchange.getIn().setHeader("CamelHttpUrl", uri);
        if (!HttpUtil.isKeepAlive(request)) {
            exchange.setProperty("CamelNettyCloseChannelWhenComplete", (Object)true);
        }
        if (this.getConfiguration().isBridgeEndpoint()) {
            exchange.getIn().removeHeader("host");
        }
        if ((cookieHandler = endpoint.getCookieHandler()) != null) {
            Map<String, List<String>> cookieHeaders = cookieHandler.loadCookies(exchange, u);
            for (Map.Entry<String, List<String>> entry : cookieHeaders.entrySet()) {
                String key = entry.getKey();
                if (entry.getValue().isEmpty()) continue;
                request.headers().add(key, (Iterable)entry.getValue());
            }
        }
        return request;
    }

    protected void removeCamelHeaders(Exchange exchange) {
        List headersToRemove = exchange.getMessage().getHeaders().keySet().stream().filter(key -> !key.equalsIgnoreCase("CamelHttpResponseCode") && !key.equalsIgnoreCase("CamelHttpResponseText") && key.startsWith("Camel")).collect(Collectors.toList());
        headersToRemove.stream().forEach(header -> exchange.getMessage().removeHeaders((String)header));
    }

    private final class NettyHttpProducerCallback
    implements AsyncCallback {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final NettyHttpConfiguration configuration;

        private NettyHttpProducerCallback(Exchange exchange, AsyncCallback callback, NettyHttpConfiguration configuration) {
            this.exchange = exchange;
            this.callback = callback;
            this.configuration = configuration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done(boolean doneSync) {
            try {
                FullHttpResponse response;
                NettyHttpMessage nettyMessage;
                if (!doneSync && (nettyMessage = this.exchange.getMessage(NettyHttpMessage.class)) != null && (response = nettyMessage.getHttpResponse()) != null) {
                    response.content().retain();
                    this.exchange.getExchangeExtension().addOnCompletion(new SynchronizationAdapter(){

                        @Override
                        public void onDone(Exchange exchange) {
                            if (response.refCnt() > 0) {
                                LOG.debug("Releasing Netty HttpResponse ByteBuf");
                                ReferenceCountUtil.release(response);
                            }
                        }
                    });
                    String actualUrl = this.exchange.getIn().getHeader("CamelHttpUrl", String.class);
                    int code = response.status() != null ? response.status().code() : -1;
                    LOG.debug("Http responseCode: {}", (Object)code);
                    boolean ok = NettyHttpProducer.this.minOkRange > 0 ? code >= NettyHttpProducer.this.minOkRange && code <= NettyHttpProducer.this.maxOkRange : org.apache.camel.support.http.HttpUtil.isStatusCodeOk(code, this.configuration.getOkStatusCodeRange());
                    if (ok) {
                        NettyHttpProducer.this.removeCamelHeaders(this.exchange);
                    } else if (NettyHttpProducer.this.getConfiguration().isThrowExceptionOnFailure()) {
                        Exception cause = NettyHttpHelper.populateNettyHttpOperationFailedException(this.exchange, actualUrl, response, code, NettyHttpProducer.this.getConfiguration().isTransferException());
                        this.exchange.setException(cause);
                    }
                }
            }
            finally {
                this.callback.done(doneSync);
            }
        }
    }
}

