/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.handler.codec.http.HttpRequest;
import java.net.URI;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.netty.http.DefaultNettyHttpBinding;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpHelper;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.spi.HeaderFilterStrategy;

public class RestNettyHttpBinding
extends DefaultNettyHttpBinding {
    public RestNettyHttpBinding() {
    }

    public RestNettyHttpBinding(HeaderFilterStrategy headerFilterStrategy) {
        super(headerFilterStrategy);
    }

    @Override
    public RestNettyHttpBinding copy() {
        try {
            return (RestNettyHttpBinding)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException(e);
        }
    }

    @Override
    public void populateCamelHeaders(HttpRequest request, Map<String, Object> headers, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        super.populateCamelHeaders(request, headers, exchange, configuration);
        String path = request.uri();
        if (path == null) {
            return;
        }
        URI uri = new URI(path);
        path = uri.getPath();
        String consumerPath = configuration.getPath();
        if (this.useRestMatching(consumerPath)) {
            HttpHelper.evalPlaceholders((k, v) -> NettyHttpHelper.appendHeader(headers, k, v), path, consumerPath);
        }
    }

    private boolean useRestMatching(String path) {
        return path.indexOf(123) > -1;
    }
}

