/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.netty.NettyConverter;
import org.apache.camel.component.netty.http.InboundStreamHttpRequest;
import org.apache.camel.component.netty.http.InboundStreamHttpResponse;
import org.apache.camel.component.netty.http.NettyChannelBufferStreamCache;
import org.apache.camel.component.netty.http.NettyChannelBufferStreamCacheOnCompletion;
import org.apache.camel.component.netty.http.NettyHttpBinding;
import org.apache.camel.component.netty.http.NettyHttpConfiguration;
import org.apache.camel.component.netty.http.NettyHttpConstants;
import org.apache.camel.component.netty.http.NettyHttpHeaderFilterStrategy;
import org.apache.camel.component.netty.http.NettyHttpHelper;
import org.apache.camel.component.netty.http.NettyHttpMessage;
import org.apache.camel.component.netty.http.OutboundStreamHttpRequest;
import org.apache.camel.component.netty.http.OutboundStreamHttpResponse;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.ExceptionHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.support.http.HttpUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNettyHttpBinding
implements NettyHttpBinding,
Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNettyHttpBinding.class);
    private HeaderFilterStrategy headerFilterStrategy = new NettyHttpHeaderFilterStrategy();

    public DefaultNettyHttpBinding() {
    }

    public DefaultNettyHttpBinding(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public DefaultNettyHttpBinding copy() {
        try {
            return (DefaultNettyHttpBinding)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException(e);
        }
    }

    @Override
    public Message toCamelMessage(final FullHttpRequest request, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        LOG.trace("toCamelMessage: {}", (Object)request);
        NettyHttpMessage answer = new NettyHttpMessage(exchange.getContext(), request, null);
        answer.setExchange(exchange);
        if (configuration.isMapHeaders()) {
            this.populateCamelHeaders(request, answer.getHeaders(), exchange, configuration);
        }
        if (configuration.isHttpProxy() || configuration.isDisableStreamCache()) {
            answer.setBody(request.content().retain());
            answer.getExchange().getExchangeExtension().setStreamCacheDisabled(true);
            exchange.getExchangeExtension().addOnCompletion(new SynchronizationAdapter(){

                @Override
                public void onDone(Exchange exchange) {
                    if (request.content().refCnt() > 0) {
                        LOG.debug("Releasing Netty HttpResponse ByteBuf");
                        ReferenceCountUtil.release(request.content());
                    }
                }
            });
        } else {
            NettyChannelBufferStreamCache cache = new NettyChannelBufferStreamCache(request.content());
            exchange.getExchangeExtension().addOnCompletion(new NettyChannelBufferStreamCacheOnCompletion(cache));
            answer.setBody(cache);
        }
        return answer;
    }

    @Override
    public Message toCamelMessage(InboundStreamHttpRequest request, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        LOG.trace("toCamelMessage: {}", (Object)request);
        NettyHttpMessage answer = new NettyHttpMessage(exchange.getContext(), null, null);
        answer.setExchange(exchange);
        if (configuration.isMapHeaders()) {
            this.populateCamelHeaders(request.getHttpRequest(), answer.getHeaders(), exchange, configuration);
        }
        answer.setBody(request.getInputStream());
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateCamelHeaders(HttpRequest request, Map<String, Object> headers, Exchange exchange, NettyHttpConfiguration configuration) throws Exception {
        LOG.trace("populateCamelHeaders: {}", (Object)request);
        headers.put("CamelHttpMethod", request.method().name());
        Object s = request.uri();
        if (((String)s).contains("?")) {
            s = StringHelper.before((String)s, "?");
        }
        if (!((String)s).startsWith("http://") && !((String)s).startsWith("https://")) {
            String http = configuration.isSsl() ? "https://" : "http://";
            s = configuration.getPort() != 80 && configuration.getPort() != 443 ? http + configuration.getHost() + ":" + configuration.getPort() + (String)s : http + configuration.getHost() + (String)s;
        }
        headers.put("CamelHttpUrl", s);
        URI uri = new URI(request.uri());
        headers.put("CamelHttpUri", uri.getPath());
        headers.put("CamelHttpQuery", uri.getQuery());
        headers.put("CamelHttpRawQuery", uri.getRawQuery());
        headers.put("CamelHttpScheme", uri.getScheme());
        headers.put("CamelHttpHost", uri.getHost());
        int port = uri.getPort();
        headers.put("CamelHttpPort", port > 0 ? port : (configuration.isSsl() || "https".equals(uri.getScheme()) ? 443 : 80));
        String path = DefaultNettyHttpBinding.stripPath(configuration, uri);
        headers.put("CamelHttpPath", path);
        if (LOG.isTraceEnabled()) {
            LOG.trace("HTTP-Method {}", (Object)request.method().name());
            LOG.trace("HTTP-Uri {}", (Object)request.uri());
        }
        for (String name : request.headers().names()) {
            String value;
            if (name.equalsIgnoreCase("content-type")) {
                name = "Content-Type";
            }
            if (name.equalsIgnoreCase("authorization") && (value = request.headers().get(name)) != null && value.trim().startsWith("Basic")) {
                NettyHttpHelper.appendHeader(headers, "CamelHttpAuthentication", "Basic");
            }
            List<String> values = request.headers().getAll(name);
            Iterator<?> it = ObjectHelper.createIterator(values, ",", true);
            while (it.hasNext()) {
                Object extracted = it.next();
                String decoded = this.shouldUrlDecodeHeader(configuration, name, extracted, StandardCharsets.UTF_8);
                LOG.trace("HTTP-header: {}", extracted);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, decoded, exchange)) continue;
                NettyHttpHelper.appendHeader(headers, name, decoded);
            }
        }
        if (!configuration.isHttpProxy() && request.uri().contains("?")) {
            String query = StringHelper.after(request.uri(), "?");
            Map<String, Object> uriParameters = URISupport.parseQuery(query, false, true);
            for (Map.Entry<String, Object> entry : uriParameters.entrySet()) {
                String name = entry.getKey();
                Object values = entry.getValue();
                Iterator<?> it = ObjectHelper.createIterator(values, ",", true);
                while (it.hasNext()) {
                    Object extracted = it.next();
                    String decoded = this.shouldUrlDecodeHeader(configuration, name, extracted, StandardCharsets.UTF_8);
                    LOG.trace("URI-Parameter: {}", extracted);
                    if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, decoded, exchange)) continue;
                    NettyHttpHelper.appendHeader(headers, name, decoded);
                }
            }
        }
        if (request.method().name().equals("POST") && request.headers().get("Content-Type") != null && request.headers().get("Content-Type").startsWith("application/x-www-form-urlencoded") && !configuration.isBridgeEndpoint() && !configuration.isHttpProxy() && request instanceof FullHttpRequest) {
            String body;
            ByteBuf buffer = ((FullHttpRequest)request).content().retain();
            try {
                body = buffer.toString(StandardCharsets.UTF_8);
            }
            finally {
                buffer.release();
            }
            if (org.apache.camel.util.ObjectHelper.isNotEmpty(body)) {
                for (String param : body.split("&")) {
                    String[] pair = param.split("=", 2);
                    if (pair.length == 2) {
                        String name = this.shouldUrlDecodeHeader(configuration, "", (Object)pair[0], StandardCharsets.UTF_8);
                        String value = this.shouldUrlDecodeHeader(configuration, name, (Object)pair[1], StandardCharsets.UTF_8);
                        if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, value, exchange)) continue;
                        NettyHttpHelper.appendHeader(headers, name, value);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid parameter, expected to be a pair but was " + param);
                }
            }
        }
    }

    private static String stripPath(NettyHttpConfiguration configuration, URI uri) {
        String path = uri.getRawPath();
        if (configuration.getPath() != null) {
            String match;
            String matchPath = path.toLowerCase(Locale.US);
            String string = match = configuration.getPath() != null ? configuration.getPath().toLowerCase(Locale.US) : null;
            if (match != null && matchPath.startsWith(match)) {
                path = path.substring(configuration.getPath().length());
            }
        }
        return path;
    }

    protected void copyCamelHeaders(Map<String, Object> headers, Exchange exchange) {
        exchange.getIn().getHeaders().keySet().stream().filter(key -> key.startsWith("Camel")).forEach(key -> headers.put((String)key, exchange.getIn().getHeaders().get(key)));
    }

    @Deprecated(since="4.4.0")
    protected String shouldUrlDecodeHeader(NettyHttpConfiguration configuration, String headerName, Object value, String charset) throws UnsupportedEncodingException {
        return this.shouldUrlDecodeHeader(configuration, headerName, value, Charset.forName(charset));
    }

    protected String shouldUrlDecodeHeader(NettyHttpConfiguration configuration, String headerName, Object value, Charset charset) {
        if ("Content-Type".equals(headerName)) {
            return value.toString();
        }
        if (configuration.isUrlDecodeHeaders()) {
            return URLDecoder.decode(value.toString(), charset);
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message toCamelMessage(FullHttpResponse response, Exchange exchange, NettyHttpConfiguration configuration) {
        LOG.trace("toCamelMessage: {}", (Object)response);
        NettyHttpMessage answer = new NettyHttpMessage(exchange.getContext(), null, response);
        answer.setExchange(exchange);
        if (configuration.isMapHeaders()) {
            this.populateCamelHeaders(response, answer.getHeaders(), exchange, configuration);
        }
        if (configuration.isDisableStreamCache() || configuration.isHttpProxy()) {
            answer.setBody(response.content());
            answer.getExchange().getExchangeExtension().setStreamCacheDisabled(true);
        } else {
            response.retain();
            try {
                byte[] bytes = exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, response.content());
                answer.setBody(bytes);
            }
            finally {
                response.release();
            }
        }
        return answer;
    }

    @Override
    public Message toCamelMessage(InboundStreamHttpResponse response, Exchange exchange, NettyHttpConfiguration configuration) {
        LOG.trace("toCamelMessage: {}", (Object)response);
        NettyHttpMessage answer = new NettyHttpMessage(exchange.getContext(), null, null);
        answer.setExchange(exchange);
        if (configuration.isMapHeaders()) {
            this.populateCamelHeaders(response.getHttpResponse(), answer.getHeaders(), exchange, configuration);
        }
        answer.setBody(response.getInputStream());
        return answer;
    }

    @Override
    public void populateCamelHeaders(HttpResponse response, Map<String, Object> headers, Exchange exchange, NettyHttpConfiguration configuration) {
        LOG.trace("populateCamelHeaders: {}", (Object)response);
        this.copyCamelHeaders(headers, exchange);
        headers.put("CamelHttpResponseCode", response.status().code());
        headers.put("CamelHttpResponseText", response.status().reasonPhrase());
        for (String name : response.headers().names()) {
            if (name.equalsIgnoreCase("content-type")) {
                name = "Content-Type";
            }
            List<String> values = response.headers().getAll(name);
            Iterator<?> it = ObjectHelper.createIterator(values);
            while (it.hasNext()) {
                Object extracted = it.next();
                LOG.trace("HTTP-header: {}", extracted);
                if (this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToExternalHeaders(name, extracted, exchange)) continue;
                NettyHttpHelper.appendHeader(headers, name, extracted);
            }
        }
    }

    @Override
    public HttpResponse toNettyResponse(Message message, NettyHttpConfiguration configuration) throws Exception {
        String connection;
        NettyHttpMessage nettyHttpMessage;
        FullHttpResponse response;
        LOG.trace("toNettyResponse: {}", (Object)message);
        if (message instanceof NettyHttpMessage && (response = (nettyHttpMessage = (NettyHttpMessage)message).getHttpResponse()) != null && nettyHttpMessage.getBody() == null) {
            return response.retain();
        }
        if (message.getBody() instanceof HttpResponse) {
            return (HttpResponse)message.getBody();
        }
        Object body = message.getBody();
        Exception cause = message.getExchange().getException();
        int code = HttpUtil.determineResponseCode(message.getExchange(), body);
        LOG.trace("HTTP Status Code: {}", (Object)code);
        if (cause != null && !configuration.isMuteException()) {
            if (configuration.isTransferException()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(cause);
                oos.flush();
                IOHelper.close(oos, bos);
                body = NettyConverter.toByteBuffer(bos.toByteArray());
                message.setHeader("Content-Type", "application/x-java-serialized-object");
            } else {
                String stackTrace = ExceptionHelper.stackTraceToString(cause);
                body = NettyConverter.toByteBuffer(stackTrace.getBytes());
                message.setHeader("Content-Type", "text/plain");
            }
            ExchangeHelper.setFailureHandled(message.getExchange());
        } else if (cause != null && configuration.isMuteException()) {
            body = NettyConverter.toByteBuffer("".getBytes());
            message.setHeader("Content-Type", "text/plain");
            ExchangeHelper.setFailureHandled(message.getExchange());
        }
        DefaultHttpResponse response2 = null;
        if (body instanceof InputStream && configuration.isDisableStreamCache()) {
            response2 = new OutboundStreamHttpResponse((InputStream)body, new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(code), true));
            response2.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
        if (response2 == null) {
            ByteBuf buffer;
            if (body instanceof ByteBuf) {
                buffer = (ByteBuf)body;
            } else {
                buffer = message.getBody(ByteBuf.class);
                if (buffer == null) {
                    byte[] data = message.getBody(byte[].class);
                    if (data != null) {
                        buffer = NettyConverter.toByteBuffer(data);
                    } else {
                        String str = body != null ? message.getMandatoryBody(String.class) : "";
                        buffer = NettyConverter.toByteBuffer(str.getBytes());
                    }
                }
            }
            if (buffer != null) {
                response2 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(code), buffer, true);
                if (buffer.readerIndex() == buffer.writerIndex()) {
                    buffer.setIndex(0, buffer.writerIndex());
                }
                int len = buffer.readableBytes();
                response2.headers().set(HttpHeaderNames.CONTENT_LENGTH.toString(), (Object)len);
                LOG.trace("Content-Length: {}", (Object)len);
            } else {
                response2 = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(code), false);
            }
        }
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        for (Map.Entry<String, Object> entry : message.getHeaders().entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Iterator<?> it = ObjectHelper.createIterator(value, null, true);
            while (it.hasNext()) {
                String headerValue = tc.convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, headerValue, message.getExchange())) continue;
                LOG.trace("HTTP-Header: {}={}", (Object)key, (Object)headerValue);
                response2.headers().add(key, (Object)headerValue);
            }
        }
        String contentType = MessageHelper.getContentType(message);
        if (contentType != null) {
            LOG.trace("Content-Type: {}", (Object)contentType);
            response2.headers().set(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)contentType);
        }
        if ((connection = message.getHeader(NettyHttpConstants.CONNECTION, String.class)) == null) {
            connection = message.getExchange().getProperty(NettyHttpConstants.CONNECTION, String.class);
        }
        if (connection == null) {
            connection = configuration.isKeepAlive() ? HttpHeaderValues.KEEP_ALIVE.toString() : HttpHeaderValues.CLOSE.toString();
        }
        response2.headers().set(NettyHttpConstants.CONNECTION, (Object)connection);
        if (connection.equalsIgnoreCase(HttpHeaderValues.CLOSE.toString())) {
            message.setHeader("CamelNettyCloseChannelWhenComplete", true);
        }
        LOG.trace("Connection: {}", (Object)connection);
        return response2;
    }

    @Override
    public HttpRequest toNettyRequest(Message message, String fullUri, NettyHttpConfiguration configuration) throws Exception {
        FullHttpRequest givenRequest;
        String headerProtocolVersion;
        LOG.trace("toNettyRequest: {}", (Object)message);
        Object body = message.getBody();
        if (body instanceof HttpRequest) {
            return (HttpRequest)message.getBody();
        }
        Object uriForRequest = fullUri;
        if (configuration.isUseRelativePath()) {
            String rawQuery;
            URI uri = new URI((String)uriForRequest);
            String rawPath = uri.getRawPath();
            if (rawPath != null) {
                uriForRequest = rawPath;
            }
            if ((rawQuery = uri.getRawQuery()) != null) {
                uriForRequest = (String)uriForRequest + "?" + rawQuery;
            }
        }
        HttpVersion protocol = (headerProtocolVersion = message.getHeader("CamelHttpProtocolVersion", String.class)) == null ? HttpVersion.HTTP_1_1 : HttpVersion.valueOf(headerProtocolVersion);
        String headerMethod = message.getHeader("CamelHttpMethod", String.class);
        HttpMethod httpMethod = headerMethod == null ? HttpMethod.GET : HttpMethod.valueOf(headerMethod);
        HttpRequest request = null;
        if (message instanceof NettyHttpMessage && (givenRequest = ((NettyHttpMessage)message).getHttpRequest()) != null && givenRequest.content() == body) {
            request = givenRequest.setProtocolVersion(protocol).setMethod(httpMethod).setUri((String)uriForRequest);
        }
        if (request == null && body instanceof InputStream && configuration.isDisableStreamCache()) {
            request = new OutboundStreamHttpRequest((InputStream)body, new DefaultHttpRequest(protocol, httpMethod, (String)uriForRequest));
            request.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
        if (request == null) {
            request = new DefaultFullHttpRequest(protocol, httpMethod, (String)uriForRequest);
            if (body != null) {
                ByteBuf buffer;
                if (body instanceof ByteBuf) {
                    buffer = (ByteBuf)body;
                } else {
                    byte[] data;
                    buffer = message.getBody(ByteBuf.class);
                    if (buffer == null && (data = message.getMandatoryBody(byte[].class)).length > 0) {
                        buffer = NettyConverter.toByteBuffer(data);
                    }
                }
                if (buffer != null) {
                    if (buffer.readableBytes() > 0) {
                        request = ((DefaultFullHttpRequest)request).replace(buffer);
                        int len = buffer.readableBytes();
                        request.headers().set(HttpHeaderNames.CONTENT_LENGTH.toString(), (Object)len);
                        LOG.trace("Content-Length: {}", (Object)len);
                    } else {
                        buffer.release();
                    }
                }
            }
        }
        HttpMethod method = NettyHttpHelper.createMethod(message, body != null);
        request.setMethod(method);
        TypeConverter tc = message.getExchange().getContext().getTypeConverter();
        Map<String, Object> skipRequestHeaders = null;
        if (configuration.isBridgeEndpoint()) {
            String queryString = message.getHeader("CamelHttpQuery", String.class);
            if (queryString != null) {
                skipRequestHeaders = URISupport.parseQuery(queryString, false, true);
            }
            message.getHeaders().remove("host");
        }
        for (Map.Entry entry : message.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (skipRequestHeaders != null && skipRequestHeaders.containsKey(key)) continue;
            Iterator<?> it = ObjectHelper.createIterator(value, null, true);
            while (it.hasNext()) {
                String headerValue = tc.convertTo(String.class, it.next());
                if (headerValue == null || this.headerFilterStrategy == null || this.headerFilterStrategy.applyFilterToCamelHeaders(key, headerValue, message.getExchange())) continue;
                LOG.trace("HTTP-Header: {}={}", (Object)key, (Object)headerValue);
                request.headers().add(key, (Object)headerValue);
            }
        }
        String contentType = MessageHelper.getContentType(message);
        if (contentType != null) {
            request.headers().set(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)contentType);
            LOG.trace("Content-Type: {}", (Object)contentType);
        }
        URI uRI = new URI(fullUri);
        int port = uRI.getPort();
        String hostHeader = uRI.getHost() + (String)(port == 80 || port == -1 ? "" : ":" + uRI.getPort());
        request.headers().set(HttpHeaderNames.HOST.toString(), (Object)hostHeader);
        LOG.trace("Host: {}", (Object)hostHeader);
        String connection = message.getHeader(NettyHttpConstants.CONNECTION, String.class);
        if (connection == null) {
            connection = configuration.isKeepAlive() ? HttpHeaderValues.KEEP_ALIVE.toString() : HttpHeaderValues.CLOSE.toString();
        }
        request.headers().set(NettyHttpConstants.CONNECTION, (Object)connection);
        LOG.trace("Connection: {}", (Object)connection);
        return request;
    }

    @Override
    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    @Override
    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }
}

