/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedStream;
import java.io.InputStream;

public class OutboundStreamHttpRequest
extends DefaultHttpRequest
implements ChunkedInput<HttpContent> {
    private final HttpChunkedInput input;

    public OutboundStreamHttpRequest(InputStream in, DefaultHttpRequest request) {
        super(request.protocolVersion(), request.method(), request.uri());
        this.input = new HttpChunkedInput(new ChunkedStream(in));
    }

    public DefaultHttpRequest getRequest() {
        return new DefaultHttpRequest(this.protocolVersion(), this.method(), this.uri(), this.headers());
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        return this.input.isEndOfInput();
    }

    @Override
    public void close() throws Exception {
        this.input.close();
    }

    @Override
    @Deprecated
    public HttpContent readChunk(ChannelHandlerContext channelHandlerContext) throws Exception {
        return this.input.readChunk(channelHandlerContext);
    }

    @Override
    public HttpContent readChunk(ByteBufAllocator byteBufAllocator) throws Exception {
        return this.input.readChunk(byteBufAllocator);
    }

    @Override
    public long length() {
        return this.input.length();
    }

    @Override
    public long progress() {
        return this.input.progress();
    }
}

