/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.cloud.DiscoverableService;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.apache.camel.impl.cloud.ServiceRegistryHelper;
import org.apache.camel.impl.cloud.ServiceRegistrySelectors;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="4.7")
@ManagedResource(description="Service Registration Route policy")
public class ServiceRegistrationRoutePolicy
extends RoutePolicySupport
implements CamelContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceRegistrationRoutePolicy.class);
    private final ServiceRegistry.Selector serviceRegistrySelector;
    private ServiceRegistry serviceRegistry;
    private CamelContext camelContext;

    public ServiceRegistrationRoutePolicy() {
        this(null, ServiceRegistrySelectors.DEFAULT_SELECTOR);
    }

    public ServiceRegistrationRoutePolicy(ServiceRegistry.Selector serviceRegistrySelector) {
        this(null, serviceRegistrySelector);
    }

    public ServiceRegistrationRoutePolicy(ServiceRegistry serviceRegistry, ServiceRegistry.Selector serviceRegistrySelector) {
        this.serviceRegistry = serviceRegistry;
        this.serviceRegistrySelector = serviceRegistrySelector;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void doStart() throws Exception {
        if (this.serviceRegistry == null) {
            this.serviceRegistry = ServiceRegistryHelper.lookupService(this.camelContext, this.serviceRegistrySelector).orElseThrow(() -> new IllegalStateException("ServiceRegistry service not found"));
        }
        LOGGER.debug("ServiceRegistrationRoutePolicy {} is using ServiceRegistry instance {} (id={}, type={})", new Object[]{this, this.serviceRegistry, this.serviceRegistry.getId(), this.serviceRegistry.getClass().getName()});
    }

    @Override
    public void onStart(Route route) {
        this.register(route);
    }

    @Override
    public void onStop(Route route) {
        this.deregister(route);
    }

    @Override
    public void onSuspend(Route route) {
        this.deregister(route);
    }

    @Override
    public void onResume(Route route) {
        this.register(route);
    }

    private void register(Route route) {
        this.computeServiceDefinition(route).ifPresent(this.serviceRegistry::register);
    }

    private void deregister(Route route) {
        this.computeServiceDefinition(route).ifPresent(this.serviceRegistry::deregister);
    }

    /*
     * WARNING - void declaration
     */
    private Optional<ServiceDefinition> computeServiceDefinition(Route route) {
        void var5_10;
        void var5_8;
        Endpoint endpoint = route.getConsumer().getEndpoint();
        HashMap<String, String> properties = new HashMap<String, String>();
        if (endpoint instanceof DiscoverableService) {
            DiscoverableService service = (DiscoverableService)((Object)endpoint);
            properties.putAll(service.getServiceProperties());
        }
        for (Map.Entry entry : route.getProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith("service.")) continue;
            String key = (String)entry.getKey();
            String val = this.camelContext.getTypeConverter().convertTo(String.class, entry.getValue());
            properties.put(key, val);
        }
        String serviceName = (String)properties.get("service.name");
        if (serviceName == null && (serviceName = route.getGroup()) != null) {
            properties.put("service.name", serviceName);
        }
        if (ObjectHelper.isEmpty(serviceName)) {
            LOGGER.debug("Route {} has not enough information for service registration", (Object)route);
            return Optional.empty();
        }
        String string = (String)properties.get("service.id");
        if (string == null) {
            boolean custom = "true".equals(route.getProperties().get("customId"));
            if (custom) {
                String string2 = route.getId();
            }
            if (var5_8 != null) {
                properties.put("service.id", (String)var5_8);
            }
        }
        if (var5_8 == null) {
            String string3 = this.getCamelContext().getUuidGenerator().generateUuid();
        }
        String serviceHost = (String)properties.get("service.host");
        String servicePort = properties.getOrDefault("service.port", "-1");
        return Optional.of(new DefaultServiceDefinition((String)var5_10, serviceName, serviceHost, Integer.parseInt(servicePort), properties));
    }
}

