/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.component.netty.NettyConsumer;
import org.apache.camel.component.netty.NettyServerBootstrapConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.NettyServerBossPoolBuilder;
import org.apache.camel.component.netty.NettyWorkerPoolBuilder;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTCPNettyServerBootstrapFactory
extends ServiceSupport
implements NettyServerBootstrapFactory {
    protected static final Logger LOG = LoggerFactory.getLogger(SingleTCPNettyServerBootstrapFactory.class);
    private ChannelGroup allChannels;
    private CamelContext camelContext;
    private ThreadFactory threadFactory;
    private NettyServerBootstrapConfiguration configuration;
    private ChannelInitializer<Channel> pipelineFactory;
    private ServerBootstrap serverBootstrap;
    private Channel channel;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    @Override
    public void init(CamelContext camelContext, NettyServerBootstrapConfiguration configuration, ChannelInitializer<Channel> pipelineFactory) {
        this.camelContext = camelContext;
        this.configuration = configuration;
        this.pipelineFactory = pipelineFactory;
        this.allChannels = configuration.getChannelGroup() != null ? configuration.getChannelGroup() : new DefaultChannelGroup(SingleTCPNettyServerBootstrapFactory.class.getName(), ImmediateEventExecutor.INSTANCE);
    }

    @Override
    public void init(ThreadFactory threadFactory, NettyServerBootstrapConfiguration configuration, ChannelInitializer<Channel> pipelineFactory) {
        this.threadFactory = threadFactory;
        this.configuration = configuration;
        this.pipelineFactory = pipelineFactory;
        this.allChannels = configuration.getChannelGroup() != null ? configuration.getChannelGroup() : new DefaultChannelGroup(SingleTCPNettyServerBootstrapFactory.class.getName(), ImmediateEventExecutor.INSTANCE);
    }

    @Override
    public void addChannel(Channel channel) {
        this.allChannels.add(channel);
    }

    @Override
    public void removeChannel(Channel channel) {
        this.allChannels.remove(channel);
    }

    @Override
    public void addConsumer(NettyConsumer consumer) {
    }

    @Override
    public void removeConsumer(NettyConsumer consumer) {
    }

    @Override
    protected void doStart() throws Exception {
        if (this.camelContext == null && this.threadFactory == null) {
            throw new IllegalArgumentException("Either CamelContext or ThreadFactory must be set on " + String.valueOf(this));
        }
        this.startServerBootstrap();
    }

    @Override
    protected void doStop() throws Exception {
        this.stopServerBootstrap();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void startServerBootstrap() throws Exception {
        void var4_7;
        Map<String, Object> options;
        EventLoopGroup bg = this.configuration.getBossGroup();
        EventLoopGroup wg = this.configuration.getWorkerGroup();
        if (bg == null) {
            bg = this.bossGroup = new NettyServerBossPoolBuilder().withNativeTransport(this.configuration.isNativeTransport()).withBossCount(this.configuration.getBossCount()).withName("NettyServerTCPBoss").build();
        }
        if (wg == null) {
            wg = this.workerGroup = new NettyWorkerPoolBuilder().withNativeTransport(this.configuration.isNativeTransport()).withWorkerCount(this.configuration.getWorkerCount()).withName("NettyServerTCPWorker").build();
        }
        this.serverBootstrap = new ServerBootstrap();
        if (this.configuration.getUnixDomainSocketPath() != null) {
            if (KQueue.isAvailable()) {
                this.serverBootstrap.group(bg, wg).channel(KQueueServerDomainSocketChannel.class);
            } else {
                if (!Epoll.isAvailable()) throw new IllegalStateException("Unable to use unix domain sockets - both Epoll and KQueue are not available");
                this.serverBootstrap.group(bg, wg).channel(EpollServerDomainSocketChannel.class);
            }
        } else if (this.configuration.isNativeTransport()) {
            if (KQueue.isAvailable()) {
                this.serverBootstrap.group(bg, wg).channel(KQueueServerSocketChannel.class);
            } else {
                if (!Epoll.isAvailable()) throw new IllegalStateException("Unable to use native transport - both Epoll and KQueue are not available");
                this.serverBootstrap.group(bg, wg).channel(EpollServerSocketChannel.class);
            }
        } else {
            this.serverBootstrap.group(bg, wg).channel(NioServerSocketChannel.class);
        }
        if (this.configuration.getUnixDomainSocketPath() == null) {
            this.serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, this.configuration.isKeepAlive());
            this.serverBootstrap.childOption(ChannelOption.TCP_NODELAY, this.configuration.isTcpNoDelay());
            this.serverBootstrap.option(ChannelOption.SO_REUSEADDR, this.configuration.isReuseAddress());
            this.serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, this.configuration.isReuseAddress());
        }
        this.serverBootstrap.childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.configuration.getConnectTimeout());
        if (this.configuration.getBacklog() > 0) {
            this.serverBootstrap.option(ChannelOption.SO_BACKLOG, this.configuration.getBacklog());
        }
        if ((options = this.configuration.getOptions()) != null) {
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                String value = entry.getValue().toString();
                ChannelOption option = ChannelOption.valueOf(entry.getKey());
                if (EndpointHelper.isReferenceParameter(value)) {
                    String name = value.substring(1);
                    Object o = CamelContextHelper.mandatoryLookup(this.camelContext, name);
                    this.serverBootstrap.option(option, o);
                    continue;
                }
                this.serverBootstrap.option(option, value);
            }
        }
        this.serverBootstrap.childHandler(this.pipelineFactory);
        LOG.debug("Created ServerBootstrap {}", (Object)this.serverBootstrap);
        if (this.configuration.getUnixDomainSocketPath() != null) {
            Path udsPath = Path.of(this.configuration.getUnixDomainSocketPath(), new String[0]).toAbsolutePath();
            LOG.info("ServerBootstrap binding to {}", (Object)udsPath);
            DomainSocketAddress domainSocketAddress = new DomainSocketAddress(udsPath.toFile());
        } else {
            LOG.info("ServerBootstrap binding to {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
            InetSocketAddress inetSocketAddress = new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort());
        }
        ChannelFuture channelFuture = this.serverBootstrap.bind((SocketAddress)var4_7).sync();
        this.channel = channelFuture.channel();
        this.allChannels.add(this.channel);
    }

    protected void stopServerBootstrap() {
        if (this.configuration.getUnixDomainSocketPath() != null) {
            Path udsPath = Path.of(this.configuration.getUnixDomainSocketPath(), new String[0]).toAbsolutePath();
            LOG.info("ServerBootstrap unbinding from {}", (Object)udsPath);
        } else {
            LOG.info("ServerBootstrap unbinding from {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
        }
        LOG.trace("Closing {} channels", (Object)this.allChannels.size());
        this.allChannels.close().awaitUninterruptibly();
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
            this.bossGroup = null;
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.workerGroup = null;
        }
    }
}

