/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.component.netty.http.NettyHttpEndpoint;
import org.apache.camel.component.netty.http.NettyHttpOperationFailedException;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class NettyHttpHelper {
    private NettyHttpHelper() {
    }

    public static void appendHeader(Map<String, Object> headers, String key, Object value) {
        CollectionHelper.appendEntry(headers, key, value);
    }

    public static HttpMethod createMethod(Message message, boolean hasPayload) {
        HttpMethod m = message.getHeader("CamelHttpMethod", HttpMethod.class);
        if (m != null) {
            return m;
        }
        String name = message.getHeader("CamelHttpMethod", String.class);
        if (name != null) {
            name = name.toUpperCase();
            return HttpMethod.valueOf(name);
        }
        if (hasPayload) {
            return HttpMethod.POST;
        }
        return HttpMethod.GET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exception populateNettyHttpOperationFailedException(Exchange exchange, String url, FullHttpResponse response, int responseCode, boolean transferException) {
        InputStream is;
        String contentType;
        String statusText = response.status().reasonPhrase();
        if (responseCode >= 300 && responseCode < 400) {
            String redirectLocation = response.headers().get("location");
            if (redirectLocation != null) {
                return new NettyHttpOperationFailedException(url, responseCode, statusText, redirectLocation, response);
            }
            return new NettyHttpOperationFailedException(url, responseCode, statusText, null, response);
        }
        if (transferException && "application/x-java-serialized-object".equals(contentType = response.headers().get("Content-Type")) && (is = exchange.getContext().getTypeConverter().convertTo(InputStream.class, response)) != null) {
            try {
                Object body = NettyHttpHelper.deserializeJavaObjectFromStream(is);
                if (body instanceof Exception) {
                    Exception exception = (Exception)body;
                    return exception;
                }
            }
            catch (Exception e) {
                Exception exception = e;
                return exception;
            }
            finally {
                IOHelper.close((Closeable)is);
            }
        }
        return new NettyHttpOperationFailedException(url, responseCode, statusText, null, response);
    }

    public static Object deserializeJavaObjectFromStream(InputStream is) throws ClassNotFoundException, IOException {
        if (is == null) {
            return null;
        }
        Object answer = null;
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            answer = ois.readObject();
        }
        finally {
            IOHelper.close((Closeable)ois);
        }
        return answer;
    }

    public static String createURL(Exchange exchange, NettyHttpEndpoint endpoint) {
        Object uri = (String)exchange.getIn().removeHeader("CamelRestHttpUri");
        if (uri == null) {
            uri = endpoint.getEndpointUri();
        }
        try {
            uri = exchange.getContext().resolvePropertyPlaceholders((String)uri);
        }
        catch (Exception e) {
            throw new RuntimeExchangeException("Cannot resolve property placeholders with uri: " + (String)uri, exchange, e);
        }
        String path = exchange.getIn().getHeader("CamelHttpPath", String.class);
        if (path != null && !path.isEmpty()) {
            int idx;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((idx = ((String)uri).indexOf(63)) == -1) {
                uri = ((String)uri).endsWith("/") ? uri : (String)uri + "/";
                uri = ((String)uri).concat(path);
            } else {
                Object base = ((String)uri).substring(0, idx);
                base = ((String)base).endsWith("/") ? base : (String)base + "/";
                base = ((String)base).concat(path);
                uri = ((String)base).concat(((String)uri).substring(idx));
            }
        }
        uri = UnsafeUriCharactersEncoder.encodeHttpURI((String)uri);
        return uri;
    }

    public static URI createURI(Exchange exchange, String url) throws URISyntaxException {
        URI uri = new URI(url);
        String queryString = (String)exchange.getIn().removeHeader("CamelRestHttpQuery");
        if (queryString == null) {
            queryString = exchange.getIn().getHeader("CamelHttpRawQuery", String.class);
        }
        if (queryString == null) {
            queryString = exchange.getIn().getHeader("CamelHttpQuery", String.class);
        }
        if (queryString == null) {
            queryString = uri.getRawQuery();
        }
        if (queryString != null) {
            queryString = UnsafeUriCharactersEncoder.encodeHttpURI(queryString);
            if (ObjectHelper.isEmpty(uri.getPath())) {
                uri = new URI(url + "/");
            }
            uri = URISupport.createURIWithQuery(uri, queryString);
        }
        return uri;
    }
}

