/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nitrite.operation.collection;

import org.apache.camel.Exchange;
import org.apache.camel.component.nitrite.AbstractNitriteOperation;
import org.apache.camel.component.nitrite.NitriteEndpoint;
import org.apache.camel.component.nitrite.operation.CollectionOperation;
import org.dizitart.no2.Filter;
import org.dizitart.no2.FindOptions;
import org.dizitart.no2.NitriteCollection;

public class FindCollectionOperation
extends AbstractNitriteOperation
implements CollectionOperation {
    private Filter filter;
    private FindOptions findOptions;

    public FindCollectionOperation() {
    }

    public FindCollectionOperation(Filter filter) {
        this.filter = filter;
    }

    public FindCollectionOperation(Filter filter, FindOptions findOptions) {
        this.filter = filter;
        this.findOptions = findOptions;
    }

    @Override
    protected void execute(Exchange exchange, NitriteEndpoint endpoint) throws Exception {
        NitriteCollection collection = (NitriteCollection)endpoint.getNitriteCollection();
        if (this.filter != null && this.findOptions != null) {
            exchange.getMessage().setBody(collection.find(this.filter, this.findOptions));
        } else if (this.filter != null) {
            exchange.getMessage().setBody(collection.find(this.filter));
        } else {
            exchange.getMessage().setBody(collection.find());
        }
    }
}

