/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangeExtension;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.NoSuchPropertyException;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StreamCache;
import org.apache.camel.TypeConversionException;
import org.apache.camel.VariableAware;
import org.apache.camel.WrappedFile;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.spi.VariableRepository;
import org.apache.camel.spi.VariableRepositoryFactory;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.MessageSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.Scanner;
import org.apache.camel.util.StringHelper;

public final class ExchangeHelper {
    private static final String DEFAULT_CHARSET_NAME = ObjectHelper.getSystemProperty("org.apache.camel.default.charset", "UTF-8");
    private static final Charset DEFAULT_CHARSET = Charset.forName(DEFAULT_CHARSET_NAME);
    private static Exchange DUMMY;

    private ExchangeHelper() {
    }

    public static Exchange getDummy(CamelContext context) {
        if (DUMMY == null) {
            DUMMY = new DefaultExchange(context);
        }
        return DUMMY;
    }

    public static <T> T getBinding(Exchange exchange, Class<T> type) {
        return exchange != null ? (T)exchange.getProperty("CamelBinding", type) : null;
    }

    public static Endpoint resolveEndpoint(Exchange exchange, Object value) throws NoSuchEndpointException {
        return ExchangeHelper.resolveEndpoint(exchange.getContext(), value);
    }

    public static Endpoint resolveEndpoint(CamelContext context, Object value) throws NoSuchEndpointException {
        Endpoint endpoint;
        if (value == null) {
            throw new NoSuchEndpointException("null");
        }
        if (value instanceof Endpoint) {
            Endpoint ep;
            endpoint = ep = (Endpoint)value;
        } else if (value instanceof NormalizedEndpointUri) {
            NormalizedEndpointUri nu = (NormalizedEndpointUri)value;
            endpoint = CamelContextHelper.getMandatoryEndpoint(context, nu);
        } else {
            String uri = value.toString().trim();
            endpoint = CamelContextHelper.getMandatoryEndpoint(context, uri);
        }
        return endpoint;
    }

    public static Endpoint resolvePrototypeEndpoint(Exchange exchange, Object value) throws NoSuchEndpointException {
        return ExchangeHelper.resolvePrototypeEndpoint(exchange.getContext(), value);
    }

    public static Endpoint resolvePrototypeEndpoint(CamelContext context, Object value) throws NoSuchEndpointException {
        Endpoint endpoint;
        if (value == null) {
            throw new NoSuchEndpointException("null");
        }
        if (value instanceof Endpoint) {
            Endpoint ep;
            endpoint = ep = (Endpoint)value;
        } else if (value instanceof NormalizedEndpointUri) {
            NormalizedEndpointUri nu = (NormalizedEndpointUri)value;
            endpoint = CamelContextHelper.getMandatoryPrototypeEndpoint(context, nu);
        } else {
            String uri = value.toString().trim();
            endpoint = CamelContextHelper.getMandatoryPrototypeEndpoint(context, uri);
        }
        return endpoint;
    }

    public static <T> T getMandatoryProperty(Exchange exchange, String propertyName, Class<T> type) throws NoSuchPropertyException {
        T result = exchange.getProperty(propertyName, type);
        if (result != null) {
            return result;
        }
        throw new NoSuchPropertyException(exchange, propertyName, type);
    }

    public static <T> T getMandatoryHeader(Exchange exchange, String headerName, Class<T> type) throws TypeConversionException, NoSuchHeaderException {
        T answer = exchange.getIn().getHeader(headerName, type);
        if (answer == null) {
            throw new NoSuchHeaderException(exchange, headerName, type);
        }
        return answer;
    }

    public static <T> T getMandatoryHeader(Message message, String headerName, Class<T> type) throws TypeConversionException, NoSuchHeaderException {
        T answer = message.getHeader(headerName, type);
        if (answer == null) {
            throw new NoSuchHeaderException(message.getExchange(), headerName, type);
        }
        return answer;
    }

    public static <T> T getHeaderOrProperty(Exchange exchange, String name, Class<T> type) throws TypeConversionException {
        T answer = exchange.getIn().getHeader(name, type);
        if (answer == null) {
            answer = exchange.getProperty(name, type);
        }
        return answer;
    }

    public static <T> T convertToMandatoryType(Exchange exchange, Class<T> type, Object value) throws TypeConversionException, NoTypeConversionAvailableException {
        return exchange.getContext().getTypeConverter().mandatoryConvertTo(type, exchange, value);
    }

    public static <T> T convertToType(Exchange exchange, Class<T> type, Object value) throws TypeConversionException {
        return exchange.getContext().getTypeConverter().convertTo(type, exchange, value);
    }

    public static Exchange createCorrelatedCopy(Exchange exchange, boolean handover) {
        return ExchangeHelper.createCorrelatedCopy(exchange, handover, false);
    }

    public static Exchange createCorrelatedCopy(Exchange exchange, boolean handover, boolean useSameMessageId) {
        String id = exchange.getExchangeId();
        Exchange copy = exchange.copy();
        if (!useSameMessageId) {
            if (copy.hasOut()) {
                copy.getOut().setMessageId(null);
            }
            copy.getIn().setMessageId(null);
        }
        copy.getExchangeExtension().setUnitOfWork(null);
        if (handover) {
            exchange.getExchangeExtension().handoverCompletions(copy);
        }
        copy.setProperty(ExchangePropertyKey.CORRELATION_ID, (Object)id);
        return copy;
    }

    public static Exchange createCopy(Exchange exchange, boolean preserveExchangeId) {
        Exchange copy = exchange.copy();
        if (preserveExchangeId) {
            copy.setExchangeId(exchange.getExchangeId());
        }
        return copy;
    }

    public static void copyResults(Exchange target, Exchange source2) {
        ExchangeHelper.doCopyResults(target, source2, false);
    }

    public static void copyResultsPreservePattern(Exchange target, Exchange source2) {
        ExchangeHelper.doCopyResults(target, source2, true);
    }

    private static void doCopyResults(Exchange result, Exchange source2, boolean preserverPattern) {
        if (result == source2) {
            ExchangeHelper.copyFromOutMessageConditionally(result, source2);
            return;
        }
        if (source2.hasOut()) {
            ExchangeHelper.copyFromOutMessage(result, source2, preserverPattern);
        } else {
            ExchangeHelper.copyFromInMessage(result, source2, preserverPattern);
        }
        if (source2.hasProperties()) {
            result.getProperties().putAll(source2.getProperties());
        }
        ExchangeExtension sourceExtension = source2.getExchangeExtension();
        sourceExtension.copyInternalProperties(result);
        ExchangeExtension resultExtension = result.getExchangeExtension();
        sourceExtension.copySafeCopyPropertiesTo(resultExtension);
        result.setRouteStop(source2.isRouteStop());
        result.setRollbackOnly(source2.isRollbackOnly());
        result.setRollbackOnlyLast(source2.isRollbackOnlyLast());
        resultExtension.setNotifyEvent(sourceExtension.isNotifyEvent());
        resultExtension.setRedeliveryExhausted(sourceExtension.isRedeliveryExhausted());
        resultExtension.setErrorHandlerHandled(sourceExtension.getErrorHandlerHandled());
        resultExtension.setFailureHandled(sourceExtension.isFailureHandled());
        result.setException(source2.getException());
    }

    private static void copyFromOutMessageConditionally(Exchange result, Exchange source2) {
        if (result.getPattern().isOutCapable() && !result.hasOut() && !result.isFailed()) {
            result.getOut().copyFrom(source2.getIn());
        }
    }

    private static void copyFromInMessage(Exchange result, Exchange source2, boolean preserverPattern) {
        if (!preserverPattern && result.getPattern().isOutCapable()) {
            result.getOut().copyFrom(source2.getIn());
        } else {
            result.getIn().copyFrom(source2.getIn());
            if (result.hasOut()) {
                result.setOut(null);
            }
        }
    }

    private static void copyFromOutMessage(Exchange result, Exchange source2, boolean preserverPattern) {
        if (preserverPattern) {
            Message resultMessage = ExchangeHelper.getResultMessage(result);
            resultMessage.copyFrom(source2.getOut());
        } else {
            result.getOut().copyFrom(source2.getOut());
        }
    }

    public static Message getResultMessage(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            return exchange.getOut();
        }
        return exchange.getIn();
    }

    public static boolean isOutCapable(Exchange exchange) {
        ExchangePattern pattern = exchange.getPattern();
        return pattern != null && pattern.isOutCapable();
    }

    public static <T> T newInstance(Exchange exchange, Class<T> type) {
        return exchange.getContext().getInjector().newInstance(type);
    }

    public static Map<String, Object> createVariableMap(Exchange exchange, boolean allowContextMapAll) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        ExchangeHelper.populateVariableMap(exchange, answer, allowContextMapAll);
        return answer;
    }

    public static void populateVariableMap(Exchange exchange, Map<String, Object> map, boolean allowContextMapAll) {
        Message in = exchange.getIn();
        map.put("headers", in.getHeaders());
        map.put("body", in.getBody());
        map.put("variables", exchange.getVariables());
        if (allowContextMapAll) {
            map.put("in", in);
            map.put("request", in);
            map.put("exchange", exchange);
            map.put("exchangeProperties", exchange.getAllProperties());
            if (ExchangeHelper.isOutCapable(exchange)) {
                Message msg = exchange.getMessage();
                map.put("out", msg);
                map.put("response", msg);
            }
            map.put("camelContext", exchange.getContext());
        }
    }

    public static String getContentType(Exchange exchange) {
        return MessageHelper.getContentType(exchange.getIn());
    }

    public static String getContentEncoding(Exchange exchange) {
        return MessageHelper.getContentEncoding(exchange.getIn());
    }

    public static Object lookupMandatoryBean(Exchange exchange, String name) throws NoSuchBeanException {
        Object value = ExchangeHelper.lookupBean(exchange, name);
        if (value == null) {
            throw new NoSuchBeanException(name);
        }
        return value;
    }

    public static <T> T lookupMandatoryBean(Exchange exchange, String name, Class<T> type) {
        T value = ExchangeHelper.lookupBean(exchange, name, type);
        if (value == null) {
            throw new NoSuchBeanException(name);
        }
        return value;
    }

    public static Object lookupBean(Exchange exchange, String name) {
        return exchange.getContext().getRegistry().lookupByName(name);
    }

    public static <T> T lookupBean(Exchange exchange, String name, Class<T> type) {
        return exchange.getContext().getRegistry().lookupByNameAndType(name, type);
    }

    public static void prepareAggregation(Exchange oldExchange, Exchange newExchange) {
        if (oldExchange != null) {
            ExchangeHelper.prepareOutToIn(oldExchange);
        }
        if (newExchange != null) {
            ExchangeHelper.prepareOutToIn(newExchange);
        }
    }

    public static boolean isFailureHandled(Exchange exchange) {
        return exchange.getExchangeExtension().isFailureHandled();
    }

    public static boolean isErrorHandlerBridge(Exchange exchange) {
        return exchange.getProperty(ExchangePropertyKey.ERRORHANDLER_BRIDGE, (Object)false, Boolean.class);
    }

    public static boolean isUnitOfWorkExhausted(Exchange exchange) {
        return exchange.getProperty(ExchangePropertyKey.UNIT_OF_WORK_EXHAUSTED, (Object)false, Boolean.class);
    }

    public static void setFailureHandled(Exchange exchange) {
        exchange.setException(null);
        exchange.getExchangeExtension().setFailureHandled(true);
    }

    public static boolean isRedelivered(Exchange exchange) {
        return exchange.getIn().hasHeaders() && exchange.getIn().getHeader("CamelRedelivered", false, Boolean.class) != false;
    }

    public static boolean isStreamCachingEnabled(Exchange exchange) {
        Route route = exchange.getContext().getRoute(exchange.getFromRouteId());
        if (route != null) {
            return route.isStreamCaching();
        }
        return exchange.getContext().getStreamCachingStrategy().isEnabled();
    }

    public static Object extractResultBody(Exchange exchange, ExchangePattern pattern) {
        Object answer = null;
        if (exchange != null) {
            if (exchange.getException() != null) {
                throw CamelExecutionException.wrapCamelExecutionException(exchange, exchange.getException());
            }
            boolean notOut = pattern != null && !pattern.isOutCapable();
            boolean hasOut = exchange.hasOut();
            answer = hasOut && !notOut ? exchange.getOut().getBody() : exchange.getIn().getBody();
            if (exchange.getException() != null) {
                throw CamelExecutionException.wrapCamelExecutionException(exchange, exchange.getException());
            }
        }
        return answer;
    }

    public static <T> T extractFutureBody(CamelContext context, Future<?> future, Class<T> type) {
        try {
            T t = ExchangeHelper.doExtractFutureBody(context, future.get(), type);
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        catch (ExecutionException e) {
            throw CamelExecutionException.wrapCamelExecutionException(null, e.getCause());
        }
        finally {
            future.cancel(true);
        }
    }

    public static <T> T extractFutureBody(CamelContext context, Future<?> future, long timeout2, TimeUnit unit, Class<T> type) throws TimeoutException {
        try {
            if (timeout2 > 0L) {
                T t = ExchangeHelper.doExtractFutureBody(context, future.get(timeout2, unit), type);
                return t;
            }
            T t = ExchangeHelper.doExtractFutureBody(context, future.get(), type);
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw CamelExecutionException.wrapCamelExecutionException(null, e);
        }
        catch (ExecutionException e) {
            throw CamelExecutionException.wrapCamelExecutionException(null, e.getCause());
        }
        finally {
            future.cancel(true);
        }
    }

    private static <T> T doExtractFutureBody(CamelContext context, Object result, Class<T> type) {
        if (result == null) {
            return null;
        }
        if (type.isAssignableFrom(result.getClass())) {
            return type.cast(result);
        }
        if (result instanceof Exchange) {
            Exchange exchange = (Exchange)result;
            Object answer = ExchangeHelper.extractResultBody(exchange, exchange.getPattern());
            return context.getTypeConverter().convertTo(type, exchange, answer);
        }
        return context.getTypeConverter().convertTo(type, result);
    }

    public static void prepareOutToIn(Exchange exchange) {
        if (exchange.hasOut()) {
            exchange.setIn(exchange.getOut());
            exchange.setOut(null);
        }
    }

    public static String logIds(Exchange exchange) {
        String msgId = exchange.getMessage().getMessageId();
        return "(MessageId: " + msgId + " on ExchangeId: " + exchange.getExchangeId() + ")";
    }

    private static void setMessageHistory(Exchange target, Exchange source2) {
        Object history = source2.getProperty(ExchangePropertyKey.MESSAGE_HISTORY);
        if (history != null) {
            target.setProperty(ExchangePropertyKey.MESSAGE_HISTORY, new CopyOnWriteArrayList((List)history));
        }
    }

    public static Exchange copyExchangeWithProperties(Exchange exchange, CamelContext context) {
        Exchange answer = exchange.getExchangeExtension().createCopyWithProperties(context);
        ExchangeHelper.setMessageHistory(answer, exchange);
        answer.setIn(exchange.getIn().copy());
        if (exchange.hasOut()) {
            answer.setOut(exchange.getOut().copy());
        }
        answer.setException(exchange.getException());
        return answer;
    }

    public static void replaceMessage(Exchange exchange, Message newMessage, boolean outOnly) {
        Message old = exchange.getMessage();
        if (outOnly || exchange.hasOut()) {
            exchange.setOut(newMessage);
        } else {
            exchange.setIn(newMessage);
        }
        if (old instanceof MessageSupport) {
            MessageSupport messageSupport = (MessageSupport)old;
            messageSupport.setExchange(null);
        }
    }

    public static Message getOriginalInMessage(Exchange exchange) {
        Message answer = null;
        UnitOfWork uow = exchange.getProperty(ExchangePropertyKey.PARENT_UNIT_OF_WORK, UnitOfWork.class);
        if (uow != null) {
            answer = uow.getOriginalInMessage();
        }
        if (answer == null && (uow = exchange.getUnitOfWork()) != null) {
            answer = uow.getOriginalInMessage();
        }
        return answer;
    }

    public static String resolveScheme(String uri) {
        return StringHelper.before(uri, ":");
    }

    public static String getCharsetName(Exchange exchange) {
        return ExchangeHelper.getCharsetName(exchange, true);
    }

    public static Charset getCharset(Exchange exchange) {
        return ExchangeHelper.getCharset(exchange, true);
    }

    public static String getCharsetName(Exchange exchange, boolean useDefault) {
        if (exchange != null) {
            String charsetName = exchange.getIn().getHeader("CamelCharsetName", String.class);
            if (charsetName == null) {
                charsetName = exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
            }
            if (charsetName != null) {
                return IOHelper.normalizeCharset(charsetName);
            }
        }
        if (useDefault) {
            return ExchangeHelper.getDefaultCharsetName();
        }
        return null;
    }

    public static Charset getCharset(Exchange exchange, boolean useDefault) {
        if (exchange != null) {
            String charsetName = exchange.getIn().getHeader("CamelCharsetName", String.class);
            if (charsetName == null) {
                charsetName = exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
            }
            if (charsetName != null) {
                charsetName = IOHelper.normalizeCharset(charsetName);
                return Charset.forName(charsetName);
            }
        }
        if (useDefault) {
            return ExchangeHelper.getDefaultCharset();
        }
        return null;
    }

    private static String getDefaultCharsetName() {
        return DEFAULT_CHARSET_NAME;
    }

    private static Charset getDefaultCharset() {
        return DEFAULT_CHARSET;
    }

    public static Scanner getScanner(Exchange exchange, Object value, String delimiter) {
        Scanner scanner;
        if (value instanceof WrappedFile) {
            WrappedFile gf = (WrappedFile)value;
            Object body = gf.getBody();
            value = body != null ? body : gf.getFile();
        }
        if (value instanceof Readable) {
            Readable readable = (Readable)value;
            scanner = new Scanner(readable, delimiter);
        } else if (value instanceof String) {
            String str = (String)value;
            scanner = new Scanner(str, delimiter);
        } else {
            String charset = exchange.getProperty(ExchangePropertyKey.CHARSET_NAME, String.class);
            if (value instanceof Path) {
                Path path = (Path)value;
                try {
                    scanner = new Scanner(Files.newByteChannel(path, StandardOpenOption.READ), charset, delimiter);
                }
                catch (IOException e) {
                    throw new RuntimeCamelException(e);
                }
            } else if (value instanceof File) {
                File file = (File)value;
                try {
                    scanner = new Scanner(file, charset, delimiter);
                }
                catch (IOException e) {
                    throw new RuntimeCamelException(e);
                }
            } else if (value instanceof InputStream) {
                InputStream inputStream2 = (InputStream)value;
                scanner = new Scanner(inputStream2, charset, delimiter);
            } else if (value instanceof ReadableByteChannel) {
                ReadableByteChannel readableByteChannel = (ReadableByteChannel)value;
                scanner = new Scanner(readableByteChannel, charset, delimiter);
            } else {
                String text = exchange.getContext().getTypeConverter().convertTo(String.class, exchange, value);
                scanner = new Scanner(text, delimiter);
            }
        }
        return scanner;
    }

    public static String getRouteId(Exchange exchange) {
        String answer = ExchangeHelper.getAtRouteId(exchange);
        if (answer == null) {
            answer = exchange.getFromRouteId();
        }
        return answer;
    }

    public static String getAtRouteId(Exchange exchange) {
        String answer = null;
        Route rc = ExchangeHelper.getRoute(exchange);
        if (rc != null) {
            answer = rc.getRouteId();
        }
        return answer;
    }

    public static String getRouteGroup(Exchange exchange) {
        Route rc = ExchangeHelper.getRoute(exchange);
        if (rc != null) {
            return rc.getGroup();
        }
        return null;
    }

    public static Route getRoute(Exchange exchange) {
        UnitOfWork uow = exchange.getUnitOfWork();
        return uow != null ? uow.getRoute() : null;
    }

    public static void setInOutBodyPatternAware(Exchange exchange, Object body) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
            exchange.getOut().setBody(body);
        } else {
            exchange.getIn().setBody(body);
        }
    }

    public static void setOutBodyPatternAware(Exchange exchange, Object body) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
            exchange.getOut().setBody(body);
        }
    }

    public static void setVariable(Exchange exchange, String name, Object value) {
        VariableRepository repo = null;
        String id = ExchangeHelper.getVariableRepositoryId(name);
        if (id != null) {
            repo = ExchangeHelper.getVariableRepository(exchange, id);
            name = ExchangeHelper.resolveVariableRepositoryName(exchange, name, id);
        }
        VariableAware va = ExchangeHelper.getVariableAware(exchange, repo);
        va.setVariable(name, value);
    }

    public static String getVariableRepositoryId(String name) {
        String id = StringHelper.before(name, ":");
        if (ExchangeHelper.isReserved(id)) {
            id = null;
        }
        return id;
    }

    public static String resolveVariableRepositoryName(Exchange exchange, String name, String id) {
        name = StringHelper.after((String)name, ":");
        if ("route".equals(id) && !((String)name).contains(":")) {
            String prefix = ExchangeHelper.getAtRouteId(exchange);
            if (prefix != null) {
                name = prefix + ":" + (String)name;
            } else {
                return null;
            }
        }
        return name;
    }

    public static void setVariableFromMessageBodyAndHeaders(Exchange exchange, String name, Message message) {
        VariableRepository repo = null;
        String id = ExchangeHelper.getVariableRepositoryId(name);
        if (id != null) {
            repo = ExchangeHelper.getVariableRepository(exchange, id);
            name = ExchangeHelper.resolveVariableRepositoryName(exchange, name, id);
        }
        VariableAware va = ExchangeHelper.getVariableAware(exchange, repo);
        Object body = message.getBody();
        va.setVariable(name, body);
        for (Map.Entry<String, Object> header : message.getHeaders().entrySet()) {
            String key = "header:" + name + "." + header.getKey();
            Object value = header.getValue();
            va.setVariable(key, value);
        }
    }

    public static boolean shouldSetVariableResult(Exchange exchange, String name) {
        boolean stop;
        if (name == null) {
            return false;
        }
        boolean bl = stop = exchange.isRouteStop() || exchange.isFailed() || exchange.isRollbackOnly() || exchange.isRollbackOnlyLast() || exchange.getExchangeExtension().isErrorHandlerHandledSet() && exchange.getExchangeExtension().isErrorHandlerHandled();
        return !stop;
    }

    public static Object getVariable(Exchange exchange, String name) {
        VariableRepository repo = null;
        String id = ExchangeHelper.getVariableRepositoryId(name);
        if (id != null) {
            repo = ExchangeHelper.getVariableRepository(exchange, id);
            name = ExchangeHelper.resolveVariableRepositoryName(exchange, name, id);
        }
        VariableAware va = ExchangeHelper.getVariableAware(exchange, repo);
        return va.getVariable(name);
    }

    public static VariableRepository getVariableRepository(Exchange exchange, String id) {
        VariableRepositoryFactory factory = exchange.getContext().getCamelContextExtension().getContextPlugin(VariableRepositoryFactory.class);
        VariableRepository repo = factory.getVariableRepository(id);
        if (repo == null) {
            throw new IllegalArgumentException("VariableRepository with id: " + id + " does not exist");
        }
        return repo;
    }

    private static boolean isReserved(String id) {
        return "header".equals(id) || "exchange".equals(id);
    }

    private static VariableAware getVariableAware(Exchange exchange, VariableRepository repo) {
        VariableAware va = repo != null ? repo : exchange;
        return va;
    }

    public static <T> T getVariable(Exchange exchange, String name, Class<T> type) {
        Object answer = ExchangeHelper.getVariable(exchange, name);
        if (answer != null) {
            return exchange.getContext().getTypeConverter().convertTo(type, exchange, answer);
        }
        return null;
    }

    public static <T> T getBodyAndResetStreamCache(Exchange exchange, Class<T> type) {
        Object body = exchange.getMessage().getBody();
        if (body instanceof StreamCache) {
            StreamCache sc = (StreamCache)body;
            sc.reset();
        }
        return exchange.getMessage().getBody(type);
    }
}

