/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.internals;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.dizitart.no2.Cursor;
import org.dizitart.no2.Document;
import org.dizitart.no2.Filter;
import org.dizitart.no2.FindOptions;
import org.dizitart.no2.Index;
import org.dizitart.no2.IndexType;
import org.dizitart.no2.NitriteContext;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.RemoveOptions;
import org.dizitart.no2.UpdateOptions;
import org.dizitart.no2.WriteResult;
import org.dizitart.no2.event.ChangeInfo;
import org.dizitart.no2.event.ChangeListener;
import org.dizitart.no2.event.EventBus;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.fulltext.EnglishTextTokenizer;
import org.dizitart.no2.fulltext.TextIndexingService;
import org.dizitart.no2.fulltext.TextTokenizer;
import org.dizitart.no2.internals.DataService;
import org.dizitart.no2.internals.IndexMetaService;
import org.dizitart.no2.internals.IndexedSearchService;
import org.dizitart.no2.internals.IndexingService;
import org.dizitart.no2.internals.NitriteTextIndexingService;
import org.dizitart.no2.internals.SearchService;
import org.dizitart.no2.internals.WriteResultImpl;
import org.dizitart.no2.mapper.NitriteMapper;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.ValidationUtils;

public class NitriteService {
    private NitriteContext nitriteContext;
    private final NitriteMap<NitriteId, Document> mapStore;
    private IndexingService indexingService;
    private DataService dataService;
    private SearchService searchService;
    private IndexedSearchService indexedSearchService;
    private IndexMetaService indexMetaService;
    private EventBus<ChangeInfo, ChangeListener> eventBus;
    private ReentrantReadWriteLock readWriteLock;
    private Lock readLock;
    private Lock writeLock;

    NitriteService(NitriteMap<NitriteId, Document> mapStore, NitriteContext nitriteContext, EventBus<ChangeInfo, ChangeListener> eventBus) {
        this.mapStore = mapStore;
        this.nitriteContext = nitriteContext;
        this.eventBus = eventBus;
        this.init();
    }

    public boolean isIndexing(String field) {
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1035));
        return this.indexingService.isIndexing(field);
    }

    public boolean hasIndex(String field) {
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1036));
        return this.indexMetaService.hasIndex(field);
    }

    public Set<NitriteId> findEqualWithIndex(String field, Object value) {
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1037));
        return this.indexedSearchService.findEqual(field, value);
    }

    public Set<NitriteId> findGreaterThanWithIndex(String field, Comparable value) {
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1038));
        ValidationUtils.notNull(value, ErrorMessage.errorMessage("value can not be null", 1039));
        return this.indexedSearchService.findGreaterThan(field, value);
    }

    public Set<NitriteId> findGreaterEqualWithIndex(String field, Comparable value) {
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1040));
        ValidationUtils.notNull(value, ErrorMessage.errorMessage("value can not be null", 1041));
        return this.indexedSearchService.findGreaterEqual(field, value);
    }

    public Set<NitriteId> findLesserThanWithIndex(String field, Comparable value) {
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1042));
        ValidationUtils.notNull(value, ErrorMessage.errorMessage("value can not be null", 1043));
        return this.indexedSearchService.findLesserThan(field, value);
    }

    public Set<NitriteId> findLesserEqualWithIndex(String field, Comparable value) {
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1044));
        ValidationUtils.notNull(value, ErrorMessage.errorMessage("value can not be null", 1045));
        return this.indexedSearchService.findLesserEqual(field, value);
    }

    public Set<NitriteId> findInWithIndex(String field, Collection<Object> values2) {
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1046));
        ValidationUtils.notNull(values2, ErrorMessage.errorMessage("values can not be null", 1047));
        return this.indexedSearchService.findIn(field, values2);
    }

    public Set<NitriteId> findNotInWithIndex(String field, Collection<Object> values2) {
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1086));
        ValidationUtils.notNull(values2, ErrorMessage.errorMessage("values can not be null", 1087));
        return this.indexedSearchService.findNotIn(field, values2);
    }

    public Set<NitriteId> findTextWithIndex(String field, String value) {
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1048));
        ValidationUtils.notNull(value, ErrorMessage.errorMessage("value can not be null", 1049));
        return this.indexedSearchService.findText(field, value);
    }

    public NitriteMapper getNitriteMapper() {
        return this.nitriteContext.getNitriteMapper();
    }

    public NitriteContext getNitriteContext() {
        return this.nitriteContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createIndex(String field, IndexType indexType, boolean async) {
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1050));
        ValidationUtils.notNull((Object)indexType, ErrorMessage.errorMessage("indexType can not be null", 1051));
        try {
            this.writeLock.lock();
            this.indexingService.createIndex(field, indexType, async);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void rebuildIndex(Index index, boolean isAsync) {
        ValidationUtils.notNull(index, ErrorMessage.errorMessage("index can not be null", 1052));
        try {
            this.writeLock.lock();
            this.indexingService.rebuildIndex(index, isAsync);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    Index findIndex(String field) {
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1053));
        try {
            this.readLock.lock();
            Index index = this.indexMetaService.findIndex(field);
            return index;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void dropIndex(String field) {
        ValidationUtils.notNull(field, ErrorMessage.errorMessage("field can not be null", 1054));
        try {
            this.writeLock.lock();
            this.indexingService.dropIndex(field);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void dropAllIndices() {
        try {
            this.writeLock.lock();
            this.indexingService.dropAllIndices();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    Collection<Index> listIndexes() {
        try {
            this.readLock.lock();
            Collection<Index> collection = this.indexingService.listIndexes();
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WriteResultImpl insert(Document document, Document ... documents) {
        ValidationUtils.notNull(document, ErrorMessage.errorMessage("document can not be null", 1055));
        int length = documents == null ? 0 : documents.length;
        try {
            this.writeLock.lock();
            if (length > 0) {
                Document[] array = new Document[length + 1];
                array[0] = document;
                System.arraycopy(documents, 0, array, 1, length);
                WriteResultImpl writeResultImpl = this.dataService.insert(array);
                return writeResultImpl;
            }
            WriteResultImpl writeResultImpl = this.dataService.insert(document);
            return writeResultImpl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    WriteResult insert(Document[] documents) {
        ValidationUtils.notNull(documents, ErrorMessage.errorMessage("documents can not be null", 1056));
        try {
            this.writeLock.lock();
            WriteResultImpl writeResultImpl = this.dataService.insert(documents);
            return writeResultImpl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    Cursor find(Filter filter) {
        try {
            this.readLock.lock();
            Cursor cursor = this.searchService.find(filter);
            return cursor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    Cursor find() {
        try {
            this.readLock.lock();
            Cursor cursor = this.searchService.find();
            return cursor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    Cursor find(FindOptions findOptions) {
        ValidationUtils.notNull(findOptions, ErrorMessage.errorMessage("findOptions can not be null", 1057));
        try {
            this.readLock.lock();
            Cursor cursor = this.searchService.find(findOptions);
            return cursor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Cursor find(Filter filter, FindOptions findOptions) {
        ValidationUtils.notNull(findOptions, ErrorMessage.errorMessage("findOptions can not be null", 1058));
        try {
            this.readLock.lock();
            Cursor cursor = this.searchService.find(filter, findOptions);
            return cursor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    Document getById(NitriteId nitriteId) {
        ValidationUtils.notNull(nitriteId, ErrorMessage.errorMessage("nitriteId can not be null", 1059));
        try {
            this.readLock.lock();
            Document document = this.dataService.getById(nitriteId);
            return document;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WriteResultImpl update(Filter filter, Document update, UpdateOptions updateOptions) {
        ValidationUtils.notNull(update, ErrorMessage.errorMessage("update document can not be null", 1060));
        ValidationUtils.notNull(updateOptions, ErrorMessage.errorMessage("updateOptions can not be null", 1061));
        try {
            this.writeLock.lock();
            WriteResultImpl writeResultImpl = this.dataService.update(filter, update, updateOptions);
            return writeResultImpl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WriteResultImpl remove(Filter filter, RemoveOptions removeOptions) {
        try {
            this.writeLock.lock();
            WriteResultImpl writeResultImpl = this.dataService.remove(filter, removeOptions);
            return writeResultImpl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void dropCollection() {
        try {
            this.writeLock.lock();
            this.indexingService.dropAllIndices();
            this.nitriteContext.dropCollection(this.mapStore.getName());
            this.mapStore.getStore().removeMap(this.mapStore);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private TextIndexingService getTextIndexingService() {
        TextIndexingService textIndexingService = this.nitriteContext.getTextIndexingService();
        TextTokenizer textTokenizer = this.getTextTokenizer();
        if (textIndexingService == null) {
            textIndexingService = new NitriteTextIndexingService(textTokenizer, this.indexMetaService);
        }
        return textIndexingService;
    }

    private TextTokenizer getTextTokenizer() {
        TextTokenizer textTokenizer = this.nitriteContext.getTextTokenizer();
        if (textTokenizer == null) {
            textTokenizer = new EnglishTextTokenizer();
        }
        return textTokenizer;
    }

    private void init() {
        this.readWriteLock = new ReentrantReadWriteLock();
        this.readLock = this.readWriteLock.readLock();
        this.writeLock = this.readWriteLock.writeLock();
        this.indexMetaService = new IndexMetaService(this.mapStore);
        TextIndexingService textIndexingService = this.getTextIndexingService();
        this.indexingService = new IndexingService(this.indexMetaService, textIndexingService, this.nitriteContext);
        this.indexedSearchService = new IndexedSearchService(this.indexMetaService, textIndexingService);
        this.searchService = new SearchService(this, this.mapStore);
        this.dataService = new DataService(this.indexingService, this.searchService, this.mapStore, this.eventBus);
    }
}

