/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.sync;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.sync.CollectionReplicator;
import org.dizitart.no2.sync.EventType;
import org.dizitart.no2.sync.SyncConfig;
import org.dizitart.no2.sync.SyncService;
import org.dizitart.no2.sync.TimeSpan;

public final class SyncHandle {
    private CollectionReplicator replicator;
    private ScheduledExecutorService replicatorPool;
    private ScheduledFuture replicatorHandle;
    private SyncService syncService;
    private boolean stopped = true;
    private SyncConfig syncConfig;
    private boolean paused;

    SyncHandle(SyncConfig syncConfig) {
        this.syncConfig = syncConfig;
    }

    public void startSync() {
        if (!this.stopped) {
            throw new InvalidOperationException(ErrorMessage.REPLICATOR_ALREADY_RUNNING);
        }
        TimeSpan syncDelay = this.syncConfig.getSyncDelay();
        this.replicatorHandle = this.replicatorPool.scheduleWithFixedDelay(this.replicator, 0L, syncDelay.getTime(), syncDelay.getTimeUnit());
        this.stopped = false;
        this.syncService.notifyEvent(EventType.STARTED);
    }

    public void pauseSync() {
        if (this.stopped) {
            return;
        }
        if (this.replicator != null) {
            this.replicator.pause();
        }
        this.paused = true;
    }

    public void resumeSync() {
        if (this.stopped) {
            return;
        }
        if (this.replicator != null) {
            this.replicator.resume();
        }
        this.paused = false;
    }

    public void resetLocalWithRemote(int offset, int size) {
        if (this.syncService != null) {
            this.syncService.resetLocalWithRemote(offset, size);
        }
    }

    public void resetRemoteWithLocal(int offset, int size) {
        if (this.syncService != null) {
            this.syncService.resetRemoteWithLocal(offset, size);
        }
    }

    public void cancelSync() {
        if (this.replicatorHandle != null && !this.replicatorHandle.isCancelled()) {
            this.replicatorHandle.cancel(true);
        }
        this.syncService.notifyEvent(EventType.CANCELED);
    }

    public boolean isCancelled() {
        return this.replicatorHandle == null || this.replicatorHandle.isCancelled();
    }

    public void stopSync() {
        if (this.replicator != null) {
            this.replicator.stop();
            this.stopped = true;
            this.syncService.notifyEvent(EventType.STOPPED);
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    void setReplicator(CollectionReplicator replicator) {
        this.replicator = replicator;
    }

    void setReplicatorPool(ScheduledExecutorService replicatorPool) {
        this.replicatorPool = replicatorPool;
    }

    void setReplicatorHandle(ScheduledFuture replicatorHandle) {
        this.replicatorHandle = replicatorHandle;
    }

    void setSyncService(SyncService syncService) {
        this.syncService = syncService;
    }

    void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public boolean isPaused() {
        return this.paused;
    }
}

