/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.common.PodamByteValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;

public class ByteTypeManufacturerImpl
extends AbstractTypeManufacturer<Byte> {
    @Override
    public Byte getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, Map<String, Type> genericTypesArgumentsMap) {
        Byte retValue;
        PodamByteValue annotationStrategy = this.findElementOfType(attributeMetadata.getAttributeAnnotations(), PodamByteValue.class);
        if (null != annotationStrategy) {
            String numValueStr = annotationStrategy.numValue();
            if (StringUtils.isNotEmpty(numValueStr)) {
                try {
                    retValue = Byte.valueOf(numValueStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("The precise value: " + numValueStr + " cannot be converted to a byte type. An exception will be thrown.", nfe);
                }
            } else {
                byte maxValue;
                byte minValue = annotationStrategy.minValue();
                if (minValue > (maxValue = annotationStrategy.maxValue())) {
                    maxValue = minValue;
                }
                retValue = this.getByteInRange(minValue, maxValue, attributeMetadata);
            }
        } else {
            retValue = this.getByte(attributeMetadata);
        }
        return retValue;
    }

    public Byte getByte(AttributeMetadata attributeMetadata) {
        return (byte)this.getInteger(127);
    }

    public Byte getByteInRange(byte minValue, byte maxValue, AttributeMetadata attributeMetadata) {
        return (byte)PodamUtils.getIntegerInRange(minValue, maxValue);
    }
}

