/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nitrite;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.nitrite.NitriteEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.dizitart.no2.event.ChangeInfo;
import org.dizitart.no2.event.ChangeListener;
import org.dizitart.no2.event.ChangedItem;

public class NitriteConsumer
extends DefaultConsumer {
    private final NitriteEndpoint endpoint;
    private NitriteChangeListener changeListener;

    public NitriteConsumer(NitriteEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        this.changeListener = new NitriteChangeListener();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.endpoint.getNitriteCollection().register(this.changeListener);
    }

    @Override
    protected void doStop() throws Exception {
        if (this.changeListener != null) {
            this.endpoint.getNitriteCollection().deregister(this.changeListener);
        }
        super.doStop();
    }

    private class NitriteChangeListener
    implements ChangeListener {
        private NitriteChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(ChangeInfo changeInfo) {
            for (ChangedItem changedItem : changeInfo.getChangedItems()) {
                Exchange exchange = NitriteConsumer.this.createExchange(false);
                Message message = exchange.getMessage();
                message.setHeader("CamelNitriteChangeTimestamp", changedItem.getChangeTimestamp());
                message.setHeader("CamelNitriteChangeType", (Object)changedItem.getChangeType());
                message.setBody(changedItem.getDocument());
                try {
                    NitriteConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    exchange.setException(e);
                }
                finally {
                    if (exchange.getException() != null) {
                        NitriteConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
                    }
                    NitriteConsumer.this.releaseExchange(exchange, false);
                }
            }
        }
    }
}

