/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.common.PodamLongValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;

public class LongTypeManufacturerImpl
extends AbstractTypeManufacturer<Long> {
    @Override
    public Long getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, Map<String, Type> genericTypesArgumentsMap) {
        Long retValue;
        PodamLongValue annotationStrategy = this.findElementOfType(attributeMetadata.getAttributeAnnotations(), PodamLongValue.class);
        if (null != annotationStrategy) {
            String numValueStr = annotationStrategy.numValue();
            if (StringUtils.isNotEmpty(numValueStr)) {
                try {
                    retValue = Long.valueOf(numValueStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("The annotation value: " + numValueStr + " could not be converted to a Long. An exception will be thrown.", nfe);
                }
            } else {
                long maxValue;
                long minValue = annotationStrategy.minValue();
                if (minValue > (maxValue = annotationStrategy.maxValue())) {
                    maxValue = minValue;
                }
                retValue = this.getLongInRange(minValue, maxValue, attributeMetadata);
            }
        } else {
            retValue = this.getLong(attributeMetadata);
        }
        return retValue;
    }

    public Long getLong(AttributeMetadata attributeMetadata) {
        return System.nanoTime();
    }

    public Long getLongInRange(long minValue, long maxValue, AttributeMetadata attributeMetadata) {
        return PodamUtils.getLongInRange(minValue, maxValue);
    }
}

