/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nitrite;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.nitrite.NitriteComponent;
import org.apache.camel.component.nitrite.NitriteConstants;
import org.apache.camel.component.nitrite.NitriteConsumer;
import org.apache.camel.component.nitrite.NitriteProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.PersistentCollection;

@UriEndpoint(firstVersion="3.0.0", scheme="nitrite", title="Nitrite", syntax="nitrite:database", category={Category.DATABASE}, headersClass=NitriteConstants.class)
public class NitriteEndpoint
extends DefaultEndpoint {
    @UriPath(label="common", description="Path to database file. Will be created if not exists.")
    @Metadata(required=true)
    private String database;
    @UriParam(label="common", description="Name of Nitrite collection. Cannot be used in combination with repositoryClass option.")
    private String collection;
    @UriParam(label="common", description="Class of Nitrite ObjectRepository. Cannot be used in combination with collection option.")
    private Class<?> repositoryClass;
    @UriParam(label="common", description="Optional name of ObjectRepository. Can be only used in combination with repositoryClass, otherwise have no effect")
    private String repositoryName;
    @UriParam(label="security", description="Username for Nitrite database. Database is not secured if option not specified.")
    private String username;
    @UriParam(label="security", description="Password for Nitrite database. Required, if option username specified.")
    private String password;
    private Nitrite nitriteDatabase;
    private PersistentCollection nitriteCollection;

    public NitriteEndpoint() {
    }

    public NitriteEndpoint(String uri, NitriteComponent component) {
        super(uri, component);
    }

    public void setNitriteCollection(PersistentCollection collection) {
        this.nitriteCollection = collection;
    }

    public void setNitriteDatabase(Nitrite nitriteDatabase) {
        this.nitriteDatabase = nitriteDatabase;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new NitriteProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        return new NitriteConsumer(this, processor);
    }

    @Override
    public NitriteComponent getComponent() {
        return (NitriteComponent)super.getComponent();
    }

    public PersistentCollection getNitriteCollection() {
        return this.nitriteCollection;
    }

    public Nitrite getNitriteDatabase() {
        return this.nitriteDatabase;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Class<?> getRepositoryClass() {
        return this.repositoryClass;
    }

    public void setRepositoryClass(Class<?> repositoryClass) {
        this.repositoryClass = repositoryClass;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }
}

