/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultProducer
extends ServiceSupport
implements Producer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultProducer.class);
    private transient String producerToString;
    private final Endpoint endpoint;

    public DefaultProducer(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public String toString() {
        if (this.producerToString == null) {
            this.producerToString = "Producer[" + URISupport.sanitizeUri(this.endpoint.getEndpointUri()) + "]";
        }
        return this.producerToString;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Exchange createExchange() {
        return this.endpoint.createExchange();
    }

    @Override
    public boolean isSingleton() {
        return this.endpoint.isSingleton();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isSingleton()) {
            LOG.debug("Starting producer: {}", (Object)this);
        } else {
            LOG.trace("Starting producer: {}", (Object)this);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.isSingleton()) {
            LOG.debug("Stopping producer: {}", (Object)this);
        } else {
            LOG.trace("Stopping producer: {}", (Object)this);
        }
    }
}

