/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.objects.filters;

import java.util.Set;
import org.dizitart.no2.Document;
import org.dizitart.no2.Filter;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.filters.Filters;
import org.dizitart.no2.objects.filters.BaseObjectFilter;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.ValidationUtils;

class EqualsObjectFilter
extends BaseObjectFilter {
    private String field;
    private Object value;

    EqualsObjectFilter(String field, Object value) {
        this.field = field;
        this.value = value;
    }

    @Override
    public Set<NitriteId> apply(NitriteMap<NitriteId, Document> documentMap) {
        ValidationUtils.validateSearchTerm(this.nitriteMapper, this.field, this.value);
        Filter eqFilter = this.nitriteMapper.isValueType(this.value) ? Filters.eq(this.field, this.nitriteMapper.asValue(this.value)) : Filters.eq(this.field, this.value);
        eqFilter.setNitriteService(this.nitriteService);
        return eqFilter.apply(documentMap);
    }

    public String getField() {
        return this.field;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "EqualsObjectFilter(field=" + this.getField() + ", value=" + this.getValue() + ")";
    }
}

