/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.ognl;

import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.Predicate;
import org.apache.camel.language.ognl.CamelClassResolver;
import org.apache.camel.language.ognl.OgnlExpression;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.TypedLanguageSupport;

@Language(value="ognl")
public class OgnlLanguage
extends TypedLanguageSupport
implements ScriptingLanguage {
    @Override
    public Predicate createPredicate(String expression) {
        return this.createOgnlExpression(expression, Boolean.class);
    }

    @Override
    public Expression createExpression(String expression) {
        return this.createOgnlExpression(expression, Object.class);
    }

    private OgnlExpression createOgnlExpression(String expression, Class<?> type) {
        return new OgnlExpression(this.loadResource(expression), type);
    }

    @Override
    public <T> T evaluate(String script, Map<String, Object> bindings, Class<T> resultType) {
        script = this.loadResource(script);
        try {
            Object compiled = Ognl.parseExpression(script);
            CamelClassResolver cr = new CamelClassResolver(this.getCamelContext().getClassResolver());
            OgnlContext oglContext = Ognl.createDefaultContext(null, cr);
            Object value = Ognl.getValue(compiled, oglContext, bindings);
            return this.getCamelContext().getTypeConverter().convertTo(resultType, value);
        }
        catch (Exception e) {
            throw new ExpressionIllegalSyntaxException(script, e);
        }
    }
}

