/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.uri.expression.BinaryExpression;
import org.apache.olingo.odata2.api.uri.expression.BinaryOperator;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionVisitor;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.LiteralExpression;
import org.apache.olingo.odata2.api.uri.expression.MemberExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodOperator;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderExpression;
import org.apache.olingo.odata2.api.uri.expression.PropertyExpression;
import org.apache.olingo.odata2.api.uri.expression.SortOrder;
import org.apache.olingo.odata2.api.uri.expression.UnaryExpression;
import org.apache.olingo.odata2.api.uri.expression.UnaryOperator;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class JsonVisitor
implements ExpressionVisitor {
    @Override
    public Object visitFilterExpression(FilterExpression filterExpression, String expressionString, Object expression) {
        return expression;
    }

    @Override
    public Object visitBinary(BinaryExpression binaryExpression, BinaryOperator operator, Object leftSide, Object rightSide) {
        try {
            StringWriter writer = new StringWriter();
            JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
            jsonStreamWriter.beginObject().namedStringValueRaw("nodeType", binaryExpression.getKind().toString()).separator().namedStringValue("operator", operator.toUriLiteral()).separator().namedStringValueRaw("type", JsonVisitor.getType(binaryExpression)).separator().name("left").unquotedValue(leftSide.toString()).separator().name("right").unquotedValue(rightSide.toString()).endObject();
            writer.flush();
            return writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Object visitOrderByExpression(OrderByExpression orderByExpression, String expressionString, List<Object> orders) {
        try {
            StringWriter writer = new StringWriter();
            JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
            jsonStreamWriter.beginObject().namedStringValueRaw("nodeType", "order collection").separator().name("orders").beginArray();
            boolean first = true;
            for (Object order : orders) {
                if (first) {
                    first = false;
                } else {
                    jsonStreamWriter.separator();
                }
                jsonStreamWriter.unquotedValue(order.toString());
            }
            jsonStreamWriter.endArray().endObject();
            writer.flush();
            return writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Object visitOrder(OrderExpression orderExpression, Object filterResult, SortOrder sortOrder) {
        try {
            StringWriter writer = new StringWriter();
            JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
            jsonStreamWriter.beginObject().namedStringValueRaw("nodeType", orderExpression.getKind().toString()).separator().namedStringValueRaw("sortorder", sortOrder.toString()).separator().name("expression").unquotedValue(filterResult.toString()).endObject();
            writer.flush();
            return writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Object visitLiteral(LiteralExpression literal, EdmLiteral edmLiteral) {
        try {
            StringWriter writer = new StringWriter();
            JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
            jsonStreamWriter.beginObject().namedStringValueRaw("nodeType", literal.getKind().toString()).separator().namedStringValueRaw("type", JsonVisitor.getType(literal)).separator().namedStringValue("value", edmLiteral.getLiteral()).endObject();
            writer.flush();
            return writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Object visitMethod(MethodExpression methodExpression, MethodOperator method, List<Object> parameters) {
        try {
            StringWriter writer = new StringWriter();
            JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
            jsonStreamWriter.beginObject().namedStringValueRaw("nodeType", methodExpression.getKind().toString()).separator().namedStringValueRaw("operator", method.toUriLiteral()).separator().namedStringValueRaw("type", JsonVisitor.getType(methodExpression)).separator().name("parameters").beginArray();
            boolean first = true;
            for (Object parameter : parameters) {
                if (first) {
                    first = false;
                } else {
                    jsonStreamWriter.separator();
                }
                jsonStreamWriter.unquotedValue(parameter.toString());
            }
            jsonStreamWriter.endArray().endObject();
            writer.flush();
            return writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Object visitMember(MemberExpression memberExpression, Object path, Object property) {
        try {
            StringWriter writer = new StringWriter();
            JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
            jsonStreamWriter.beginObject().namedStringValueRaw("nodeType", memberExpression.getKind().toString()).separator().namedStringValueRaw("type", JsonVisitor.getType(memberExpression)).separator().name("source").unquotedValue(path.toString()).separator().name("path").unquotedValue(property.toString()).endObject();
            writer.flush();
            return writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Object visitProperty(PropertyExpression propertyExpression, String uriLiteral, EdmTyped edmProperty) {
        try {
            StringWriter writer = new StringWriter();
            JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
            jsonStreamWriter.beginObject().namedStringValueRaw("nodeType", propertyExpression.getKind().toString()).separator().namedStringValue("name", uriLiteral).separator().namedStringValueRaw("type", JsonVisitor.getType(propertyExpression)).endObject();
            writer.flush();
            return writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public Object visitUnary(UnaryExpression unaryExpression, UnaryOperator operator, Object operand) {
        try {
            StringWriter writer = new StringWriter();
            JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
            jsonStreamWriter.beginObject().namedStringValueRaw("nodeType", unaryExpression.getKind().toString()).separator().namedStringValueRaw("operator", operator.toUriLiteral()).separator().namedStringValueRaw("type", JsonVisitor.getType(unaryExpression)).separator().name("operand").unquotedValue(operand.toString()).endObject();
            writer.flush();
            return writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String getType(CommonExpression expression) {
        try {
            EdmType type = expression.getEdmType();
            return type == null ? null : type.getNamespace() + "." + type.getName();
        }
        catch (EdmException e) {
            return "EdmException occurred: " + e.getMessage();
        }
    }
}

