/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo2;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.olingo2.Olingo2Component;
import org.apache.camel.component.olingo2.Olingo2Configuration;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;

public class Olingo2ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private Olingo2Configuration getOrCreateConfiguration(Olingo2Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new Olingo2Configuration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        Olingo2Component target = (Olingo2Component)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(Olingo2ComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(Olingo2ComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(Olingo2ComponentConfigurer.property(camelContext, Olingo2Configuration.class, value));
                return true;
            }
            case "connecttimeout": 
            case "connectTimeout": {
                this.getOrCreateConfiguration(target).setConnectTimeout(Olingo2ComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "contenttype": 
            case "contentType": {
                this.getOrCreateConfiguration(target).setContentType(Olingo2ComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "entityproviderreadproperties": 
            case "entityProviderReadProperties": {
                this.getOrCreateConfiguration(target).setEntityProviderReadProperties(Olingo2ComponentConfigurer.property(camelContext, EntityProviderReadProperties.class, value));
                return true;
            }
            case "entityproviderwriteproperties": 
            case "entityProviderWriteProperties": {
                this.getOrCreateConfiguration(target).setEntityProviderWriteProperties(Olingo2ComponentConfigurer.property(camelContext, EntityProviderWriteProperties.class, value));
                return true;
            }
            case "filteralreadyseen": 
            case "filterAlreadySeen": {
                this.getOrCreateConfiguration(target).setFilterAlreadySeen(Olingo2ComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "httpasyncclientbuilder": 
            case "httpAsyncClientBuilder": {
                this.getOrCreateConfiguration(target).setHttpAsyncClientBuilder(Olingo2ComponentConfigurer.property(camelContext, HttpAsyncClientBuilder.class, value));
                return true;
            }
            case "httpclientbuilder": 
            case "httpClientBuilder": {
                this.getOrCreateConfiguration(target).setHttpClientBuilder(Olingo2ComponentConfigurer.property(camelContext, HttpClientBuilder.class, value));
                return true;
            }
            case "httpheaders": 
            case "httpHeaders": {
                this.getOrCreateConfiguration(target).setHttpHeaders(Olingo2ComponentConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(Olingo2ComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "proxy": {
                this.getOrCreateConfiguration(target).setProxy(Olingo2ComponentConfigurer.property(camelContext, HttpHost.class, value));
                return true;
            }
            case "serviceuri": 
            case "serviceUri": {
                this.getOrCreateConfiguration(target).setServiceUri(Olingo2ComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "sockettimeout": 
            case "socketTimeout": {
                this.getOrCreateConfiguration(target).setSocketTimeout(Olingo2ComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "splitresult": 
            case "splitResult": {
                this.getOrCreateConfiguration(target).setSplitResult(Olingo2ComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                this.getOrCreateConfiguration(target).setSslContextParameters(Olingo2ComponentConfigurer.property(camelContext, SSLContextParameters.class, value));
                return true;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                target.setUseGlobalSslContextParameters(Olingo2ComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return Olingo2Configuration.class;
            }
            case "connecttimeout": 
            case "connectTimeout": {
                return Integer.TYPE;
            }
            case "contenttype": 
            case "contentType": {
                return String.class;
            }
            case "entityproviderreadproperties": 
            case "entityProviderReadProperties": {
                return EntityProviderReadProperties.class;
            }
            case "entityproviderwriteproperties": 
            case "entityProviderWriteProperties": {
                return EntityProviderWriteProperties.class;
            }
            case "filteralreadyseen": 
            case "filterAlreadySeen": {
                return Boolean.TYPE;
            }
            case "httpasyncclientbuilder": 
            case "httpAsyncClientBuilder": {
                return HttpAsyncClientBuilder.class;
            }
            case "httpclientbuilder": 
            case "httpClientBuilder": {
                return HttpClientBuilder.class;
            }
            case "httpheaders": 
            case "httpHeaders": {
                return Map.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "proxy": {
                return HttpHost.class;
            }
            case "serviceuri": 
            case "serviceUri": {
                return String.class;
            }
            case "sockettimeout": 
            case "socketTimeout": {
                return Integer.TYPE;
            }
            case "splitresult": 
            case "splitResult": {
                return Boolean.TYPE;
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return SSLContextParameters.class;
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        Olingo2Component target = (Olingo2Component)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "connecttimeout": 
            case "connectTimeout": {
                return this.getOrCreateConfiguration(target).getConnectTimeout();
            }
            case "contenttype": 
            case "contentType": {
                return this.getOrCreateConfiguration(target).getContentType();
            }
            case "entityproviderreadproperties": 
            case "entityProviderReadProperties": {
                return this.getOrCreateConfiguration(target).getEntityProviderReadProperties();
            }
            case "entityproviderwriteproperties": 
            case "entityProviderWriteProperties": {
                return this.getOrCreateConfiguration(target).getEntityProviderWriteProperties();
            }
            case "filteralreadyseen": 
            case "filterAlreadySeen": {
                return this.getOrCreateConfiguration(target).isFilterAlreadySeen();
            }
            case "httpasyncclientbuilder": 
            case "httpAsyncClientBuilder": {
                return this.getOrCreateConfiguration(target).getHttpAsyncClientBuilder();
            }
            case "httpclientbuilder": 
            case "httpClientBuilder": {
                return this.getOrCreateConfiguration(target).getHttpClientBuilder();
            }
            case "httpheaders": 
            case "httpHeaders": {
                return this.getOrCreateConfiguration(target).getHttpHeaders();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "proxy": {
                return this.getOrCreateConfiguration(target).getProxy();
            }
            case "serviceuri": 
            case "serviceUri": {
                return this.getOrCreateConfiguration(target).getServiceUri();
            }
            case "sockettimeout": 
            case "socketTimeout": {
                return this.getOrCreateConfiguration(target).getSocketTimeout();
            }
            case "splitresult": 
            case "splitResult": {
                return this.getOrCreateConfiguration(target).isSplitResult();
            }
            case "sslcontextparameters": 
            case "sslContextParameters": {
                return this.getOrCreateConfiguration(target).getSslContextParameters();
            }
            case "useglobalsslcontextparameters": 
            case "useGlobalSslContextParameters": {
                return target.isUseGlobalSslContextParameters();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "httpheaders": 
            case "httpHeaders": {
                return String.class;
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Configuration", Olingo2Configuration.class);
        map.put("ConnectTimeout", Integer.TYPE);
        map.put("ContentType", String.class);
        map.put("EntityProviderReadProperties", EntityProviderReadProperties.class);
        map.put("EntityProviderWriteProperties", EntityProviderWriteProperties.class);
        map.put("FilterAlreadySeen", Boolean.TYPE);
        map.put("HttpHeaders", Map.class);
        map.put("Proxy", HttpHost.class);
        map.put("ServiceUri", String.class);
        map.put("SocketTimeout", Integer.TYPE);
        map.put("BridgeErrorHandler", Boolean.TYPE);
        map.put("SplitResult", Boolean.TYPE);
        map.put("LazyStartProducer", Boolean.TYPE);
        map.put("AutowiredEnabled", Boolean.TYPE);
        map.put("HttpAsyncClientBuilder", HttpAsyncClientBuilder.class);
        map.put("HttpClientBuilder", HttpClientBuilder.class);
        map.put("SslContextParameters", SSLContextParameters.class);
        map.put("UseGlobalSslContextParameters", Boolean.TYPE);
        ALL_OPTIONS = map;
    }
}

