/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.processor.ODataResponse;

public class ODataResponseImpl
extends ODataResponse {
    private HttpStatusCodes status;
    private Object entity;
    private HashMap<String, String> headers;

    @Override
    public HttpStatusCodes getStatus() {
        return this.status;
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public void close() throws IOException {
        if (this.entity != null && this.entity instanceof Closeable) {
            Closeable closeableEntity = (Closeable)this.entity;
            closeableEntity.close();
        }
    }

    @Override
    public String getHeader(String name) {
        return this.headers.get(name);
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @Override
    public String getIdLiteral() {
        return this.headers.get("Location");
    }

    @Override
    public String getETag() {
        return this.headers.get("ETag");
    }

    @Override
    public String getContentHeader() {
        return this.headers.get("Content-Type");
    }

    @Override
    public boolean containsHeader(String header) {
        boolean contains = false;
        for (String containedHeader : this.headers.keySet()) {
            if (!containedHeader.equalsIgnoreCase(header)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public class ODataResponseBuilderImpl
    extends ODataResponse.ODataResponseBuilder {
        private HttpStatusCodes status;
        private Object entity;
        private HashMap<String, String> headers = new HashMap();

        @Override
        public ODataResponse build() {
            ODataResponseImpl.this.status = this.status;
            ODataResponseImpl.this.entity = this.entity;
            ODataResponseImpl.this.headers = this.headers;
            return ODataResponseImpl.this;
        }

        @Override
        public ODataResponse.ODataResponseBuilder status(HttpStatusCodes status) {
            this.status = status;
            return this;
        }

        @Override
        public ODataResponse.ODataResponseBuilder entity(Object entity) {
            this.entity = entity;
            return this;
        }

        @Override
        public ODataResponse.ODataResponseBuilder header(String name, String value) {
            if (value == null) {
                this.headers.remove(name);
            } else {
                this.headers.put(name, value);
            }
            return this;
        }

        @Override
        public ODataResponse.ODataResponseBuilder idLiteral(String idLiteral) {
            return this.header("Location", idLiteral);
        }

        @Override
        public ODataResponse.ODataResponseBuilder eTag(String eTag) {
            return this.header("ETag", eTag);
        }

        @Override
        public ODataResponse.ODataResponseBuilder contentHeader(String value) {
            return this.header("Content-Type", value);
        }

        @Override
        protected ODataResponse.ODataResponseBuilder fromResponse(ODataResponse response) {
            this.status = response.getStatus();
            this.entity = response.getEntity();
            this.headers = new HashMap();
            for (String key : response.getHeaderNames()) {
                this.headers.put(key, response.getHeader(key));
            }
            return this;
        }
    }
}

