/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.batch;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.olingo.odata2.api.client.batch.BatchChangeSetPart;
import org.apache.olingo.odata2.core.batch.BatchHelper;

public class BatchChangeSetPartImpl
extends BatchChangeSetPart {
    private String method;
    private Map<String, String> headers = new HashMap<String, String>();
    private Object body;
    private String uri;
    private String cntId;
    private static final String CHANGE_METHODS = "(PUT|POST|DELETE|MERGE|PATCH)";

    @Override
    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public String getBody() {
        return this.body.toString();
    }

    @Override
    public byte[] getBodyAsBytes() {
        if (this.body == null) {
            return new byte[0];
        }
        Charset charset = this.getCharset();
        if (this.body instanceof byte[]) {
            return (byte[])this.body;
        }
        return this.body.toString().getBytes(charset);
    }

    private Charset getCharset() {
        return BatchHelper.extractCharset(this.headers);
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public String getContentId() {
        return this.cntId;
    }

    public class BatchChangeSetRequestBuilderImpl
    extends BatchChangeSetPart.BatchChangeSetPartBuilder {
        private String method;
        private Map<String, String> headers = new HashMap<String, String>();
        private Object body;
        private String uri;
        private String contentId;

        @Override
        public BatchChangeSetPart build() {
            if (this.method == null || this.uri == null) {
                throw new IllegalArgumentException();
            }
            BatchChangeSetPartImpl.this.method = this.method;
            BatchChangeSetPartImpl.this.headers = this.headers;
            BatchChangeSetPartImpl.this.body = this.body;
            BatchChangeSetPartImpl.this.uri = this.uri;
            BatchChangeSetPartImpl.this.cntId = this.contentId;
            return BatchChangeSetPartImpl.this;
        }

        @Override
        public BatchChangeSetPart.BatchChangeSetPartBuilder headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        @Override
        public BatchChangeSetPart.BatchChangeSetPartBuilder body(String body) {
            this.body = body;
            return this;
        }

        @Override
        public BatchChangeSetPart.BatchChangeSetPartBuilder body(byte[] body) {
            this.body = body;
            return this;
        }

        @Override
        public BatchChangeSetPart.BatchChangeSetPartBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        @Override
        public BatchChangeSetPart.BatchChangeSetPartBuilder method(String method) {
            if (method == null || !method.matches(BatchChangeSetPartImpl.CHANGE_METHODS)) {
                throw new IllegalArgumentException();
            }
            this.method = method;
            return this;
        }

        @Override
        public BatchChangeSetPart.BatchChangeSetPartBuilder contentId(String contentId) {
            this.contentId = contentId;
            return this;
        }
    }
}

