/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.consumer;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.olingo.odata2.api.edm.EdmEntitySetInfo;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.provider.EntityContainerInfo;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.core.commons.Decoder;
import org.apache.olingo.odata2.core.edm.provider.EdmEntitySetInfoImplProv;
import org.apache.olingo.odata2.core.servicedocument.ServiceDocumentImpl;

public class JsonServiceDocumentConsumer {
    private static final String DEFAULT_CHARSET = "UTF-8";
    List<EdmEntitySetInfo> entitySets = new ArrayList<EdmEntitySetInfo>();
    private String currentHandledObjectName;

    public ServiceDocumentImpl parseJson(InputStream in) throws EntityProviderException {
        return this.readServiceDocument(this.createJsonReader(in));
    }

    private ServiceDocumentImpl readServiceDocument(JsonReader reader) throws EntityProviderException {
        try {
            reader.beginObject();
            this.currentHandledObjectName = reader.nextName();
            if ("d".equals(this.currentHandledObjectName)) {
                reader.beginObject();
                this.readContent(reader);
                reader.endObject();
            }
            reader.endObject();
            reader.peek();
            reader.close();
        }
        catch (IOException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
        catch (EdmException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
        return new ServiceDocumentImpl().setEntitySetsInfo(this.entitySets);
    }

    private void readContent(JsonReader reader) throws IOException, EdmException, EntityProviderException {
        this.currentHandledObjectName = reader.nextName();
        if ("EntitySets".equals(this.currentHandledObjectName)) {
            reader.beginArray();
            this.readEntitySets(reader);
            reader.endArray();
        }
    }

    private void readEntitySets(JsonReader reader) throws IOException, EntityProviderException, EdmException {
        while (reader.hasNext()) {
            EdmEntitySetInfoImplProv entitySetInfo;
            EntityContainerInfo container;
            EntitySet entitySet;
            this.currentHandledObjectName = reader.nextString();
            if (this.currentHandledObjectName == null) continue;
            String[] names = this.currentHandledObjectName.split("\\.(?=[^.]+$)");
            if (names.length == 1) {
                entitySet = new EntitySet().setName(Decoder.decode(names[0]));
                container = new EntityContainerInfo().setDefaultEntityContainer(true);
                entitySetInfo = new EdmEntitySetInfoImplProv(entitySet, container);
                this.entitySets.add(entitySetInfo);
                continue;
            }
            entitySet = new EntitySet().setName(Decoder.decode(names[1]));
            container = new EntityContainerInfo().setName(Decoder.decode(names[0])).setDefaultEntityContainer(false);
            entitySetInfo = new EdmEntitySetInfoImplProv(entitySet, container);
            this.entitySets.add(entitySetInfo);
        }
    }

    private JsonReader createJsonReader(InputStream in) throws EntityProviderException {
        InputStreamReader isReader;
        if (in == null) {
            throw new EntityProviderException(EntityProviderException.INVALID_STATE.addContent("Got not supported NULL object as content to de-serialize."));
        }
        try {
            isReader = new InputStreamReader(in, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
        return new JsonReader(isReader);
    }
}

