/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.servlet;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.batch.BatchException;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataHttpException;
import org.apache.olingo.odata2.api.exception.ODataMessageException;
import org.apache.olingo.odata2.api.processor.ODataErrorCallback;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.ep.EntityProviderProducerException;
import org.apache.olingo.odata2.core.ep.ProviderFacadeImpl;
import org.apache.olingo.odata2.core.exception.MessageService;
import org.apache.olingo.odata2.core.servlet.RestUtil;

public class ODataExceptionWrapper {
    private static final String DOLLAR_FORMAT = "$format";
    private static final String DOLLAR_FORMAT_JSON = "json";
    private static final Locale DEFAULT_RESPONSE_LOCALE = Locale.ENGLISH;
    private final ODataErrorContext errorContext = new ODataErrorContext();
    private final String contentType;
    private final Locale messageLocale;
    private final Map<String, List<String>> httpRequestHeaders;
    private final ODataErrorCallback callback;
    private URI requestUri;

    public ODataExceptionWrapper(HttpServletRequest req, ODataServiceFactory serviceFactory) {
        Map<String, String> queryParameters;
        try {
            this.requestUri = new URI(req.getRequestURI());
        }
        catch (URISyntaxException e) {
            this.requestUri = null;
        }
        this.httpRequestHeaders = RestUtil.extractHeaders(req);
        try {
            queryParameters = RestUtil.extractQueryParameters(req.getQueryString());
        }
        catch (Exception e) {
            queryParameters = new HashMap<String, String>();
        }
        List<Locale> acceptableLanguages = RestUtil.extractAcceptableLanguage(req.getHeader("Accept-Language"));
        List<String> acceptHeaders = RestUtil.extractAcceptHeaders(req.getHeader("Accept"));
        this.contentType = this.getContentType(queryParameters, acceptHeaders).toContentTypeString();
        this.messageLocale = MessageService.getSupportedLocale(this.getLanguages(acceptableLanguages), DEFAULT_RESPONSE_LOCALE);
        this.callback = serviceFactory.getCallback(ODataErrorCallback.class);
    }

    public ODataResponse wrapInExceptionResponse(Exception exception) {
        try {
            Exception toHandleException = this.extractException(exception);
            this.fillErrorContext(toHandleException);
            if (toHandleException instanceof ODataApplicationException) {
                this.enhanceContextWithApplicationException((ODataApplicationException)toHandleException);
            } else if (toHandleException instanceof ODataMessageException) {
                this.enhanceContextWithMessageException((ODataMessageException)toHandleException);
            }
            ODataResponse oDataResponse = this.callback != null ? this.handleErrorCallback(this.callback) : EntityProvider.writeErrorDocument(this.errorContext);
            if (!oDataResponse.containsHeader("Content-Type")) {
                oDataResponse = ODataResponse.fromResponse(oDataResponse).contentHeader(this.contentType).build();
            }
            return oDataResponse;
        }
        catch (Exception e) {
            ODataResponse response = ODataResponse.entity("Exception during error handling occured!").contentHeader(ContentType.TEXT_PLAIN.toContentTypeString()).status(HttpStatusCodes.INTERNAL_SERVER_ERROR).build();
            return response;
        }
    }

    private ODataResponse handleErrorCallback(ODataErrorCallback callback) throws EntityProviderException {
        ODataResponse oDataResponse;
        try {
            oDataResponse = callback.handleError(this.errorContext);
        }
        catch (ODataApplicationException e) {
            this.fillErrorContext(e);
            this.enhanceContextWithApplicationException(e);
            oDataResponse = new ProviderFacadeImpl().writeErrorDocument(this.errorContext);
        }
        return oDataResponse;
    }

    private Exception extractException(Exception exception) {
        if (exception instanceof ODataException) {
            ODataException odataException = (ODataException)exception;
            if (odataException.isCausedByApplicationException()) {
                return odataException.getApplicationExceptionCause();
            }
            if (odataException.isCausedByHttpException()) {
                return odataException.getHttpExceptionCause();
            }
            if (odataException.isCausedByMessageException()) {
                return odataException.getMessageExceptionCause();
            }
        }
        return exception;
    }

    private void enhanceContextWithApplicationException(ODataApplicationException toHandleException) {
        this.errorContext.setHttpStatus(toHandleException.getHttpStatus());
        this.errorContext.setErrorCode(toHandleException.getCode());
    }

    private void enhanceContextWithMessageException(ODataMessageException toHandleException) {
        MessageService.Message localizedMessage;
        this.errorContext.setErrorCode(toHandleException.getErrorCode());
        MessageReference messageReference = toHandleException.getMessageReference();
        MessageService.Message message = localizedMessage = messageReference == null ? null : this.extractEntity(messageReference);
        if (localizedMessage != null) {
            this.errorContext.setMessage(localizedMessage.getText());
            this.errorContext.setLocale(localizedMessage.getLocale());
        }
        if (toHandleException instanceof ODataHttpException) {
            this.errorContext.setHttpStatus(((ODataHttpException)toHandleException).getHttpStatus());
        } else if (toHandleException instanceof EntityProviderException) {
            if (toHandleException instanceof EntityProviderProducerException) {
                this.errorContext.setHttpStatus(HttpStatusCodes.INTERNAL_SERVER_ERROR);
            } else {
                this.errorContext.setHttpStatus(HttpStatusCodes.BAD_REQUEST);
            }
        } else if (toHandleException instanceof BatchException) {
            this.errorContext.setHttpStatus(HttpStatusCodes.BAD_REQUEST);
        }
    }

    private MessageService.Message extractEntity(MessageReference context) {
        return MessageService.getMessage(this.messageLocale, context);
    }

    private List<Locale> getLanguages(List<Locale> acceptableLanguages) {
        if (acceptableLanguages.isEmpty()) {
            return Arrays.asList(DEFAULT_RESPONSE_LOCALE);
        }
        return acceptableLanguages;
    }

    private ContentType getContentType(Map<String, String> queryParameters, List<String> acceptHeaders) {
        ContentType cntType = this.getContentTypeByUriInfo(queryParameters);
        if (cntType == null) {
            cntType = this.getContentTypeByAcceptHeader(acceptHeaders);
        }
        return cntType;
    }

    private ContentType getContentTypeByUriInfo(Map<String, String> queryParameters) {
        ContentType cntType = null;
        if (queryParameters != null && queryParameters.containsKey(DOLLAR_FORMAT)) {
            String contentTypeString = queryParameters.get(DOLLAR_FORMAT);
            cntType = DOLLAR_FORMAT_JSON.equals(contentTypeString) ? ContentType.APPLICATION_JSON : ContentType.APPLICATION_XML;
        }
        return cntType;
    }

    private ContentType getContentTypeByAcceptHeader(List<String> acceptHeaders) {
        for (String type : acceptHeaders) {
            if (!ContentType.isParseable(type)) continue;
            ContentType convertedContentType = ContentType.create(type);
            if (convertedContentType.isWildcard() || ContentType.APPLICATION_XML.equals(convertedContentType) || ContentType.APPLICATION_XML_CS_UTF_8.equals(convertedContentType) || ContentType.APPLICATION_ATOM_XML.equals(convertedContentType) || ContentType.APPLICATION_ATOM_XML_CS_UTF_8.equals(convertedContentType)) {
                return ContentType.APPLICATION_XML;
            }
            if (!ContentType.APPLICATION_JSON.equals(convertedContentType) && !ContentType.APPLICATION_JSON_CS_UTF_8.equals(convertedContentType)) continue;
            return ContentType.APPLICATION_JSON;
        }
        return ContentType.APPLICATION_XML;
    }

    private void fillErrorContext(Exception exception) {
        this.errorContext.setContentType(this.contentType);
        this.errorContext.setException(exception);
        this.errorContext.setHttpStatus(HttpStatusCodes.INTERNAL_SERVER_ERROR);
        this.errorContext.setErrorCode(null);
        this.errorContext.setMessage(exception.getMessage());
        this.errorContext.setLocale(DEFAULT_RESPONSE_LOCALE);
        this.errorContext.setRequestUri(this.requestUri);
        if (this.httpRequestHeaders != null) {
            for (Map.Entry<String, List<String>> entry : this.httpRequestHeaders.entrySet()) {
                this.errorContext.putRequestHeader(entry.getKey(), entry.getValue());
            }
        }
    }
}

