/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri.expression;

import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.uri.expression.CommonExpression;
import org.apache.olingo.odata2.api.uri.expression.ExceptionVisitExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionKind;
import org.apache.olingo.odata2.api.uri.expression.ExpressionVisitor;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;

public class FilterExpressionImpl
implements FilterExpression {
    private final String filterString;
    private EdmType edmType;
    private CommonExpression commonExpression;

    public FilterExpressionImpl(String filterExpression) {
        this.filterString = filterExpression;
    }

    public FilterExpressionImpl(String filterExpression, CommonExpression childExpression) {
        this.filterString = filterExpression;
        this.commonExpression = childExpression;
    }

    @Override
    public String getExpressionString() {
        return this.filterString;
    }

    @Override
    public CommonExpression getExpression() {
        return this.commonExpression;
    }

    @Override
    public Object accept(ExpressionVisitor visitor) throws ExceptionVisitExpression, ODataApplicationException {
        Object retCommonExpression = this.commonExpression.accept(visitor);
        return visitor.visitFilterExpression(this, this.filterString, retCommonExpression);
    }

    @Override
    public CommonExpression setEdmType(EdmType edmType) {
        this.edmType = edmType;
        return this;
    }

    @Override
    public EdmType getEdmType() {
        return this.edmType;
    }

    @Override
    public ExpressionKind getKind() {
        return ExpressionKind.FILTER;
    }

    @Override
    public String getUriLiteral() {
        return this.getExpressionString();
    }
}

