/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo4.api.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.camel.component.olingo4.api.Olingo4App;
import org.apache.camel.component.olingo4.api.Olingo4ResponseHandler;
import org.apache.camel.component.olingo4.api.batch.Olingo4BatchChangeRequest;
import org.apache.camel.component.olingo4.api.batch.Olingo4BatchQueryRequest;
import org.apache.camel.component.olingo4.api.batch.Olingo4BatchRequest;
import org.apache.camel.component.olingo4.api.batch.Olingo4BatchResponse;
import org.apache.camel.component.olingo4.api.batch.Operation;
import org.apache.camel.component.olingo4.api.impl.AbstractFutureCallback;
import org.apache.camel.component.olingo4.api.impl.Olingo4Helper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.DecompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultHttpResponseParser;
import org.apache.http.impl.io.HttpTransportMetricsImpl;
import org.apache.http.impl.io.SessionInputBufferImpl;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.BasicLineParser;
import org.apache.http.message.LineParser;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.ODataStreamer;
import org.apache.olingo.client.api.domain.ClientCollectionValue;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientPrimitiveValue;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.client.api.serialization.ODataReader;
import org.apache.olingo.client.api.serialization.ODataWriter;
import org.apache.olingo.client.api.uri.SegmentType;
import org.apache.olingo.client.core.ODataClientFactory;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchController;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchLineIteratorImpl;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchUtilities;
import org.apache.olingo.client.core.http.HttpMerge;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.constants.ODataServiceVersion;
import org.apache.olingo.commons.api.ex.ODataError;
import org.apache.olingo.commons.api.ex.ODataException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoKind;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceKind;
import org.apache.olingo.server.core.uri.parser.Parser;

public final class Olingo4AppImpl
implements Olingo4App {
    private static final String SEPARATOR = "/";
    private static final String BOUNDARY_PREFIX = "batch_";
    private static final String BOUNDARY_PARAMETER = "; boundary=";
    private static final String BOUNDARY_DOUBLE_DASH = "--";
    private static final String MULTIPART_MIME_TYPE = "multipart/";
    private static final String CONTENT_ID_HEADER = "Content-ID";
    private static final String CLIENT_ENTITY_FAKE_MARKER = "('X')";
    private static final ContentType DEFAULT_CONTENT_TYPE = ContentType.create(ContentType.APPLICATION_JSON, "charset", "UTF-8");
    private static final ContentType METADATA_CONTENT_TYPE = ContentType.create(ContentType.APPLICATION_XML, "charset", "UTF-8");
    private static final ContentType TEXT_PLAIN_WITH_CS_UTF_8 = ContentType.create(ContentType.TEXT_PLAIN, "charset", "UTF-8");
    private static final ContentType SERVICE_DOCUMENT_CONTENT_TYPE = ContentType.APPLICATION_JSON;
    private static final ContentType BATCH_CONTENT_TYPE = ContentType.MULTIPART_MIXED;
    private final Closeable client;
    private final ODataClient odataClient = ODataClientFactory.getClient();
    private final ODataReader odataReader = this.odataClient.getReader();
    private final ODataWriter odataWriter = this.odataClient.getWriter();
    private String serviceUri;
    private ContentType contentType;
    private Map<String, String> httpHeaders;

    public Olingo4AppImpl(String serviceUri) {
        this(serviceUri, (HttpClientBuilder)null);
    }

    public Olingo4AppImpl(String serviceUri, HttpAsyncClientBuilder builder) {
        this.setServiceUri(serviceUri);
        CloseableHttpAsyncClient asyncClient = builder == null ? HttpAsyncClients.createDefault() : builder.build();
        asyncClient.start();
        this.client = asyncClient;
        this.contentType = DEFAULT_CONTENT_TYPE;
    }

    public Olingo4AppImpl(String serviceUri, HttpClientBuilder builder) {
        this.setServiceUri(serviceUri);
        this.client = builder == null ? HttpClients.createDefault() : builder.build();
        this.contentType = DEFAULT_CONTENT_TYPE;
    }

    @Override
    public void setServiceUri(String serviceUri) {
        if (serviceUri == null || serviceUri.isEmpty()) {
            throw new IllegalArgumentException("serviceUri is not set");
        }
        this.serviceUri = serviceUri.endsWith(SEPARATOR) ? serviceUri.substring(0, serviceUri.length() - 1) : serviceUri;
    }

    @Override
    public String getServiceUri() {
        return this.serviceUri;
    }

    @Override
    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    @Override
    public String getContentType() {
        return this.contentType.toContentTypeString();
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = ContentType.parse(contentType);
    }

    @Override
    public void close() {
        IOHelper.close(this.client);
    }

    @Override
    public <T> void read(Edm edm, String resourcePath, Map<String, String> queryParams, Map<String, String> endpointHttpHeaders, final Olingo4ResponseHandler<T> responseHandler) {
        String queryOptions = this.concatQueryParams(queryParams);
        final UriInfo uriInfo = Olingo4AppImpl.parseUri(edm, resourcePath, queryOptions, this.serviceUri);
        this.execute(new HttpGet(this.createUri(resourcePath, queryOptions)), this.getResourceContentType(uriInfo), endpointHttpHeaders, new AbstractFutureCallback<T>(responseHandler){

            @Override
            public void onCompleted(HttpResponse result) throws IOException {
                Olingo4AppImpl.this.readContent(uriInfo, result.getEntity() != null ? result.getEntity().getContent() : null, Olingo4AppImpl.headersToMap(result.getAllHeaders()), responseHandler);
            }
        });
    }

    @Override
    public void uread(Edm edm, String resourcePath, Map<String, String> queryParams, Map<String, String> endpointHttpHeaders, final Olingo4ResponseHandler<InputStream> responseHandler) {
        String queryOptions = this.concatQueryParams(queryParams);
        UriInfo uriInfo = Olingo4AppImpl.parseUri(edm, resourcePath, queryOptions, this.serviceUri);
        this.execute(new HttpGet(this.createUri(resourcePath, queryOptions)), this.getResourceContentType(uriInfo), endpointHttpHeaders, new AbstractFutureCallback<InputStream>(responseHandler){

            @Override
            public void onCompleted(HttpResponse result) throws IOException {
                InputStream responseStream;
                InputStream inputStream = responseStream = result.getEntity() != null ? result.getEntity().getContent() : null;
                if (responseStream != null && result.getEntity() instanceof DecompressingEntity) {
                    responseHandler.onResponse(new ByteArrayInputStream(IOUtils.toByteArray((InputStream)responseStream)), Olingo4AppImpl.headersToMap(result.getAllHeaders()));
                } else {
                    responseHandler.onResponse(responseStream, Olingo4AppImpl.headersToMap(result.getAllHeaders()));
                }
            }
        });
    }

    @Override
    public <T> void create(Edm edm, String resourcePath, Map<String, String> endpointHttpHeaders, Object data, Olingo4ResponseHandler<T> responseHandler) {
        UriInfo uriInfo = Olingo4AppImpl.parseUri(edm, resourcePath, null, this.serviceUri);
        this.writeContent(edm, new HttpPost(this.createUri(resourcePath, null)), uriInfo, data, endpointHttpHeaders, responseHandler);
    }

    @Override
    public <T> void update(Edm edm, String resourcePath, Map<String, String> endpointHttpHeaders, Object data, Olingo4ResponseHandler<T> responseHandler) {
        UriInfo uriInfo = Olingo4AppImpl.parseUri(edm, resourcePath, null, this.serviceUri);
        this.augmentWithETag(edm, resourcePath, endpointHttpHeaders, new HttpPut(this.createUri(resourcePath, null)), request -> this.writeContent(edm, (HttpPut)request, uriInfo, data, endpointHttpHeaders, responseHandler), responseHandler);
    }

    @Override
    public void delete(String resourcePath, Map<String, String> endpointHttpHeaders, final Olingo4ResponseHandler<HttpStatusCode> responseHandler) {
        HttpDelete deleteRequest = new HttpDelete(this.createUri(resourcePath));
        Consumer<HttpRequestBase> deleteFunction = request -> this.execute((HttpUriRequest)request, this.contentType, endpointHttpHeaders, new AbstractFutureCallback<HttpStatusCode>(responseHandler){

            @Override
            public void onCompleted(HttpResponse result) {
                StatusLine statusLine = result.getStatusLine();
                responseHandler.onResponse(HttpStatusCode.fromStatusCode(statusLine.getStatusCode()), Olingo4AppImpl.headersToMap(result.getAllHeaders()));
            }
        });
        this.augmentWithETag(null, resourcePath, endpointHttpHeaders, deleteRequest, deleteFunction, responseHandler);
    }

    @Override
    public <T> void patch(Edm edm, String resourcePath, Map<String, String> endpointHttpHeaders, Object data, Olingo4ResponseHandler<T> responseHandler) {
        UriInfo uriInfo = Olingo4AppImpl.parseUri(edm, resourcePath, null, this.serviceUri);
        this.augmentWithETag(edm, resourcePath, endpointHttpHeaders, new HttpPatch(this.createUri(resourcePath, null)), request -> this.writeContent(edm, (HttpPatch)request, uriInfo, data, endpointHttpHeaders, responseHandler), responseHandler);
    }

    @Override
    public <T> void merge(Edm edm, String resourcePath, Map<String, String> endpointHttpHeaders, Object data, Olingo4ResponseHandler<T> responseHandler) {
        UriInfo uriInfo = Olingo4AppImpl.parseUri(edm, resourcePath, null, this.serviceUri);
        this.augmentWithETag(edm, resourcePath, endpointHttpHeaders, new HttpMerge(this.createUri(resourcePath, null)), request -> this.writeContent(edm, (HttpMerge)request, uriInfo, data, endpointHttpHeaders, responseHandler), responseHandler);
    }

    @Override
    public void batch(Edm edm, Map<String, String> endpointHttpHeaders, Object data, Olingo4ResponseHandler<List<Olingo4BatchResponse>> responseHandler) {
        UriInfo uriInfo = Olingo4AppImpl.parseUri(edm, SegmentType.BATCH.getValue(), null, this.serviceUri);
        this.writeContent(edm, new HttpPost(this.createUri(SegmentType.BATCH.getValue(), null)), uriInfo, data, endpointHttpHeaders, responseHandler);
    }

    @Override
    public <T> void action(Edm edm, String resourcePath, Map<String, String> endpointHttpHeaders, Object data, Olingo4ResponseHandler<T> responseHandler) {
        UriInfo uriInfo = Olingo4AppImpl.parseUri(edm, resourcePath, null, this.serviceUri);
        this.writeContent(edm, new HttpPost(this.createUri(resourcePath, null)), uriInfo, data, endpointHttpHeaders, responseHandler);
    }

    private ContentType getResourceContentType(UriInfo uriInfo) {
        ContentType resourceContentType;
        switch (uriInfo.getKind()) {
            case service: {
                resourceContentType = SERVICE_DOCUMENT_CONTENT_TYPE;
                break;
            }
            case metadata: {
                resourceContentType = METADATA_CONTENT_TYPE;
                break;
            }
            case resource: {
                List<UriResource> listResource = uriInfo.getUriResourceParts();
                UriResourceKind lastResourceKind = listResource.get(listResource.size() - 1).getKind();
                if (lastResourceKind == UriResourceKind.count || lastResourceKind == UriResourceKind.value) {
                    resourceContentType = TEXT_PLAIN_WITH_CS_UTF_8;
                    break;
                }
                resourceContentType = this.contentType;
                break;
            }
            default: {
                resourceContentType = this.contentType;
            }
        }
        return resourceContentType;
    }

    private <T> void augmentWithETag(Edm edm, final String resourcePath, final Map<String, String> endpointHttpHeaders, final HttpRequestBase httpRequest, final Consumer<HttpRequestBase> delegateRequestFn, final Olingo4ResponseHandler<T> delegateResponseHandler) {
        if (edm == null) {
            Olingo4ResponseHandler<Edm> edmResponseHandler = new Olingo4ResponseHandler<Edm>(){

                @Override
                public void onResponse(Edm response, Map<String, String> responseHeaders) {
                    Olingo4AppImpl.this.augmentWithETag(response, resourcePath, endpointHttpHeaders, httpRequest, delegateRequestFn, delegateResponseHandler);
                }

                @Override
                public void onException(Exception ex) {
                    delegateResponseHandler.onException(ex);
                }

                @Override
                public void onCanceled() {
                    delegateResponseHandler.onCanceled();
                }
            };
            this.read(null, "$metadata", null, null, edmResponseHandler);
        } else {
            Olingo4ResponseHandler eTagReadHandler = new Olingo4ResponseHandler<T>(){

                @Override
                public void onResponse(T response, Map<String, String> responseHeaders) {
                    if (response instanceof ClientEntity) {
                        ClientEntity e = (ClientEntity)response;
                        Optional.ofNullable(e.getETag()).ifPresent(v -> httpRequest.addHeader("If-Match", (String)v));
                    }
                    delegateRequestFn.accept(httpRequest);
                }

                @Override
                public void onException(Exception ex) {
                    delegateResponseHandler.onException(ex);
                }

                @Override
                public void onCanceled() {
                    delegateResponseHandler.onCanceled();
                }
            };
            this.read(edm, resourcePath, null, endpointHttpHeaders, eTagReadHandler);
        }
    }

    private <T> void readContent(UriInfo uriInfo, InputStream content, Map<String, String> endpointHttpHeaders, Olingo4ResponseHandler<T> responseHandler) {
        try {
            responseHandler.onResponse(this.readContent(uriInfo, content), endpointHttpHeaders);
        }
        catch (Exception e) {
            responseHandler.onException(e);
        }
        catch (Error e) {
            responseHandler.onException(new ODataException("Runtime Error Occurred", e));
        }
    }

    private <T> T readContent(UriInfo uriInfo, InputStream content) throws ODataException {
        ClientCollectionValue<ClientValue> response = null;
        block2 : switch (uriInfo.getKind()) {
            case service: {
                response = this.odataReader.readServiceDocument(content, SERVICE_DOCUMENT_CONTENT_TYPE);
                break;
            }
            case metadata: {
                response = this.odataReader.readMetadata(content);
                break;
            }
            case resource: {
                List<UriResource> listResource = uriInfo.getUriResourceParts();
                UriResourceKind lastResourceKind = listResource.get(listResource.size() - 1).getKind();
                switch (lastResourceKind) {
                    case entitySet: {
                        UriResourceEntitySet uriResourceEntitySet = (UriResourceEntitySet)listResource.get(listResource.size() - 1);
                        List<UriParameter> keyPredicates = uriResourceEntitySet.getKeyPredicates();
                        if (keyPredicates.size() >= 1) {
                            response = this.odataReader.readEntity(content, this.getResourceContentType(uriInfo));
                            break block2;
                        }
                        response = this.odataReader.readEntitySet(content, this.getResourceContentType(uriInfo));
                        break block2;
                    }
                    case count: {
                        String stringCount = null;
                        try {
                            stringCount = IOUtils.toString((InputStream)content, (Charset)Consts.UTF_8);
                            response = Long.valueOf(stringCount);
                            break block2;
                        }
                        catch (IOException e) {
                            throw new ODataException("Error during $count value deserialization", e);
                        }
                        catch (NumberFormatException e) {
                            throw new ODataException("Error during $count value conversion: " + stringCount, e);
                        }
                    }
                    case value: {
                        try {
                            ClientPrimitiveValue value = this.odataClient.getObjectFactory().newPrimitiveValueBuilder().setType(EdmPrimitiveTypeKind.String).setValue(IOUtils.toString((InputStream)content, (Charset)Consts.UTF_8)).build();
                            response = value;
                            break block2;
                        }
                        catch (IOException e) {
                            throw new ODataException("Error during $value deserialization", e);
                        }
                    }
                    case primitiveProperty: 
                    case complexProperty: {
                        ClientProperty property = this.odataReader.readProperty(content, this.getResourceContentType(uriInfo));
                        if (property.hasPrimitiveValue()) {
                            response = property.getPrimitiveValue();
                            break block2;
                        }
                        if (property.hasComplexValue()) {
                            response = property.getComplexValue();
                            break block2;
                        }
                        if (property.hasCollectionValue()) {
                            response = property.getCollectionValue();
                            break block2;
                        }
                        throw new ODataException("Unsupported property: " + property.getName());
                    }
                    case function: {
                        UriResourceFunction uriResourceFunction = (UriResourceFunction)listResource.get(listResource.size() - 1);
                        EdmReturnType functionReturnType = uriResourceFunction.getFunction().getReturnType();
                        switch (functionReturnType.getType().getKind()) {
                            case ENTITY: {
                                if (functionReturnType.isCollection()) {
                                    response = this.odataReader.readEntitySet(content, this.getResourceContentType(uriInfo));
                                    break block2;
                                }
                                response = this.odataReader.readEntity(content, this.getResourceContentType(uriInfo));
                                break block2;
                            }
                            case PRIMITIVE: 
                            case COMPLEX: {
                                ClientProperty functionProperty = this.odataReader.readProperty(content, this.getResourceContentType(uriInfo));
                                if (functionProperty.hasPrimitiveValue()) {
                                    response = functionProperty.getPrimitiveValue();
                                    break block2;
                                }
                                if (functionProperty.hasComplexValue()) {
                                    response = functionProperty.getComplexValue();
                                    break block2;
                                }
                                if (functionProperty.hasCollectionValue()) {
                                    response = functionProperty.getCollectionValue();
                                    break block2;
                                }
                                throw new ODataException("Unsupported property: " + functionProperty.getName());
                            }
                        }
                        throw new ODataException("Unsupported function return type " + uriInfo.getKind().name());
                    }
                }
                throw new ODataException("Unsupported resource type: " + lastResourceKind.name());
            }
            default: {
                throw new ODataException("Unsupported resource type " + uriInfo.getKind().name());
            }
        }
        return (T)response;
    }

    private <T> void writeContent(final Edm edm, HttpEntityEnclosingRequestBase httpEntityRequest, final UriInfo uriInfo, final Object content, Map<String, String> endpointHttpHeaders, final Olingo4ResponseHandler<T> responseHandler) {
        try {
            httpEntityRequest.setEntity(this.writeContent(edm, uriInfo, content));
            Header requestContentTypeHeader = httpEntityRequest.getEntity().getContentType();
            ContentType requestContentType = requestContentTypeHeader != null ? ContentType.parse(requestContentTypeHeader.getValue()) : this.contentType;
            this.execute(httpEntityRequest, requestContentType, endpointHttpHeaders, new AbstractFutureCallback<T>(responseHandler){

                @Override
                public void onCompleted(HttpResponse result) throws IOException, ODataException {
                    boolean noEntity;
                    HttpStatusCode statusCode = HttpStatusCode.fromStatusCode(result.getStatusLine().getStatusCode());
                    boolean bl = noEntity = result.getEntity() == null || result.getEntity().getContentLength() == 0L;
                    if (statusCode == HttpStatusCode.NO_CONTENT || noEntity) {
                        responseHandler.onResponse(HttpStatusCode.fromStatusCode(result.getStatusLine().getStatusCode()), Olingo4AppImpl.headersToMap(result.getAllHeaders()));
                    } else if (uriInfo.getKind() == UriInfoKind.resource) {
                        List<UriResource> listResource = uriInfo.getUriResourceParts();
                        UriResourceKind lastResourceKind = listResource.get(listResource.size() - 1).getKind();
                        switch (lastResourceKind) {
                            case entitySet: 
                            case action: {
                                ClientEntity entity = Olingo4AppImpl.this.odataReader.readEntity(result.getEntity().getContent(), ContentType.parse(result.getEntity().getContentType().getValue()));
                                responseHandler.onResponse(entity, Olingo4AppImpl.headersToMap(result.getAllHeaders()));
                                break;
                            }
                        }
                    } else if (uriInfo.getKind() == UriInfoKind.batch) {
                        List<Olingo4BatchResponse> batchResponse = Olingo4AppImpl.this.parseBatchResponse(edm, result, (List)content);
                        responseHandler.onResponse(batchResponse, Olingo4AppImpl.headersToMap(result.getAllHeaders()));
                    } else {
                        throw new ODataException("Unsupported resource type: " + uriInfo.getKind().name());
                    }
                }
            });
        }
        catch (Exception e) {
            responseHandler.onException(e);
        }
        catch (Error e) {
            responseHandler.onException(new ODataException("Runtime Error Occurred", e));
        }
    }

    private AbstractHttpEntity writeContent(Edm edm, UriInfo uriInfo, Object content) throws ODataException {
        AbstractHttpEntity httpEntity;
        if (uriInfo.getKind() == UriInfoKind.resource) {
            List<UriResource> listResource = uriInfo.getUriResourceParts();
            UriResourceKind lastResourceKind = listResource.get(listResource.size() - 1).getKind();
            switch (lastResourceKind) {
                case action: {
                    if (content == null) {
                        httpEntity = new ByteArrayEntity(new byte[0]);
                        break;
                    }
                    httpEntity = this.writeContent(uriInfo, content);
                    break;
                }
                case entitySet: {
                    httpEntity = this.writeContent(uriInfo, content);
                    break;
                }
                default: {
                    throw new ODataException("Unsupported resource type: " + lastResourceKind);
                }
            }
        } else if (uriInfo.getKind() == UriInfoKind.batch) {
            String boundary = BOUNDARY_PREFIX + UUID.randomUUID();
            String contentHeader = BATCH_CONTENT_TYPE + BOUNDARY_PARAMETER + boundary;
            List batchParts = (List)content;
            InputStream requestStream = this.serializeBatchRequest(edm, batchParts, BOUNDARY_DOUBLE_DASH + boundary);
            httpEntity = this.writeContent(requestStream);
            httpEntity.setContentType(contentHeader);
        } else {
            throw new ODataException("Unsupported resource type: " + uriInfo.getKind().name());
        }
        return httpEntity;
    }

    private AbstractHttpEntity writeContent(UriInfo uriInfo, Object content) throws ODataException {
        AbstractHttpEntity httpEntity;
        if (content instanceof ClientEntity) {
            InputStream requestStream = this.odataWriter.writeEntity((ClientEntity)content, this.getResourceContentType(uriInfo));
            httpEntity = this.writeContent(requestStream);
        } else if (content instanceof String) {
            httpEntity = new StringEntity((String)content, org.apache.http.entity.ContentType.APPLICATION_JSON);
        } else {
            throw new ODataException("Unsupported content type: " + content);
        }
        httpEntity.setChunked(false);
        return httpEntity;
    }

    private AbstractHttpEntity writeContent(InputStream inputStream) throws ODataException {
        ByteArrayEntity httpEntity;
        try {
            httpEntity = new ByteArrayEntity(IOUtils.toByteArray((InputStream)inputStream));
        }
        catch (IOException e) {
            throw new ODataException("Error during converting input stream to byte array", e);
        }
        httpEntity.setChunked(false);
        return httpEntity;
    }

    private InputStream serializeBatchRequest(Edm edm, List<Olingo4BatchRequest> batchParts, String boundary) throws ODataException {
        ByteArrayOutputStream batchRequestHeaderOutputStream = new ByteArrayOutputStream();
        try {
            batchRequestHeaderOutputStream.write(boundary.getBytes(StandardCharsets.UTF_8));
            batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
            for (Olingo4BatchRequest batchPart : batchParts) {
                String acceptCharset;
                ContentType acceptType;
                UriInfo uriInfo;
                this.writeHttpHeader(batchRequestHeaderOutputStream, "Content-Type", ContentType.APPLICATION_HTTP.toContentTypeString());
                this.writeHttpHeader(batchRequestHeaderOutputStream, "Content-Transfer-Encoding: binary", null);
                if (batchPart instanceof Olingo4BatchQueryRequest) {
                    Olingo4BatchQueryRequest batchQueryPart = (Olingo4BatchQueryRequest)batchPart;
                    String batchQueryUri = this.createUri(StringUtils.isBlank(batchQueryPart.getResourceUri()) ? this.serviceUri : batchQueryPart.getResourceUri(), batchQueryPart.getResourcePath(), this.concatQueryParams(batchQueryPart.getQueryParams()));
                    uriInfo = Olingo4AppImpl.parseUri(edm, batchQueryPart.getResourcePath(), this.concatQueryParams(batchQueryPart.getQueryParams()), this.serviceUri);
                    batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    batchRequestHeaderOutputStream.write(("GET " + batchQueryUri + " " + HttpVersion.HTTP_1_1).getBytes(StandardCharsets.UTF_8));
                    batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    acceptType = this.getResourceContentType(uriInfo);
                    acceptCharset = acceptType.getParameter("charset");
                    this.writeHttpHeader(batchRequestHeaderOutputStream, "Accept", this.contentType.getType().toLowerCase() + SEPARATOR + this.contentType.getSubtype().toLowerCase());
                    if (null != acceptCharset) {
                        this.writeHttpHeader(batchRequestHeaderOutputStream, "Accept-Charset", acceptCharset.toLowerCase());
                    }
                    batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    batchRequestHeaderOutputStream.write(boundary.getBytes(StandardCharsets.UTF_8));
                    batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    continue;
                }
                if (batchPart instanceof Olingo4BatchChangeRequest) {
                    Olingo4BatchChangeRequest batchChangePart = (Olingo4BatchChangeRequest)batchPart;
                    String batchChangeUri = this.createUri(StringUtils.isBlank(batchChangePart.getResourceUri()) ? this.serviceUri : batchChangePart.getResourceUri(), batchChangePart.getResourcePath(), null);
                    uriInfo = Olingo4AppImpl.parseUri(edm, batchChangePart.getResourcePath(), null, this.serviceUri);
                    if (batchChangePart.getOperation() != Operation.DELETE) {
                        this.writeHttpHeader(batchRequestHeaderOutputStream, CONTENT_ID_HEADER, batchChangePart.getContentId());
                    }
                    batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    batchRequestHeaderOutputStream.write((batchChangePart.getOperation().getHttpMethod() + " " + batchChangeUri + " " + HttpVersion.HTTP_1_1).getBytes(StandardCharsets.UTF_8));
                    batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    this.writeHttpHeader(batchRequestHeaderOutputStream, "OData-Version", ODataServiceVersion.V40.toString());
                    acceptType = this.getResourceContentType(uriInfo);
                    acceptCharset = acceptType.getParameter("charset");
                    this.writeHttpHeader(batchRequestHeaderOutputStream, "Accept", this.contentType.getType().toLowerCase() + SEPARATOR + this.contentType.getSubtype().toLowerCase());
                    if (null != acceptCharset) {
                        this.writeHttpHeader(batchRequestHeaderOutputStream, "Accept-Charset", acceptCharset.toLowerCase());
                    }
                    this.writeHttpHeader(batchRequestHeaderOutputStream, "Content-Type", acceptType.toContentTypeString());
                    if (batchChangePart.getOperation() != Operation.DELETE) {
                        batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                        AbstractHttpEntity httpEnity = this.writeContent(edm, uriInfo, batchChangePart.getBody());
                        batchRequestHeaderOutputStream.write(IOUtils.toByteArray((InputStream)httpEnity.getContent()));
                        batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                        batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    } else {
                        batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    }
                    batchRequestHeaderOutputStream.write(boundary.getBytes(StandardCharsets.UTF_8));
                    batchRequestHeaderOutputStream.write(ODataStreamer.CRLF);
                    continue;
                }
                throw new ODataException("Unsupported batch part request object type: " + batchPart);
            }
        }
        catch (Exception e) {
            throw new ODataException("Error during batch request serialization", e);
        }
        return new ByteArrayInputStream(batchRequestHeaderOutputStream.toByteArray());
    }

    private void writeHttpHeader(ByteArrayOutputStream headerOutputStream, String headerName, String headerValue) throws IOException {
        headerOutputStream.write(this.createHttpHeader(headerName, headerValue).getBytes(StandardCharsets.UTF_8));
        headerOutputStream.write(ODataStreamer.CRLF);
    }

    private String createHttpHeader(String headerName, String headerValue) {
        return headerName + (String)(StringUtils.isBlank(headerValue) ? "" : ": " + headerValue);
    }

    private List<Olingo4BatchResponse> parseBatchResponse(Edm edm, HttpResponse response, List<Olingo4BatchRequest> batchRequest) throws ODataException {
        ArrayList<Olingo4BatchResponse> batchResponse = new ArrayList<Olingo4BatchResponse>();
        try {
            Header[] contentHeaders = response.getHeaders("Content-Type");
            ODataBatchLineIteratorImpl batchLineIterator = new ODataBatchLineIteratorImpl(IOUtils.lineIterator((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8));
            String batchBoundary = ODataBatchUtilities.getBoundaryFromHeader(this.getHeadersCollection(contentHeaders));
            ODataBatchController batchController = new ODataBatchController(batchLineIterator, batchBoundary);
            batchController.getBatchLineIterator().next();
            int batchRequestIndex = 0;
            while (batchController.getBatchLineIterator().hasNext()) {
                UriInfo uriInfo;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ODataBatchUtilities.readBatchPart(batchController, os, false);
                ODataError content = null;
                Olingo4BatchRequest batchPartRequest = batchRequest.get(batchRequestIndex);
                HttpResponse batchPartHttpResponse = this.constructBatchPartHttpResponse(new ByteArrayInputStream(os.toByteArray()));
                StatusLine batchPartStatusLine = batchPartHttpResponse.getStatusLine();
                int batchPartLineStatusCode = batchPartStatusLine.getStatusCode();
                Map<String, String> batchPartHeaders = this.getHeadersValueMap(batchPartHttpResponse.getAllHeaders());
                if (batchPartRequest instanceof Olingo4BatchQueryRequest) {
                    Olingo4BatchQueryRequest batchPartQueryRequest = (Olingo4BatchQueryRequest)batchPartRequest;
                    uriInfo = Olingo4AppImpl.parseUri(edm, batchPartQueryRequest.getResourcePath(), null, this.serviceUri);
                    if (HttpStatusCode.BAD_REQUEST.getStatusCode() <= batchPartLineStatusCode && batchPartLineStatusCode <= 599) {
                        ContentType responseContentType = Olingo4Helper.getContentTypeHeader(batchPartHttpResponse);
                        content = this.odataReader.readError(batchPartHttpResponse.getEntity().getContent(), responseContentType);
                    } else if (batchPartLineStatusCode != HttpStatusCode.NO_CONTENT.getStatusCode()) {
                        content = (ODataError)this.readContent(uriInfo, batchPartHttpResponse.getEntity().getContent());
                    }
                    Olingo4BatchResponse batchPartResponse = new Olingo4BatchResponse(batchPartStatusLine.getStatusCode(), batchPartStatusLine.getReasonPhrase(), null, batchPartHeaders, content);
                    batchResponse.add(batchPartResponse);
                } else if (batchPartRequest instanceof Olingo4BatchChangeRequest) {
                    Olingo4BatchChangeRequest batchPartChangeRequest = (Olingo4BatchChangeRequest)batchPartRequest;
                    if (batchPartLineStatusCode != HttpStatusCode.NO_CONTENT.getStatusCode()) {
                        if (HttpStatusCode.BAD_REQUEST.getStatusCode() <= batchPartLineStatusCode && batchPartLineStatusCode <= 599) {
                            ContentType responseContentType = ContentType.parse(batchPartHttpResponse.getFirstHeader("Content-Type").getValue());
                            content = this.odataReader.readError(response.getEntity().getContent(), responseContentType);
                        } else {
                            uriInfo = Olingo4AppImpl.parseUri(edm, batchPartChangeRequest.getResourcePath() + (batchPartChangeRequest.getOperation() == Operation.CREATE ? CLIENT_ENTITY_FAKE_MARKER : ""), null, this.serviceUri);
                            content = this.readContent(uriInfo, batchPartHttpResponse.getEntity().getContent());
                        }
                    }
                    Olingo4BatchResponse batchPartResponse = new Olingo4BatchResponse(batchPartStatusLine.getStatusCode(), batchPartStatusLine.getReasonPhrase(), batchPartChangeRequest.getContentId(), batchPartHeaders, content);
                    batchResponse.add(batchPartResponse);
                } else {
                    throw new ODataException("Unsupported batch part request object type: " + batchPartRequest);
                }
                ++batchRequestIndex;
            }
        }
        catch (IOException | HttpException e) {
            throw new ODataException(e);
        }
        return batchResponse;
    }

    private HttpResponse constructBatchPartHttpResponse(InputStream batchPartStream) throws IOException, HttpException {
        LineIterator lines = IOUtils.lineIterator((InputStream)batchPartStream, (Charset)StandardCharsets.UTF_8);
        ByteArrayOutputStream headerOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream bodyOutputStream = new ByteArrayOutputStream();
        boolean startBatchPartHeader = false;
        boolean startBatchPartBody = false;
        while (lines.hasNext()) {
            String line = lines.nextLine().trim();
            if (line.startsWith("HTTP")) {
                startBatchPartHeader = true;
            }
            if (startBatchPartHeader && StringUtils.isBlank(line)) {
                startBatchPartHeader = false;
                startBatchPartBody = true;
            }
            if (startBatchPartHeader) {
                headerOutputStream.write(line.getBytes(StandardCharsets.UTF_8));
                headerOutputStream.write(ODataStreamer.CRLF);
                continue;
            }
            if (!startBatchPartBody || !StringUtils.isNotBlank(line)) continue;
            bodyOutputStream.write(line.getBytes(StandardCharsets.UTF_8));
            bodyOutputStream.write(ODataStreamer.CRLF);
        }
        HttpTransportMetricsImpl metrics = new HttpTransportMetricsImpl();
        SessionInputBufferImpl sessionInputBuffer = new SessionInputBufferImpl(metrics, 2048);
        DefaultHttpResponseFactory responseFactory = new DefaultHttpResponseFactory();
        sessionInputBuffer.bind(new ByteArrayInputStream(headerOutputStream.toByteArray()));
        DefaultHttpResponseParser responseParser = new DefaultHttpResponseParser((SessionInputBuffer)sessionInputBuffer, (LineParser)new BasicLineParser(), (HttpResponseFactory)responseFactory, MessageConstraints.DEFAULT);
        HttpResponse response = (HttpResponse)responseParser.parse();
        response.setEntity(new ByteArrayEntity(bodyOutputStream.toByteArray()));
        return response;
    }

    private Collection<String> getHeadersCollection(Header[] headers) {
        ArrayList<String> headersCollection = new ArrayList<String>();
        for (Header header : Arrays.asList(headers)) {
            headersCollection.add(header.getValue());
        }
        return headersCollection;
    }

    private Map<String, String> getHeadersValueMap(Header[] headers) {
        HashMap<String, String> headersValueMap = new HashMap<String, String>();
        for (Header header : Arrays.asList(headers)) {
            headersValueMap.put(header.getName(), header.getValue());
        }
        return headersValueMap;
    }

    private String createUri(String resourcePath) {
        return this.createUri(this.serviceUri, resourcePath, null);
    }

    private String createUri(String resourcePath, String queryOptions) {
        return this.createUri(this.serviceUri, resourcePath, queryOptions);
    }

    private String createUri(String resourceUri, String resourcePath, String queryOptions) {
        StringBuilder absolutUri = new StringBuilder(resourceUri).append(SEPARATOR).append(resourcePath);
        if (queryOptions != null && !queryOptions.isEmpty()) {
            absolutUri.append("?" + queryOptions);
        }
        return absolutUri.toString();
    }

    private String concatQueryParams(Map<String, String> queryParams) {
        StringBuilder concatQuery = new StringBuilder("");
        if (queryParams != null && !queryParams.isEmpty()) {
            int nParams = queryParams.size();
            int index = 0;
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                concatQuery.append(entry.getKey()).append('=').append(entry.getValue());
                if (++index >= nParams) continue;
                concatQuery.append('&');
            }
        }
        return concatQuery.toString().replaceAll("  *", "%20");
    }

    private static UriInfo parseUri(Edm edm, String resourcePath, String queryOptions, String serviceUri) {
        UriInfo result;
        Parser parser = new Parser(edm, OData.newInstance());
        try {
            result = parser.parseUri(resourcePath, queryOptions, null, serviceUri);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("parseUri (" + resourcePath + "," + queryOptions + "): " + e.getMessage(), e);
        }
        return result;
    }

    private static Map<String, String> headersToMap(Header[] headers) {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        for (Header header : headers) {
            responseHeaders.put(header.getName(), header.getValue());
        }
        return responseHeaders;
    }

    public void execute(HttpUriRequest httpUriRequest, ContentType contentType, Map<String, String> endpointHttpHeaders, FutureCallback<HttpResponse> callback) {
        if (!ContentType.APPLICATION_FORM_URLENCODED.equals(contentType) && !contentType.toContentTypeString().startsWith(MULTIPART_MIME_TYPE)) {
            httpUriRequest.addHeader("Accept", contentType.getType().toLowerCase() + SEPARATOR + contentType.getSubtype().toLowerCase());
            String acceptCharset = contentType.getParameter("charset");
            if (null != acceptCharset) {
                httpUriRequest.addHeader("Accept-Charset", acceptCharset.toLowerCase());
            }
        }
        if (httpUriRequest instanceof HttpEntityEnclosingRequestBase && httpUriRequest.getFirstHeader("Content-Type") == null) {
            httpUriRequest.addHeader("Content-Type", contentType.toString());
        }
        if (ObjectHelper.isNotEmpty(this.httpHeaders)) {
            for (Map.Entry<String, String> entry : this.httpHeaders.entrySet()) {
                httpUriRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (ObjectHelper.isNotEmpty(endpointHttpHeaders)) {
            for (Map.Entry<String, String> entry : endpointHttpHeaders.entrySet()) {
                httpUriRequest.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (!httpUriRequest.containsHeader("Accept-Charset")) {
            httpUriRequest.addHeader("Accept-Charset", "UTF-8".toLowerCase());
        }
        if (!httpUriRequest.containsHeader("OData-Version")) {
            httpUriRequest.addHeader("OData-Version", ODataServiceVersion.V40.toString());
        }
        if (!httpUriRequest.containsHeader("OData-MaxVersion")) {
            httpUriRequest.addHeader("OData-MaxVersion", ODataServiceVersion.V40.toString());
        }
        if (this.client instanceof CloseableHttpAsyncClient) {
            ((CloseableHttpAsyncClient)this.client).execute(httpUriRequest, callback);
        } else {
            try {
                CloseableHttpResponse result = ((CloseableHttpClient)this.client).execute(httpUriRequest);
                callback.completed(result);
            }
            catch (IOException e) {
                callback.failed(e);
            }
        }
    }
}

