/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.batch;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.client.api.communication.request.batch.ODataBatchLineIterator;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchController;
import org.apache.olingo.commons.api.format.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataBatchUtilities {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final Logger LOG = LoggerFactory.getLogger(ODataBatchUtilities.class);
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("HTTP/\\d\\.\\d (\\d+) (.*)", 2);

    public static String readBatchPart(ODataBatchController batchController, boolean checkCurrent) {
        return ODataBatchUtilities.readBatchPart(batchController, null, -1, checkCurrent);
    }

    public static String readBatchPart(ODataBatchController batchController, int count) {
        return ODataBatchUtilities.readBatchPart(batchController, null, count, true);
    }

    public static String readBatchPart(ODataBatchController controller, OutputStream os, boolean checkCurrent) {
        return ODataBatchUtilities.readBatchPart(controller, os, -1, checkCurrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readBatchPart(ODataBatchController controller, OutputStream os, int count, boolean checkCurrent) {
        String currentLine;
        ODataBatchLineIterator oDataBatchLineIterator = controller.getBatchLineIterator();
        synchronized (oDataBatchLineIterator) {
            String string = currentLine = checkCurrent ? controller.getBatchLineIterator().getCurrent() : null;
            if (count < 0) {
                try {
                    boolean notEndLine = ODataBatchUtilities.isNotEndLine(controller, currentLine);
                    while (controller.isValidBatch() && notEndLine && controller.getBatchLineIterator().hasNext()) {
                        currentLine = controller.getBatchLineIterator().nextLine();
                        LOG.debug("Read line '{}' (end-line '{}')", (Object)currentLine, (Object)controller.getBoundary());
                        notEndLine = ODataBatchUtilities.isNotEndLine(controller, currentLine);
                        if (!notEndLine || os == null || currentLine == null) continue;
                        os.write(currentLine.getBytes("UTF-8"));
                        os.write(CRLF);
                    }
                }
                catch (IOException e) {
                    LOG.error("Error reading batch part", (Throwable)e);
                    throw new IllegalStateException(e);
                }
            } else {
                for (int i = 0; controller.isValidBatch() && controller.getBatchLineIterator().hasNext() && i < count; ++i) {
                    currentLine = controller.getBatchLineIterator().nextLine();
                }
            }
        }
        return currentLine;
    }

    public static Map<String, Collection<String>> readHeaders(ODataBatchLineIterator iterator) {
        TreeMap<String, Collection<String>> target = new TreeMap<String, Collection<String>>(String.CASE_INSENSITIVE_ORDER);
        ODataBatchUtilities.readHeaders(iterator, target);
        return target;
    }

    public static void readHeaders(ODataBatchLineIterator iterator, Map<String, Collection<String>> target) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ODataBatchUtilities.readBatchPart(new ODataBatchController(iterator, null), baos, true);
            LineIterator headers = IOUtils.lineIterator((InputStream)new ByteArrayInputStream(baos.toByteArray()), (String)"UTF-8");
            while (headers.hasNext()) {
                String line = headers.nextLine().trim();
                if (!StringUtils.isNotBlank(line)) continue;
                ODataBatchUtilities.addHeaderLine(line, target);
            }
        }
        catch (Exception e) {
            LOG.error("Error retrieving headers", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public static void addHeaderLine(String headerLine, Map<String, Collection<String>> targetMap) {
        int sep = headerLine.indexOf(58);
        if (sep > 0 && sep < headerLine.length() - 1) {
            Collection<Object> value;
            String key = headerLine.substring(0, sep).trim();
            if (targetMap.containsKey(key)) {
                value = targetMap.get(key);
            } else {
                value = new HashSet();
                targetMap.put(key, value);
            }
            value.add(headerLine.substring(sep + 1, headerLine.length()).trim());
        }
    }

    public static String getBoundaryFromHeader(Collection<String> contentType) {
        String res;
        int start;
        String boundaryKey = "boundary=";
        if (contentType == null || contentType.isEmpty() || !contentType.toString().contains("boundary=")) {
            throw new IllegalArgumentException("Invalid content type");
        }
        String headerValue = contentType.toString();
        int end = headerValue.indexOf(59, start = headerValue.indexOf("boundary=") + "boundary=".length());
        if (end < 0) {
            end = headerValue.indexOf(93, start);
        }
        return (res = headerValue.substring(start, end)).startsWith("--") ? res : "--" + res;
    }

    public static Map.Entry<Integer, String> readResponseLine(ODataBatchLineIterator iterator) {
        Matcher matcher;
        String line = ODataBatchUtilities.readBatchPart(new ODataBatchController(iterator, null), 1);
        LOG.debug("Response line '{}'", (Object)line);
        if (line != null && (matcher = RESPONSE_PATTERN.matcher(line.trim())).matches()) {
            return new AbstractMap.SimpleEntry<Integer, String>(Integer.valueOf(matcher.group(1)), matcher.group(2));
        }
        throw new IllegalArgumentException("Invalid response line '" + line + "'");
    }

    public static Map<String, Collection<String>> nextItemHeaders(ODataBatchLineIterator iterator, String boundary) {
        TreeMap<String, Collection<String>> headers = new TreeMap<String, Collection<String>>(String.CASE_INSENSITIVE_ORDER);
        String line = ODataBatchUtilities.readBatchPart(new ODataBatchController(iterator, boundary), true);
        if (line != null && line.trim().equals(boundary)) {
            ODataBatchUtilities.readHeaders(iterator, headers);
        }
        LOG.debug("Retrieved batch item headers {}", headers);
        return headers;
    }

    public static BatchItemType getItemType(Map<String, Collection<String>> headers) {
        String contentType;
        String string = contentType = headers.containsKey("Content-Type") ? headers.get("Content-Type").toString() : "";
        BatchItemType nextItemType = contentType.contains(ContentType.MULTIPART_MIXED.toContentTypeString()) ? BatchItemType.CHANGESET : (contentType.contains("application/http") ? BatchItemType.RETRIEVE : BatchItemType.NONE);
        LOG.debug("Retrieved next item type {}", (Object)nextItemType);
        return nextItemType;
    }

    private static boolean isNotEndLine(ODataBatchController controller, String line) {
        return line == null || StringUtils.isBlank(controller.getBoundary()) && StringUtils.isNotBlank(line) || StringUtils.isNotBlank(controller.getBoundary()) && !line.startsWith(controller.getBoundary());
    }

    public static enum BatchItemType {
        NONE,
        CHANGESET,
        RETRIEVE;

    }
}

