/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataContent;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.OlingoExtension;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.debug.DebugSupport;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.etag.CustomETagSupport;
import org.apache.olingo.server.api.processor.Processor;
import org.apache.olingo.server.api.serializer.CustomContentTypeSupport;
import org.apache.olingo.server.core.ODataExceptionHelper;
import org.apache.olingo.server.core.ODataHandlerException;
import org.apache.olingo.server.core.ODataHandlerImpl;
import org.apache.olingo.server.core.debug.ServerCoreDebugger;

public class ODataHttpHandlerImpl
implements ODataHttpHandler {
    public static final int COPY_BUFFER_SIZE = 8192;
    private static final String REQUESTMAPPING = "requestMapping";
    private final ODataHandlerImpl handler;
    private final ServerCoreDebugger debugger;
    private int split = 0;

    public ODataHttpHandlerImpl(OData odata, ServiceMetadata serviceMetadata) {
        this.debugger = new ServerCoreDebugger(odata);
        this.handler = new ODataHandlerImpl(odata, serviceMetadata, this.debugger);
    }

    @Override
    public ODataResponse process(ODataRequest request) {
        return this.handler.process(request);
    }

    @Override
    public void process(HttpServletRequest request, HttpServletResponse response) {
        ODataResponse odResponse;
        ODataRequest odRequest = new ODataRequest();
        Exception exception = null;
        this.debugger.resolveDebugMode(request);
        int processMethodHandle = this.debugger.startRuntimeMeasurement("ODataHttpHandlerImpl", "process");
        try {
            this.fillODataRequest(odRequest, request, this.split);
            odResponse = this.process(odRequest);
        }
        catch (Exception e) {
            exception = e;
            odResponse = this.handleException(odRequest, e);
        }
        this.debugger.stopRuntimeMeasurement(processMethodHandle);
        if (this.debugger.isDebugMode()) {
            Map<String, String> serverEnvironmentVariables = this.createEnvironmentVariablesMap(request);
            if (exception == null) {
                exception = this.handler.getLastThrownException();
            }
            odResponse = this.debugger.createDebugResponse(odRequest, odResponse, exception, this.handler.getUriInfo(), serverEnvironmentVariables);
        }
        ODataHttpHandlerImpl.convertToHttp(response, odResponse);
    }

    private Map<String, String> createEnvironmentVariablesMap(HttpServletRequest request) {
        LinkedHashMap<String, String> environment = new LinkedHashMap<String, String>();
        environment.put("authType", request.getAuthType());
        environment.put("localAddr", request.getLocalAddr());
        environment.put("localName", request.getLocalName());
        environment.put("localPort", this.getIntAsString(request.getLocalPort()));
        environment.put("pathInfo", request.getPathInfo());
        environment.put("pathTranslated", request.getPathTranslated());
        environment.put("remoteAddr", request.getRemoteAddr());
        environment.put("remoteHost", request.getRemoteHost());
        environment.put("remotePort", this.getIntAsString(request.getRemotePort()));
        environment.put("remoteUser", request.getRemoteUser());
        environment.put("scheme", request.getScheme());
        environment.put("serverName", request.getServerName());
        environment.put("serverPort", this.getIntAsString(request.getServerPort()));
        environment.put("servletPath", request.getServletPath());
        return environment;
    }

    private String getIntAsString(int number) {
        return number == 0 ? "unknown" : Integer.toString(number);
    }

    @Override
    public void setSplit(int split) {
        this.split = split;
    }

    private ODataResponse handleException(ODataRequest odRequest, Exception e) {
        ODataResponse resp = new ODataResponse();
        ODataServerError serverError = e instanceof ODataHandlerException ? ODataExceptionHelper.createServerErrorObject((ODataHandlerException)e, null) : (e instanceof ODataLibraryException ? ODataExceptionHelper.createServerErrorObject((ODataLibraryException)e, null) : ODataExceptionHelper.createServerErrorObject(e));
        this.handler.handleException(odRequest, resp, serverError, e);
        return resp;
    }

    static void convertToHttp(HttpServletResponse response, ODataResponse odResponse) {
        response.setStatus(odResponse.getStatusCode());
        for (Map.Entry<String, List<String>> entry : odResponse.getAllHeaders().entrySet()) {
            for (String headerValue : entry.getValue()) {
                response.addHeader(entry.getKey(), headerValue);
            }
        }
        if (odResponse.getContent() != null) {
            ODataHttpHandlerImpl.copyContent(odResponse.getContent(), response);
        } else if (odResponse.getODataContent() != null) {
            ODataHttpHandlerImpl.writeContent(odResponse, response);
        }
    }

    static void writeContent(ODataResponse odataResponse, HttpServletResponse servletResponse) {
        try {
            ODataContent res = odataResponse.getODataContent();
            res.write(Channels.newChannel((OutputStream)servletResponse.getOutputStream()));
        }
        catch (IOException e) {
            throw new ODataRuntimeException("Error on reading request content", e);
        }
    }

    static void copyContent(InputStream inputStream, HttpServletResponse servletResponse) {
        ODataHttpHandlerImpl.copyContent(Channels.newChannel(inputStream), servletResponse);
    }

    static void copyContent(ReadableByteChannel input, HttpServletResponse servletResponse) {
        try (WritableByteChannel output = Channels.newChannel((OutputStream)servletResponse.getOutputStream());){
            ByteBuffer inBuffer = ByteBuffer.allocate(8192);
            while (input.read(inBuffer) > 0) {
                inBuffer.flip();
                output.write(inBuffer);
                inBuffer.clear();
            }
        }
        catch (IOException e) {
            throw new ODataRuntimeException("Error on reading request content", e);
        }
        finally {
            ODataHttpHandlerImpl.closeStream(input);
        }
    }

    private static void closeStream(Channel closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private ODataRequest fillODataRequest(ODataRequest odRequest, HttpServletRequest httpRequest, int split) throws ODataLibraryException {
        int requestHandle = this.debugger.startRuntimeMeasurement("ODataHttpHandlerImpl", "fillODataRequest");
        try {
            odRequest.setBody((InputStream)httpRequest.getInputStream());
            odRequest.setProtocol(httpRequest.getProtocol());
            odRequest.setMethod(ODataHttpHandlerImpl.extractMethod(httpRequest));
            int innerHandle = this.debugger.startRuntimeMeasurement("ODataHttpHandlerImpl", "copyHeaders");
            ODataHttpHandlerImpl.copyHeaders(odRequest, httpRequest);
            this.debugger.stopRuntimeMeasurement(innerHandle);
            innerHandle = this.debugger.startRuntimeMeasurement("ODataHttpHandlerImpl", "fillUriInformation");
            ODataHttpHandlerImpl.fillUriInformation(odRequest, httpRequest, split);
            this.debugger.stopRuntimeMeasurement(innerHandle);
            ODataRequest oDataRequest = odRequest;
            return oDataRequest;
        }
        catch (IOException e) {
            throw new DeserializerException("An I/O exception occurred.", (Throwable)e, DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
        }
        finally {
            this.debugger.stopRuntimeMeasurement(requestHandle);
        }
    }

    static HttpMethod extractMethod(HttpServletRequest httpRequest) throws ODataLibraryException {
        HttpMethod httpRequestMethod;
        try {
            httpRequestMethod = HttpMethod.valueOf(httpRequest.getMethod());
        }
        catch (IllegalArgumentException e) {
            throw new ODataHandlerException("HTTP method not allowed" + httpRequest.getMethod(), (Throwable)e, ODataHandlerException.MessageKeys.HTTP_METHOD_NOT_ALLOWED, httpRequest.getMethod());
        }
        try {
            if (httpRequestMethod == HttpMethod.POST) {
                String xHttpMethod = httpRequest.getHeader("X-HTTP-Method");
                String xHttpMethodOverride = httpRequest.getHeader("X-HTTP-Method-Override");
                if (xHttpMethod == null && xHttpMethodOverride == null) {
                    return httpRequestMethod;
                }
                if (xHttpMethod == null) {
                    return HttpMethod.valueOf(xHttpMethodOverride);
                }
                if (xHttpMethodOverride == null) {
                    return HttpMethod.valueOf(xHttpMethod);
                }
                if (!xHttpMethod.equalsIgnoreCase(xHttpMethodOverride)) {
                    throw new ODataHandlerException("Ambiguous X-HTTP-Methods", ODataHandlerException.MessageKeys.AMBIGUOUS_XHTTP_METHOD, xHttpMethod, xHttpMethodOverride);
                }
                return HttpMethod.valueOf(xHttpMethod);
            }
            return httpRequestMethod;
        }
        catch (IllegalArgumentException e) {
            throw new ODataHandlerException("Invalid HTTP method" + httpRequest.getMethod(), (Throwable)e, ODataHandlerException.MessageKeys.INVALID_HTTP_METHOD, httpRequest.getMethod());
        }
    }

    static void fillUriInformation(ODataRequest odRequest, HttpServletRequest httpRequest, int split) {
        String rawODataPath;
        String rawRequestUri = httpRequest.getRequestURL().toString();
        String rawServiceResolutionUri = null;
        if (httpRequest.getAttribute(REQUESTMAPPING) != null) {
            String requestMapping;
            rawServiceResolutionUri = requestMapping = httpRequest.getAttribute(REQUESTMAPPING).toString();
            int beginIndex = rawRequestUri.indexOf(requestMapping) + requestMapping.length();
            rawODataPath = rawRequestUri.substring(beginIndex);
        } else if (!"".equals(httpRequest.getServletPath())) {
            int beginIndex = rawRequestUri.indexOf(httpRequest.getServletPath()) + httpRequest.getServletPath().length();
            rawODataPath = rawRequestUri.substring(beginIndex);
        } else if (!"".equals(httpRequest.getContextPath())) {
            int beginIndex = rawRequestUri.indexOf(httpRequest.getContextPath()) + httpRequest.getContextPath().length();
            rawODataPath = rawRequestUri.substring(beginIndex);
        } else {
            rawODataPath = httpRequest.getRequestURI();
        }
        if (split > 0) {
            rawServiceResolutionUri = rawODataPath;
            for (int i = 0; i < split; ++i) {
                int index = rawODataPath.indexOf(47, 1);
                if (-1 == index) {
                    rawODataPath = "";
                    break;
                }
                rawODataPath = rawODataPath.substring(index);
            }
            int end = rawServiceResolutionUri.length() - rawODataPath.length();
            rawServiceResolutionUri = rawServiceResolutionUri.substring(0, end);
        }
        String rawBaseUri = rawRequestUri.substring(0, rawRequestUri.length() - rawODataPath.length());
        odRequest.setRawQueryPath(httpRequest.getQueryString());
        odRequest.setRawRequestUri(rawRequestUri + (httpRequest.getQueryString() == null ? "" : "?" + httpRequest.getQueryString()));
        odRequest.setRawODataPath(rawODataPath);
        odRequest.setRawBaseUri(rawBaseUri);
        odRequest.setRawServiceResolutionUri(rawServiceResolutionUri);
    }

    static void copyHeaders(ODataRequest odRequest, HttpServletRequest req) {
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            ArrayList<String> headerValues = Collections.list(req.getHeaders(headerName));
            odRequest.addHeader(headerName, headerValues);
        }
    }

    @Override
    public void register(Processor processor) {
        this.handler.register(processor);
    }

    @Override
    public void register(OlingoExtension extension) {
        this.handler.register(extension);
    }

    @Override
    public void register(CustomContentTypeSupport customContentTypeSupport) {
        this.handler.register(customContentTypeSupport);
    }

    @Override
    public void register(CustomETagSupport customConcurrencyControlSupport) {
        this.handler.register(customConcurrencyControlSupport);
    }

    @Override
    public void register(DebugSupport debugSupport) {
        this.debugger.setDebugSupportProcessor(debugSupport);
    }
}

