/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.olingo.commons.api.data.EntityIterator;
import org.apache.olingo.commons.api.data.EntityMediaObject;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.server.api.ODataContent;
import org.apache.olingo.server.api.ODataContentWriteErrorCallback;
import org.apache.olingo.server.api.ODataContentWriteErrorContext;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.EntityCollectionSerializerOptions;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.serializer.SerializerStreamResult;
import org.apache.olingo.server.core.serializer.FixedFormatSerializerImpl;
import org.apache.olingo.server.core.serializer.SerializerStreamResultImpl;
import org.apache.olingo.server.core.serializer.json.ODataJsonSerializer;
import org.apache.olingo.server.core.serializer.xml.ODataXmlSerializer;

public class ODataWritableContent
implements ODataContent {
    private StreamContent streamContent;

    @Override
    public void write(WritableByteChannel writeChannel) {
        this.streamContent.write(Channels.newOutputStream(writeChannel));
    }

    @Override
    public void write(OutputStream stream) {
        this.write(Channels.newChannel(stream));
    }

    private ODataWritableContent(StreamContent streamContent) {
        this.streamContent = streamContent;
    }

    public static ODataWritableContentBuilder with(EntityIterator iterator, EdmEntityType entityType, ODataSerializer serializer, ServiceMetadata metadata, EntityCollectionSerializerOptions options) {
        return new ODataWritableContentBuilder(iterator, entityType, serializer, metadata, options);
    }

    public static ODataWritableContentBuilder with(EntityMediaObject mediaEntity, FixedFormatSerializerImpl fixedFormatSerializer) {
        return new ODataWritableContentBuilder(mediaEntity, fixedFormatSerializer);
    }

    public static class ODataWritableContentBuilder {
        private ODataSerializer serializer;
        private EntityIterator entities;
        private ServiceMetadata metadata;
        private EdmEntityType entityType;
        private EntityCollectionSerializerOptions options;
        private FixedFormatSerializerImpl fixedFormatSerializer;
        private EntityMediaObject mediaEntity;

        public ODataWritableContentBuilder(EntityIterator entities, EdmEntityType entityType, ODataSerializer serializer, ServiceMetadata metadata, EntityCollectionSerializerOptions options) {
            this.entities = entities;
            this.entityType = entityType;
            this.serializer = serializer;
            this.metadata = metadata;
            this.options = options;
        }

        public ODataWritableContentBuilder(EntityMediaObject mediaEntity, FixedFormatSerializerImpl fixedFormatSerializer) {
            this.mediaEntity = mediaEntity;
            this.fixedFormatSerializer = fixedFormatSerializer;
        }

        public ODataContent buildContent() {
            if (this.serializer instanceof ODataJsonSerializer) {
                StreamContentForJson input = new StreamContentForJson(this.entities, this.entityType, (ODataJsonSerializer)this.serializer, this.metadata, this.options);
                return new ODataWritableContent(input);
            }
            if (this.serializer instanceof ODataXmlSerializer) {
                StreamContentForXml input = new StreamContentForXml(this.entities, this.entityType, (ODataXmlSerializer)this.serializer, this.metadata, this.options);
                return new ODataWritableContent(input);
            }
            if (this.fixedFormatSerializer instanceof FixedFormatSerializerImpl) {
                StreamContentForMedia input = new StreamContentForMedia(this.mediaEntity, this.fixedFormatSerializer);
                return new ODataWritableContent(input);
            }
            throw new ODataRuntimeException("No suitable serializer found");
        }

        public SerializerStreamResult build() {
            return SerializerStreamResultImpl.with().content(this.buildContent()).build();
        }
    }

    public static class WriteErrorContext
    implements ODataContentWriteErrorContext {
        private ODataLibraryException exception;

        public WriteErrorContext(ODataLibraryException exception) {
            this.exception = exception;
        }

        @Override
        public Exception getException() {
            return this.exception;
        }

        @Override
        public ODataLibraryException getODataLibraryException() {
            return this.exception;
        }
    }

    private static class StreamContentForXml
    extends StreamContent {
        private ODataXmlSerializer xmlSerializer;

        public StreamContentForXml(EntityIterator iterator, EdmEntityType entityType, ODataXmlSerializer xmlSerializer, ServiceMetadata metadata, EntityCollectionSerializerOptions options) {
            super(iterator, entityType, metadata, options);
            this.xmlSerializer = xmlSerializer;
        }

        @Override
        protected void writeEntity(EntityIterator entity, OutputStream outputStream) throws SerializerException {
            try {
                this.xmlSerializer.entityCollectionIntoStream(this.metadata, this.entityType, entity, this.options, outputStream);
                outputStream.flush();
            }
            catch (IOException e) {
                throw new ODataRuntimeException("Failed entity serialization", e);
            }
        }

        @Override
        protected void writeBinary(EntityMediaObject mediaEntity, OutputStream outputStream) throws SerializerException {
            throw new ODataRuntimeException("Not Implemented in XML Handling");
        }
    }

    private static class StreamContentForMedia
    extends StreamContent {
        private FixedFormatSerializerImpl fixedFormatSerializer;

        public StreamContentForMedia(EntityMediaObject mediaEntity, FixedFormatSerializerImpl fixedFormatSerializer) {
            super(mediaEntity);
            this.fixedFormatSerializer = fixedFormatSerializer;
        }

        @Override
        protected void writeEntity(EntityIterator entity, OutputStream outputStream) throws SerializerException {
            throw new ODataRuntimeException("Not Implemented in Entity Handling");
        }

        @Override
        protected void writeBinary(EntityMediaObject mediaEntity, OutputStream outputStream) throws SerializerException {
            this.fixedFormatSerializer.binaryIntoStreamed(mediaEntity, outputStream);
        }
    }

    private static class StreamContentForJson
    extends StreamContent {
        private ODataJsonSerializer jsonSerializer;

        public StreamContentForJson(EntityIterator iterator, EdmEntityType entityType, ODataJsonSerializer jsonSerializer, ServiceMetadata metadata, EntityCollectionSerializerOptions options) {
            super(iterator, entityType, metadata, options);
            this.jsonSerializer = jsonSerializer;
        }

        @Override
        protected void writeEntity(EntityIterator entity, OutputStream outputStream) throws SerializerException {
            try {
                this.jsonSerializer.entityCollectionIntoStream(this.metadata, this.entityType, entity, this.options, outputStream);
                outputStream.flush();
            }
            catch (IOException e) {
                throw new ODataRuntimeException("Failed entity serialization", e);
            }
        }

        @Override
        protected void writeBinary(EntityMediaObject mediaEntity, OutputStream outputStream) throws SerializerException {
            throw new ODataRuntimeException("Not Implemented in Entity Handling");
        }
    }

    private static abstract class StreamContent {
        protected EntityIterator iterator;
        protected ServiceMetadata metadata;
        protected EdmEntityType entityType;
        protected EntityCollectionSerializerOptions options;
        protected EntityMediaObject mediaEntity;

        public StreamContent(EntityIterator iterator, EdmEntityType entityType, ServiceMetadata metadata, EntityCollectionSerializerOptions options) {
            this.iterator = iterator;
            this.entityType = entityType;
            this.metadata = metadata;
            this.options = options;
        }

        public StreamContent(EntityMediaObject mediaEntity) {
            this.mediaEntity = mediaEntity;
        }

        protected abstract void writeEntity(EntityIterator var1, OutputStream var2) throws SerializerException;

        protected abstract void writeBinary(EntityMediaObject var1, OutputStream var2) throws SerializerException;

        public void write(OutputStream out) {
            block4: {
                try {
                    if (this.mediaEntity == null) {
                        this.writeEntity(this.iterator, out);
                    } else {
                        this.writeBinary(this.mediaEntity, out);
                    }
                }
                catch (SerializerException e) {
                    ODataContentWriteErrorCallback errorCallback = this.options.getODataContentWriteErrorCallback();
                    if (errorCallback == null) break block4;
                    WriteErrorContext errorContext = new WriteErrorContext(e);
                    errorCallback.handleError(errorContext, Channels.newChannel(out));
                }
            }
        }
    }
}

