/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmElement;
import org.apache.olingo.commons.api.edm.EdmEntitySet;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.EdmSingleton;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceLambdaVariable;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourcePartTyped;
import org.apache.olingo.server.api.uri.queryoption.AliasQueryOption;
import org.apache.olingo.server.api.uri.queryoption.expression.Alias;
import org.apache.olingo.server.api.uri.queryoption.expression.Binary;
import org.apache.olingo.server.api.uri.queryoption.expression.BinaryOperatorKind;
import org.apache.olingo.server.api.uri.queryoption.expression.Enumeration;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.api.uri.queryoption.expression.LambdaRef;
import org.apache.olingo.server.api.uri.queryoption.expression.Literal;
import org.apache.olingo.server.api.uri.queryoption.expression.Member;
import org.apache.olingo.server.api.uri.queryoption.expression.Method;
import org.apache.olingo.server.api.uri.queryoption.expression.MethodKind;
import org.apache.olingo.server.api.uri.queryoption.expression.TypeLiteral;
import org.apache.olingo.server.api.uri.queryoption.expression.Unary;
import org.apache.olingo.server.api.uri.queryoption.expression.UnaryOperatorKind;
import org.apache.olingo.server.core.uri.UriInfoImpl;
import org.apache.olingo.server.core.uri.UriResourceComplexPropertyImpl;
import org.apache.olingo.server.core.uri.UriResourceCountImpl;
import org.apache.olingo.server.core.uri.UriResourceEntitySetImpl;
import org.apache.olingo.server.core.uri.UriResourceFunctionImpl;
import org.apache.olingo.server.core.uri.UriResourceImpl;
import org.apache.olingo.server.core.uri.UriResourceItImpl;
import org.apache.olingo.server.core.uri.UriResourceLambdaAllImpl;
import org.apache.olingo.server.core.uri.UriResourceLambdaAnyImpl;
import org.apache.olingo.server.core.uri.UriResourceLambdaVarImpl;
import org.apache.olingo.server.core.uri.UriResourceNavigationPropertyImpl;
import org.apache.olingo.server.core.uri.UriResourcePrimitivePropertyImpl;
import org.apache.olingo.server.core.uri.UriResourceRootImpl;
import org.apache.olingo.server.core.uri.UriResourceSingletonImpl;
import org.apache.olingo.server.core.uri.UriResourceStartingTypeFilterImpl;
import org.apache.olingo.server.core.uri.UriResourceTypedImpl;
import org.apache.olingo.server.core.uri.UriResourceWithKeysImpl;
import org.apache.olingo.server.core.uri.parser.ParserHelper;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriParserSemanticException;
import org.apache.olingo.server.core.uri.parser.UriParserSyntaxException;
import org.apache.olingo.server.core.uri.parser.UriTokenizer;
import org.apache.olingo.server.core.uri.queryoption.expression.AliasImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.BinaryImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.EnumerationImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.LiteralImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.MemberImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.MethodImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.TypeLiteralImpl;
import org.apache.olingo.server.core.uri.queryoption.expression.UnaryImpl;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public class ExpressionParser {
    private static final Map<UriTokenizer.TokenKind, BinaryOperatorKind> tokenToBinaryOperator;
    private static final Map<UriTokenizer.TokenKind, MethodKind> tokenToMethod;
    private final Edm edm;
    private final OData odata;
    private UriTokenizer tokenizer;
    private Deque<UriResourceLambdaVariable> lambdaVariables = new ArrayDeque<UriResourceLambdaVariable>();
    private EdmType referringType;
    private Collection<String> crossjoinEntitySetNames;
    private Map<String, AliasQueryOption> aliases;

    public ExpressionParser(Edm edm, OData odata) {
        this.edm = edm;
        this.odata = odata;
    }

    public Expression parse(UriTokenizer tokenizer, EdmType referringType, Collection<String> crossjoinEntitySetNames, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        this.tokenizer = tokenizer;
        this.referringType = referringType;
        this.crossjoinEntitySetNames = crossjoinEntitySetNames;
        this.aliases = aliases;
        Expression expression = this.parseExpression();
        this.checkNoCollection(expression);
        return expression;
    }

    private Expression parseExpression() throws UriParserException, UriValidationException {
        Expression left = this.parseAnd();
        while (this.tokenizer.next(UriTokenizer.TokenKind.OrOperator)) {
            this.checkType(left, EdmPrimitiveTypeKind.Boolean);
            this.checkNoCollection(left);
            Expression right = this.parseAnd();
            this.checkType(right, EdmPrimitiveTypeKind.Boolean);
            this.checkNoCollection(right);
            left = new BinaryImpl(left, BinaryOperatorKind.OR, right, (EdmType)this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Boolean));
        }
        return left;
    }

    private Expression parseAnd() throws UriParserException, UriValidationException {
        Expression left = this.parseExprEquality();
        while (this.tokenizer.next(UriTokenizer.TokenKind.AndOperator)) {
            this.checkType(left, EdmPrimitiveTypeKind.Boolean);
            this.checkNoCollection(left);
            Expression right = this.parseExprEquality();
            this.checkType(right, EdmPrimitiveTypeKind.Boolean);
            this.checkNoCollection(right);
            left = new BinaryImpl(left, BinaryOperatorKind.AND, right, (EdmType)this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Boolean));
        }
        return left;
    }

    private Expression parseExprEquality() throws UriParserException, UriValidationException {
        Expression left = this.parseExprRel();
        UriTokenizer.TokenKind operatorTokenKind = ParserHelper.next(this.tokenizer, UriTokenizer.TokenKind.EqualsOperator, UriTokenizer.TokenKind.NotEqualsOperator);
        while (operatorTokenKind != null) {
            Expression right = this.parseExprEquality();
            this.checkEqualityTypes(left, right);
            left = new BinaryImpl(left, tokenToBinaryOperator.get((Object)operatorTokenKind), right, (EdmType)this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Boolean));
            operatorTokenKind = ParserHelper.next(this.tokenizer, UriTokenizer.TokenKind.EqualsOperator, UriTokenizer.TokenKind.NotEqualsOperator);
        }
        return left;
    }

    private Expression parseExprRel() throws UriParserException, UriValidationException {
        if (this.tokenizer.next(UriTokenizer.TokenKind.IsofMethod)) {
            return this.parseIsOfOrCastMethod(MethodKind.ISOF);
        }
        Expression left = this.parseExprAdd();
        UriTokenizer.TokenKind operatorTokenKind = ParserHelper.next(this.tokenizer, UriTokenizer.TokenKind.GreaterThanOperator, UriTokenizer.TokenKind.GreaterThanOrEqualsOperator, UriTokenizer.TokenKind.LessThanOperator, UriTokenizer.TokenKind.LessThanOrEqualsOperator);
        while (operatorTokenKind != null) {
            Expression right = this.parseExprAdd();
            this.checkRelationTypes(left, right);
            left = new BinaryImpl(left, tokenToBinaryOperator.get((Object)operatorTokenKind), right, (EdmType)this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Boolean));
            operatorTokenKind = ParserHelper.next(this.tokenizer, UriTokenizer.TokenKind.GreaterThanOperator, UriTokenizer.TokenKind.GreaterThanOrEqualsOperator, UriTokenizer.TokenKind.LessThanOperator, UriTokenizer.TokenKind.LessThanOrEqualsOperator);
        }
        return left;
    }

    private Expression parseIsOfOrCastMethod(MethodKind kind) throws UriParserException, UriValidationException {
        ArrayList<Expression> parameters = new ArrayList<Expression>();
        ParserHelper.bws(this.tokenizer);
        parameters.add(this.parseExpression());
        if (!(parameters.get(0) instanceof TypeLiteral)) {
            ParserHelper.bws(this.tokenizer);
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.COMMA);
            ParserHelper.bws(this.tokenizer);
            parameters.add(this.parseExpression());
            ParserHelper.bws(this.tokenizer);
            if (!(parameters.get(1) instanceof TypeLiteral)) {
                throw new UriParserSemanticException("Type literal expected.", UriParserSemanticException.MessageKeys.INCOMPATIBLE_TYPE_FILTER, new String[0]);
            }
        }
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
        return new MethodImpl(kind, parameters);
    }

    private Expression parseExprAdd() throws UriParserException, UriValidationException {
        Expression left = this.parseExprMul();
        UriTokenizer.TokenKind operatorTokenKind = ParserHelper.next(this.tokenizer, UriTokenizer.TokenKind.AddOperator, UriTokenizer.TokenKind.SubOperator);
        while (operatorTokenKind != null) {
            Expression right = this.parseExprMul();
            EdmType resultType = this.getAddSubTypeAndCheckLeftAndRight(left, right, operatorTokenKind == UriTokenizer.TokenKind.SubOperator);
            left = new BinaryImpl(left, tokenToBinaryOperator.get((Object)operatorTokenKind), right, resultType);
            operatorTokenKind = ParserHelper.next(this.tokenizer, UriTokenizer.TokenKind.AddOperator, UriTokenizer.TokenKind.SubOperator);
        }
        return left;
    }

    private Expression parseExprMul() throws UriParserException, UriValidationException {
        Expression left = this.parseExprUnary();
        UriTokenizer.TokenKind operatorTokenKind = ParserHelper.next(this.tokenizer, UriTokenizer.TokenKind.MulOperator, UriTokenizer.TokenKind.DivOperator, UriTokenizer.TokenKind.ModOperator);
        while (operatorTokenKind != null) {
            this.checkNumericType(left);
            Expression right = this.parseExprUnary();
            this.checkNumericType(right);
            left = new BinaryImpl(left, tokenToBinaryOperator.get((Object)operatorTokenKind), right, (EdmType)this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Double));
            operatorTokenKind = ParserHelper.next(this.tokenizer, UriTokenizer.TokenKind.MulOperator, UriTokenizer.TokenKind.DivOperator, UriTokenizer.TokenKind.ModOperator);
        }
        return left;
    }

    private Expression parseExprUnary() throws UriParserException, UriValidationException {
        if (this.tokenizer.next(UriTokenizer.TokenKind.MinusOperator)) {
            Expression expression = this.parseExprPrimary();
            if (!this.isType(ExpressionParser.getType(expression), EdmPrimitiveTypeKind.Duration)) {
                this.checkNumericType(expression);
            }
            return new UnaryImpl(UnaryOperatorKind.MINUS, expression, ExpressionParser.getType(expression));
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.NotOperator)) {
            Expression expression = this.parseExprValue();
            this.checkType(expression, EdmPrimitiveTypeKind.Boolean);
            this.checkNoCollection(expression);
            return new UnaryImpl(UnaryOperatorKind.NOT, expression, ExpressionParser.getType(expression));
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.CastMethod)) {
            return this.parseIsOfOrCastMethod(MethodKind.CAST);
        }
        return this.parseExprPrimary();
    }

    private Expression parseExprPrimary() throws UriParserException, UriValidationException {
        Expression left = this.parseExprValue();
        if (this.isEnumType(left) && this.tokenizer.next(UriTokenizer.TokenKind.HasOperator)) {
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.EnumValue);
            Enumeration right = this.createEnumExpression(this.tokenizer.getText());
            return new BinaryImpl(left, BinaryOperatorKind.HAS, right, (EdmType)this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Boolean));
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.InOperator)) {
            EdmType leftExprType = ExpressionParser.getType(left);
            EdmPrimitiveTypeKind kinds = EdmPrimitiveTypeKind.valueOfFQN(leftExprType.getFullQualifiedName());
            if (this.tokenizer.next(UriTokenizer.TokenKind.OPEN)) {
                ParserHelper.bws(this.tokenizer);
                List<Expression> expressionList = this.parseInExpr();
                this.checkInExpressionTypes(expressionList, leftExprType);
                return new BinaryImpl(left, BinaryOperatorKind.IN, expressionList, (EdmType)this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Boolean));
            }
            ParserHelper.bws(this.tokenizer);
            Expression right = this.parseExpression();
            this.checkType(right, kinds);
            return new BinaryImpl(left, BinaryOperatorKind.IN, right, (EdmType)this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Boolean));
        }
        return left;
    }

    private void checkInExpressionTypes(List<Expression> expressionList, EdmType leftExprType) throws UriParserException, UriParserSemanticException {
        for (Expression expr : expressionList) {
            EdmType inExprType = ExpressionParser.getType(expr);
            if (((EdmPrimitiveType)leftExprType).isCompatible((EdmPrimitiveType)inExprType)) continue;
            throw new UriParserSemanticException("Incompatible types.", UriParserSemanticException.MessageKeys.TYPES_NOT_COMPATIBLE, inExprType == null ? "" : inExprType.getFullQualifiedName().getFullQualifiedNameAsString(), leftExprType.getFullQualifiedName().getFullQualifiedNameAsString());
        }
    }

    private List<Expression> parseInExpr() throws UriParserException, UriValidationException {
        ArrayList<Expression> expressionList = new ArrayList<Expression>();
        while (!this.tokenizer.next(UriTokenizer.TokenKind.CLOSE)) {
            Expression expression = this.parseExpression();
            expressionList.add(expression);
            ParserHelper.bws(this.tokenizer);
            while (this.tokenizer.next(UriTokenizer.TokenKind.COMMA)) {
                ParserHelper.bws(this.tokenizer);
                expression = this.parseExpression();
                expressionList.add(expression);
                ParserHelper.bws(this.tokenizer);
            }
        }
        return expressionList;
    }

    private Expression parseExprValue() throws UriParserException, UriValidationException {
        if (this.tokenizer.next(UriTokenizer.TokenKind.OPEN)) {
            ParserHelper.bws(this.tokenizer);
            Expression expression = this.parseExpression();
            ParserHelper.bws(this.tokenizer);
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
            return expression;
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.ParameterAliasName)) {
            String name = this.tokenizer.getText();
            if (this.aliases.containsKey(name)) {
                return new AliasImpl(name, ParserHelper.parseAliasValue(name, null, true, true, this.edm, this.referringType, this.aliases));
            }
            return new AliasImpl(name, null);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.jsonArrayOrObject)) {
            return new LiteralImpl(this.tokenizer.getText(), null);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.ROOT)) {
            return this.parseFirstMemberExpr(UriTokenizer.TokenKind.ROOT);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.IT)) {
            return this.parseFirstMemberExpr(UriTokenizer.TokenKind.IT);
        }
        UriTokenizer.TokenKind nextPrimitive = ParserHelper.nextPrimitiveValue(this.tokenizer);
        if (nextPrimitive != null) {
            return this.parsePrimitive(nextPrimitive);
        }
        UriTokenizer.TokenKind nextMethod = ParserHelper.next(this.tokenizer, tokenToMethod.keySet().toArray(new UriTokenizer.TokenKind[tokenToMethod.size()]));
        if (nextMethod != null) {
            return this.parseMethod(nextMethod);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.QualifiedName)) {
            return this.parseFirstMemberExpr(UriTokenizer.TokenKind.QualifiedName);
        }
        if (this.tokenizer.next(UriTokenizer.TokenKind.ODataIdentifier)) {
            return this.parseFirstMemberExpr(UriTokenizer.TokenKind.ODataIdentifier);
        }
        throw new UriParserSyntaxException("Unexpected token.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
    }

    private Expression parseMethod(UriTokenizer.TokenKind nextMethod) throws UriParserException, UriValidationException {
        MethodKind methodKind = tokenToMethod.get((Object)nextMethod);
        return new MethodImpl(methodKind, this.parseMethodParameters(methodKind));
    }

    private Expression parsePrimitive(UriTokenizer.TokenKind primitiveTokenKind) throws UriParserException {
        String primitiveValueLiteral = this.tokenizer.getText();
        if (primitiveTokenKind == UriTokenizer.TokenKind.EnumValue) {
            return this.createEnumExpression(primitiveValueLiteral);
        }
        EdmPrimitiveTypeKind primitiveTypeKind = ParserHelper.tokenToPrimitiveType.get((Object)primitiveTokenKind);
        if (primitiveTypeKind == EdmPrimitiveTypeKind.Int64) {
            primitiveTypeKind = this.determineIntegerType(primitiveValueLiteral);
        }
        EdmPrimitiveType type = primitiveTypeKind == null ? null : this.odata.createPrimitiveTypeInstance(primitiveTypeKind);
        return new LiteralImpl(primitiveValueLiteral, type);
    }

    private EdmPrimitiveTypeKind determineIntegerType(String intValueAsString) throws UriParserSyntaxException {
        EdmPrimitiveTypeKind typeKind = null;
        try {
            long value = Long.parseLong(intValueAsString);
            typeKind = value >= -128L && value <= 127L ? EdmPrimitiveTypeKind.SByte : (value >= 0L && value <= 255L ? EdmPrimitiveTypeKind.Byte : (value >= -32768L && value <= 32767L ? EdmPrimitiveTypeKind.Int16 : (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE ? EdmPrimitiveTypeKind.Int32 : EdmPrimitiveTypeKind.Int64)));
        }
        catch (NumberFormatException e) {
            typeKind = EdmPrimitiveTypeKind.Decimal;
        }
        return typeKind;
    }

    private List<Expression> parseMethodParameters(MethodKind methodKind) throws UriParserException, UriValidationException {
        ArrayList<Expression> parameters = new ArrayList<Expression>();
        switch (methodKind) {
            case NOW: 
            case MAXDATETIME: 
            case MINDATETIME: {
                ParserHelper.bws(this.tokenizer);
                break;
            }
            case LENGTH: 
            case TOLOWER: 
            case TOUPPER: 
            case TRIM: {
                ParserHelper.bws(this.tokenizer);
                Expression stringParameter = this.parseExpression();
                ParserHelper.bws(this.tokenizer);
                this.checkType(stringParameter, EdmPrimitiveTypeKind.String);
                this.checkNoCollection(stringParameter);
                parameters.add(stringParameter);
                break;
            }
            case YEAR: 
            case MONTH: 
            case DAY: {
                ParserHelper.bws(this.tokenizer);
                Expression dateParameter = this.parseExpression();
                ParserHelper.bws(this.tokenizer);
                this.checkType(dateParameter, EdmPrimitiveTypeKind.Date, EdmPrimitiveTypeKind.DateTimeOffset);
                this.checkNoCollection(dateParameter);
                parameters.add(dateParameter);
                break;
            }
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case FRACTIONALSECONDS: {
                ParserHelper.bws(this.tokenizer);
                Expression timeParameter = this.parseExpression();
                ParserHelper.bws(this.tokenizer);
                this.checkType(timeParameter, EdmPrimitiveTypeKind.TimeOfDay, EdmPrimitiveTypeKind.DateTimeOffset);
                this.checkNoCollection(timeParameter);
                parameters.add(timeParameter);
                break;
            }
            case DATE: 
            case TIME: 
            case TOTALOFFSETMINUTES: {
                ParserHelper.bws(this.tokenizer);
                Expression dateTimeParameter = this.parseExpression();
                ParserHelper.bws(this.tokenizer);
                this.checkType(dateTimeParameter, EdmPrimitiveTypeKind.DateTimeOffset);
                this.checkNoCollection(dateTimeParameter);
                parameters.add(dateTimeParameter);
                break;
            }
            case TOTALSECONDS: {
                ParserHelper.bws(this.tokenizer);
                Expression durationParameter = this.parseExpression();
                ParserHelper.bws(this.tokenizer);
                this.checkType(durationParameter, EdmPrimitiveTypeKind.Duration);
                this.checkNoCollection(durationParameter);
                parameters.add(durationParameter);
                break;
            }
            case ROUND: 
            case FLOOR: 
            case CEILING: {
                ParserHelper.bws(this.tokenizer);
                Expression decimalParameter = this.parseExpression();
                ParserHelper.bws(this.tokenizer);
                this.checkType(decimalParameter, EdmPrimitiveTypeKind.Decimal, EdmPrimitiveTypeKind.Single, EdmPrimitiveTypeKind.Double);
                this.checkNoCollection(decimalParameter);
                parameters.add(decimalParameter);
                break;
            }
            case GEOLENGTH: {
                ParserHelper.bws(this.tokenizer);
                Expression geoParameter = this.parseExpression();
                ParserHelper.bws(this.tokenizer);
                this.checkType(geoParameter, EdmPrimitiveTypeKind.GeographyLineString, EdmPrimitiveTypeKind.GeometryLineString);
                this.checkNoCollection(geoParameter);
                parameters.add(geoParameter);
                break;
            }
            case CONTAINS: 
            case ENDSWITH: 
            case STARTSWITH: 
            case INDEXOF: 
            case CONCAT: 
            case SUBSTRINGOF: {
                ParserHelper.bws(this.tokenizer);
                Expression stringParameter1 = this.parseExpression();
                this.checkType(stringParameter1, EdmPrimitiveTypeKind.String);
                this.checkNoCollection(stringParameter1);
                parameters.add(stringParameter1);
                ParserHelper.bws(this.tokenizer);
                ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.COMMA);
                ParserHelper.bws(this.tokenizer);
                Expression stringParameter2 = this.parseExpression();
                ParserHelper.bws(this.tokenizer);
                this.checkType(stringParameter2, EdmPrimitiveTypeKind.String);
                this.checkNoCollection(stringParameter2);
                parameters.add(stringParameter2);
                break;
            }
            case GEODISTANCE: {
                ParserHelper.bws(this.tokenizer);
                Expression geoParameter1 = this.parseExpression();
                this.checkType(geoParameter1, EdmPrimitiveTypeKind.GeographyPoint, EdmPrimitiveTypeKind.GeometryPoint);
                this.checkNoCollection(geoParameter1);
                parameters.add(geoParameter1);
                ParserHelper.bws(this.tokenizer);
                ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.COMMA);
                ParserHelper.bws(this.tokenizer);
                Expression geoParameter2 = this.parseExpression();
                ParserHelper.bws(this.tokenizer);
                this.checkType(geoParameter2, EdmPrimitiveTypeKind.GeographyPoint, EdmPrimitiveTypeKind.GeometryPoint);
                this.checkNoCollection(geoParameter2);
                parameters.add(geoParameter2);
                break;
            }
            case GEOINTERSECTS: {
                ParserHelper.bws(this.tokenizer);
                Expression geoPointParameter = this.parseExpression();
                this.checkType(geoPointParameter, EdmPrimitiveTypeKind.GeographyPoint, EdmPrimitiveTypeKind.GeometryPoint);
                this.checkNoCollection(geoPointParameter);
                parameters.add(geoPointParameter);
                ParserHelper.bws(this.tokenizer);
                ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.COMMA);
                ParserHelper.bws(this.tokenizer);
                Expression geoPolygonParameter = this.parseExpression();
                ParserHelper.bws(this.tokenizer);
                this.checkType(geoPolygonParameter, EdmPrimitiveTypeKind.GeographyPolygon, EdmPrimitiveTypeKind.GeometryPolygon);
                this.checkNoCollection(geoPolygonParameter);
                parameters.add(geoPolygonParameter);
                break;
            }
            case SUBSTRING: {
                ParserHelper.bws(this.tokenizer);
                Expression parameterFirst = this.parseExpression();
                this.checkType(parameterFirst, EdmPrimitiveTypeKind.String);
                this.checkNoCollection(parameterFirst);
                parameters.add(parameterFirst);
                ParserHelper.bws(this.tokenizer);
                ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.COMMA);
                ParserHelper.bws(this.tokenizer);
                Expression parameterSecond = this.parseExpression();
                ParserHelper.bws(this.tokenizer);
                this.checkIntegerType(parameterSecond);
                parameters.add(parameterSecond);
                ParserHelper.bws(this.tokenizer);
                if (!this.tokenizer.next(UriTokenizer.TokenKind.COMMA)) break;
                ParserHelper.bws(this.tokenizer);
                Expression parameterThird = this.parseExpression();
                ParserHelper.bws(this.tokenizer);
                this.checkIntegerType(parameterThird);
                parameters.add(parameterThird);
                break;
            }
        }
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
        return parameters;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Expression parseFirstMemberExpr(UriTokenizer.TokenKind lastTokenKind) throws UriParserException, UriValidationException {
        void var3_5;
        UriInfoImpl uriInfo = new UriInfoImpl();
        Object var3_3 = null;
        if (lastTokenKind == UriTokenizer.TokenKind.ROOT) {
            this.parseDollarRoot(uriInfo);
            return new MemberImpl(uriInfo, (EdmType)var3_5);
        } else if (lastTokenKind == UriTokenizer.TokenKind.IT) {
            this.parseDollarIt(uriInfo, this.referringType);
            return new MemberImpl(uriInfo, (EdmType)var3_5);
        } else if (lastTokenKind == UriTokenizer.TokenKind.QualifiedName) {
            void var5_15;
            void var5_13;
            void var5_11;
            void var5_9;
            FullQualifiedName fullQualifiedName = new FullQualifiedName(this.tokenizer.getText());
            EdmEntityType edmEntityType = this.edm.getEntityType(fullQualifiedName);
            if (edmEntityType == null) {
                EdmComplexType edmComplexType = this.edm.getComplexType(fullQualifiedName);
            }
            if (var5_9 == null) {
                EdmType edmType = this.getPrimitiveType(fullQualifiedName);
            }
            if (var5_11 == null) {
                EdmEnumType edmEnumType = this.edm.getEnumType(fullQualifiedName);
            }
            if (var5_13 == null) {
                EdmTypeDefinition edmTypeDefinition = this.edm.getTypeDefinition(fullQualifiedName);
            }
            if (var5_15 != null) {
                if (!this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) return new TypeLiteralImpl((EdmType)var5_15);
                this.checkStructuredTypeFilter(this.referringType, (EdmType)var5_15);
                void var3_4 = var5_15;
                UriTokenizer.TokenKind tokenKind = ParserHelper.next(this.tokenizer, UriTokenizer.TokenKind.QualifiedName, UriTokenizer.TokenKind.ODataIdentifier);
                this.parseMemberExpression(tokenKind, uriInfo, new UriResourceStartingTypeFilterImpl((EdmType)var5_15, false), false);
                return new MemberImpl(uriInfo, (EdmType)var3_5);
            } else {
                this.parseFunction(fullQualifiedName, uriInfo, this.referringType, true);
            }
            return new MemberImpl(uriInfo, (EdmType)var3_5);
        } else {
            if (lastTokenKind != UriTokenizer.TokenKind.ODataIdentifier) return new MemberImpl(uriInfo, (EdmType)var3_5);
            this.parseFirstMemberODataIdentifier(uriInfo);
        }
        return new MemberImpl(uriInfo, (EdmType)var3_5);
    }

    private EdmType getPrimitiveType(FullQualifiedName fullQualifiedName) {
        if ("Edm".equals(fullQualifiedName.getNamespace())) {
            EdmPrimitiveTypeKind primitiveTypeKind = EdmPrimitiveTypeKind.valueOf(fullQualifiedName.getName());
            return primitiveTypeKind == null ? null : this.odata.createPrimitiveTypeInstance(primitiveTypeKind);
        }
        return null;
    }

    private void parseDollarRoot(UriInfoImpl uriInfo) throws UriParserException, UriValidationException {
        UriResourceRootImpl rootResource = new UriResourceRootImpl(this.referringType, true);
        uriInfo.addResourcePart(rootResource);
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.SLASH);
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.ODataIdentifier);
        String name = this.tokenizer.getText();
        UriResourceImpl resource = null;
        EdmEntitySet entitySet = this.edm.getEntityContainer().getEntitySet(name);
        if (entitySet == null) {
            EdmSingleton singleton = this.edm.getEntityContainer().getSingleton(name);
            if (singleton == null) {
                throw new UriParserSemanticException("EntitySet or singleton expected.", UriParserSemanticException.MessageKeys.UNKNOWN_PART, name);
            }
            resource = new UriResourceSingletonImpl(singleton);
        } else {
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.OPEN);
            List<UriParameter> keyPredicates = ParserHelper.parseKeyPredicate(this.tokenizer, entitySet.getEntityType(), null, this.edm, this.referringType, this.aliases);
            resource = new UriResourceEntitySetImpl(entitySet).setKeyPredicates(keyPredicates);
        }
        uriInfo.addResourcePart(resource);
        this.parseSingleNavigationExpr(uriInfo, (UriResourcePartTyped)((Object)resource));
    }

    private void parseDollarIt(UriInfoImpl uriInfo, EdmType referringType) throws UriParserException, UriValidationException {
        UriResourceItImpl itResource = new UriResourceItImpl(referringType, false);
        uriInfo.addResourcePart(itResource);
        if (this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
            UriTokenizer.TokenKind tokenKind = ParserHelper.next(this.tokenizer, UriTokenizer.TokenKind.QualifiedName, UriTokenizer.TokenKind.ODataIdentifier);
            this.parseMemberExpression(tokenKind, uriInfo, itResource, true);
        }
    }

    private void parseFirstMemberODataIdentifier(UriInfoImpl uriInfo) throws UriParserException, UriValidationException {
        String name = this.tokenizer.getText();
        if (this.crossjoinEntitySetNames != null && !this.crossjoinEntitySetNames.isEmpty()) {
            if (this.crossjoinEntitySetNames.contains(name)) {
                UriResourceEntitySetImpl resource = new UriResourceEntitySetImpl(this.edm.getEntityContainer().getEntitySet(name));
                uriInfo.addResourcePart(resource);
                if (this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
                    UriTokenizer.TokenKind tokenKind = ParserHelper.next(this.tokenizer, UriTokenizer.TokenKind.QualifiedName, UriTokenizer.TokenKind.ODataIdentifier);
                    this.parseMemberExpression(tokenKind, uriInfo, resource, true);
                }
                return;
            }
            throw new UriParserSemanticException("Unknown crossjoin entity set.", UriParserSemanticException.MessageKeys.UNKNOWN_PART, name);
        }
        UriResourceLambdaVariable lambdaVariable = null;
        for (UriResourceLambdaVariable variable : this.lambdaVariables) {
            if (!variable.getVariableName().equals(name)) continue;
            lambdaVariable = variable;
            break;
        }
        if (lambdaVariable != null) {
            UriResourceLambdaVarImpl lambdaResource = new UriResourceLambdaVarImpl(lambdaVariable.getVariableName(), lambdaVariable.getType());
            uriInfo.addResourcePart(lambdaResource);
            if (this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
                UriTokenizer.TokenKind tokenKind = ParserHelper.next(this.tokenizer, UriTokenizer.TokenKind.QualifiedName, UriTokenizer.TokenKind.ODataIdentifier);
                this.parseMemberExpression(tokenKind, uriInfo, lambdaResource, true);
            }
        } else {
            this.parseMemberExpression(UriTokenizer.TokenKind.ODataIdentifier, uriInfo, null, true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseMemberExpression(UriTokenizer.TokenKind lastTokenKind, UriInfoImpl uriInfo, UriResourcePartTyped lastResource, boolean allowTypeFilter) throws UriParserException, UriValidationException {
        if (lastTokenKind == UriTokenizer.TokenKind.QualifiedName) {
            FullQualifiedName fullQualifiedName = new FullQualifiedName(this.tokenizer.getText());
            EdmEntityType edmEntityType = this.edm.getEntityType(fullQualifiedName);
            if (edmEntityType != null) {
                if (!allowTypeFilter) throw new UriParserSemanticException("Type filters are not chainable.", UriParserSemanticException.MessageKeys.TYPE_FILTER_NOT_CHAINABLE, lastResource.getType().getFullQualifiedName().getFullQualifiedNameAsString(), fullQualifiedName.getFullQualifiedNameAsString());
                this.setTypeFilter(lastResource, edmEntityType);
                if (!this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) return;
                if (this.tokenizer.next(UriTokenizer.TokenKind.QualifiedName)) {
                    this.parseBoundFunction(fullQualifiedName, uriInfo, lastResource);
                    return;
                } else {
                    if (!this.tokenizer.next(UriTokenizer.TokenKind.ODataIdentifier)) throw new UriParserSyntaxException("Expected OData Identifier or Full Qualified Name.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
                    this.parsePropertyPathExpr(uriInfo, lastResource);
                }
                return;
            } else if (this.edm.getComplexType(fullQualifiedName) != null) {
                if (!allowTypeFilter) throw new UriParserSemanticException("Type filters are not chainable.", UriParserSemanticException.MessageKeys.TYPE_FILTER_NOT_CHAINABLE, lastResource.getType().getFullQualifiedName().getFullQualifiedNameAsString(), fullQualifiedName.getFullQualifiedNameAsString());
                this.setTypeFilter(lastResource, this.edm.getComplexType(fullQualifiedName));
                if (!this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) return;
                if (this.tokenizer.next(UriTokenizer.TokenKind.QualifiedName)) {
                    this.parseBoundFunction(fullQualifiedName, uriInfo, lastResource);
                    return;
                } else {
                    if (!this.tokenizer.next(UriTokenizer.TokenKind.ODataIdentifier)) throw new UriParserSyntaxException("Expected OData Identifier or Full Qualified Name.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
                    this.parsePropertyPathExpr(uriInfo, lastResource);
                }
                return;
            } else {
                this.parseBoundFunction(fullQualifiedName, uriInfo, lastResource);
            }
            return;
        } else {
            if (lastTokenKind != UriTokenizer.TokenKind.ODataIdentifier) throw new UriParserSyntaxException("Unexpected token.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
            this.parsePropertyPathExpr(uriInfo, lastResource);
        }
    }

    private void setTypeFilter(UriResourcePartTyped lastResource, EdmStructuredType entityTypeFilter) throws UriParserException {
        this.checkStructuredTypeFilter(lastResource.getType(), entityTypeFilter);
        if (lastResource instanceof UriResourceTypedImpl) {
            ((UriResourceTypedImpl)lastResource).setTypeFilter(entityTypeFilter);
        } else if (lastResource instanceof UriResourceWithKeysImpl) {
            ((UriResourceWithKeysImpl)lastResource).setEntryTypeFilter(entityTypeFilter);
        }
    }

    private void parsePropertyPathExpr(UriInfoImpl uriInfo, UriResourcePartTyped lastResource) throws UriParserException, UriValidationException {
        EdmType lastType;
        String oDataIdentifier = this.tokenizer.getText();
        EdmType edmType = lastType = lastResource == null ? this.referringType : ParserHelper.getTypeInformation(lastResource);
        if (!(lastType instanceof EdmStructuredType)) {
            throw new UriParserSemanticException("Property paths must follow a structured type.", UriParserSemanticException.MessageKeys.ONLY_FOR_STRUCTURAL_TYPES, oDataIdentifier);
        }
        EdmStructuredType structuredType = (EdmStructuredType)lastType;
        EdmElement property = structuredType.getProperty(oDataIdentifier);
        if (property == null) {
            throw new UriParserSemanticException("Unknown property.", UriParserSemanticException.MessageKeys.EXPRESSION_PROPERTY_NOT_IN_TYPE, lastType.getFullQualifiedName().getFullQualifiedNameAsString(), oDataIdentifier);
        }
        if (property.getType() instanceof EdmComplexType) {
            UriResourceComplexPropertyImpl complexResource = new UriResourceComplexPropertyImpl((EdmProperty)property);
            uriInfo.addResourcePart(complexResource);
            if (property.isCollection()) {
                if (this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
                    this.parseCollectionPathExpr(uriInfo, complexResource);
                }
            } else {
                this.parseComplexPathExpr(uriInfo, complexResource);
            }
        } else if (property instanceof EdmNavigationProperty) {
            UriResourceNavigationPropertyImpl navigationResource = new UriResourceNavigationPropertyImpl((EdmNavigationProperty)property);
            navigationResource.setKeyPredicates(ParserHelper.parseNavigationKeyPredicate(this.tokenizer, (EdmNavigationProperty)property, this.edm, this.referringType, this.aliases));
            uriInfo.addResourcePart(navigationResource);
            if (navigationResource.isCollection()) {
                this.parseCollectionNavigationExpr(uriInfo, navigationResource);
            } else {
                this.parseSingleNavigationExpr(uriInfo, navigationResource);
            }
        } else {
            UriResourcePrimitivePropertyImpl primitiveResource = new UriResourcePrimitivePropertyImpl((EdmProperty)property);
            uriInfo.addResourcePart(primitiveResource);
            if (property.isCollection()) {
                if (this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
                    this.parseCollectionPathExpr(uriInfo, primitiveResource);
                }
            } else {
                this.parseSinglePathExpr(uriInfo, primitiveResource);
            }
        }
    }

    private void parseSingleNavigationExpr(UriInfoImpl uriInfo, UriResourcePartTyped lastResource) throws UriParserException, UriValidationException {
        if (this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
            UriTokenizer.TokenKind tokenKind = ParserHelper.next(this.tokenizer, UriTokenizer.TokenKind.QualifiedName, UriTokenizer.TokenKind.ODataIdentifier);
            this.parseMemberExpression(tokenKind, uriInfo, lastResource, true);
        }
    }

    private void parseCollectionNavigationExpr(UriInfoImpl uriInfo, UriResourcePartTyped lastResource) throws UriParserException, UriValidationException {
        boolean hasSlash = false;
        if (this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
            hasSlash = true;
            if (this.tokenizer.next(UriTokenizer.TokenKind.QualifiedName)) {
                FullQualifiedName qualifiedName = new FullQualifiedName(this.tokenizer.getText());
                EdmEntityType edmEntityType = this.edm.getEntityType(qualifiedName);
                if (edmEntityType == null) {
                    this.parseBoundFunction(qualifiedName, uriInfo, lastResource);
                } else {
                    this.setTypeFilter(lastResource, edmEntityType);
                }
                hasSlash = false;
            }
        }
        if (!hasSlash && this.tokenizer.next(UriTokenizer.TokenKind.OPEN)) {
            if (lastResource instanceof UriResourceNavigation) {
                ((UriResourceNavigationPropertyImpl)lastResource).setKeyPredicates(ParserHelper.parseNavigationKeyPredicate(this.tokenizer, ((UriResourceNavigationPropertyImpl)lastResource).getProperty(), this.edm, this.referringType, this.aliases));
            } else if (lastResource instanceof UriResourceFunction && ((UriResourceFunction)lastResource).getType() instanceof EdmEntityType) {
                ((UriResourceFunctionImpl)lastResource).setKeyPredicates(ParserHelper.parseKeyPredicate(this.tokenizer, (EdmEntityType)((UriResourceFunction)lastResource).getType(), null, this.edm, this.referringType, this.aliases));
            } else {
                throw new UriParserSemanticException("Unknown or wrong resource type.", UriParserSemanticException.MessageKeys.NOT_IMPLEMENTED, lastResource.toString());
            }
            this.parseSingleNavigationExpr(uriInfo, lastResource);
        }
        if (hasSlash || this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
            this.parseCollectionPathExpr(uriInfo, lastResource);
        }
    }

    private void parseSinglePathExpr(UriInfoImpl uriInfo, UriResourcePartTyped lastResource) throws UriParserException, UriValidationException {
        if (this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
            ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.QualifiedName);
            this.parseBoundFunction(new FullQualifiedName(this.tokenizer.getText()), uriInfo, lastResource);
        }
    }

    private void parseComplexPathExpr(UriInfoImpl uriInfo, UriResourcePartTyped lastResource) throws UriParserException, UriValidationException {
        if (this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
            if (this.tokenizer.next(UriTokenizer.TokenKind.QualifiedName)) {
                FullQualifiedName fullQualifiedName = new FullQualifiedName(this.tokenizer.getText());
                EdmComplexType edmComplexType = this.edm.getComplexType(fullQualifiedName);
                if (edmComplexType != null) {
                    this.setTypeFilter(lastResource, edmComplexType);
                    if (this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
                        this.parseComplexPathRestExpr(uriInfo, lastResource);
                    }
                } else {
                    this.parseBoundFunction(fullQualifiedName, uriInfo, lastResource);
                }
            } else {
                this.parseComplexPathRestExpr(uriInfo, lastResource);
            }
        }
    }

    private void parseComplexPathRestExpr(UriInfoImpl uriInfo, UriResourcePartTyped lastResource) throws UriParserException, UriValidationException {
        if (this.tokenizer.next(UriTokenizer.TokenKind.QualifiedName)) {
            FullQualifiedName fullQualifiedName = new FullQualifiedName(this.tokenizer.getText());
            this.parseBoundFunction(fullQualifiedName, uriInfo, lastResource);
        } else if (this.tokenizer.next(UriTokenizer.TokenKind.ODataIdentifier)) {
            this.parsePropertyPathExpr(uriInfo, lastResource);
        } else {
            throw new UriParserSyntaxException("Unexpected token.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
        }
    }

    private void parseCollectionPathExpr(UriInfoImpl uriInfo, UriResourcePartTyped lastResource) throws UriParserException, UriValidationException {
        if (this.tokenizer.next(UriTokenizer.TokenKind.COUNT)) {
            uriInfo.addResourcePart(new UriResourceCountImpl());
        } else if (this.tokenizer.next(UriTokenizer.TokenKind.ANY)) {
            uriInfo.addResourcePart(this.parseLambdaRest(UriTokenizer.TokenKind.ANY, lastResource));
        } else if (this.tokenizer.next(UriTokenizer.TokenKind.ALL)) {
            uriInfo.addResourcePart(this.parseLambdaRest(UriTokenizer.TokenKind.ALL, lastResource));
        } else if (this.tokenizer.next(UriTokenizer.TokenKind.QualifiedName)) {
            this.parseBoundFunction(new FullQualifiedName(this.tokenizer.getText()), uriInfo, lastResource);
        } else {
            throw new UriParserSyntaxException("Unexpected token.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
        }
    }

    private void parseFunction(FullQualifiedName fullQualifiedName, UriInfoImpl uriInfo, EdmType lastType, boolean lastIsCollection) throws UriParserException, UriValidationException {
        List<UriParameter> parameters = ParserHelper.parseFunctionParameters(this.tokenizer, this.edm, this.referringType, true, this.aliases);
        List<String> parameterNames = ParserHelper.getParameterNames(parameters);
        EdmFunction boundFunction = this.edm.getBoundFunction(fullQualifiedName, lastType.getFullQualifiedName(), lastIsCollection, parameterNames);
        if (boundFunction != null) {
            ParserHelper.validateFunctionParameters(boundFunction, parameters, this.edm, this.referringType, this.aliases);
            this.parseFunctionRest(uriInfo, boundFunction, parameters);
            return;
        }
        EdmFunction unboundFunction = this.edm.getUnboundFunction(fullQualifiedName, parameterNames);
        if (unboundFunction != null) {
            ParserHelper.validateFunctionParameters(unboundFunction, parameters, this.edm, this.referringType, this.aliases);
            this.parseFunctionRest(uriInfo, unboundFunction, parameters);
            return;
        }
        throw new UriParserSemanticException("No function '" + fullQualifiedName + "' found.", UriParserSemanticException.MessageKeys.FUNCTION_NOT_FOUND, fullQualifiedName.getFullQualifiedNameAsString());
    }

    private void parseBoundFunction(FullQualifiedName fullQualifiedName, UriInfoImpl uriInfo, UriResourcePartTyped lastResource) throws UriParserException, UriValidationException {
        EdmType type = lastResource.getType();
        List<UriParameter> parameters = ParserHelper.parseFunctionParameters(this.tokenizer, this.edm, this.referringType, true, this.aliases);
        List<String> parameterNames = ParserHelper.getParameterNames(parameters);
        EdmFunction boundFunction = this.edm.getBoundFunction(fullQualifiedName, type.getFullQualifiedName(), lastResource.isCollection(), parameterNames);
        if (boundFunction == null) {
            throw new UriParserSemanticException("Bound function '" + fullQualifiedName + "' not found.", UriParserSemanticException.MessageKeys.FUNCTION_NOT_FOUND, fullQualifiedName.getFullQualifiedNameAsString());
        }
        ParserHelper.validateFunctionParameters(boundFunction, parameters, this.edm, this.referringType, this.aliases);
        this.parseFunctionRest(uriInfo, boundFunction, parameters);
    }

    private void parseFunctionRest(UriInfoImpl uriInfo, EdmFunction function, List<UriParameter> parameters) throws UriParserException, UriValidationException {
        UriResourceFunctionImpl functionResource = new UriResourceFunctionImpl(null, function, parameters);
        uriInfo.addResourcePart(functionResource);
        EdmReturnType edmReturnType = function.getReturnType();
        EdmType edmType = edmReturnType.getType();
        boolean isCollection = edmReturnType.isCollection();
        if (function.isComposable()) {
            if (edmType instanceof EdmEntityType) {
                if (isCollection) {
                    this.parseCollectionNavigationExpr(uriInfo, functionResource);
                } else {
                    this.parseSingleNavigationExpr(uriInfo, functionResource);
                }
            } else if (edmType instanceof EdmComplexType) {
                if (isCollection) {
                    if (this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
                        this.parseCollectionPathExpr(uriInfo, functionResource);
                    }
                } else {
                    this.parseComplexPathExpr(uriInfo, functionResource);
                }
            } else if (edmType instanceof EdmPrimitiveType) {
                if (isCollection) {
                    if (this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
                        this.parseCollectionPathExpr(uriInfo, functionResource);
                    }
                } else {
                    this.parseSinglePathExpr(uriInfo, functionResource);
                }
            }
        } else if (this.tokenizer.next(UriTokenizer.TokenKind.SLASH)) {
            throw new UriValidationException("Function is not composable.", UriValidationException.MessageKeys.UNALLOWED_RESOURCE_PATH, "");
        }
    }

    private UriResourcePartTyped parseLambdaRest(UriTokenizer.TokenKind lastTokenKind, UriResourcePartTyped lastResource) throws UriParserException, UriValidationException {
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.OPEN);
        if (lastTokenKind == UriTokenizer.TokenKind.ANY && this.tokenizer.next(UriTokenizer.TokenKind.CLOSE)) {
            return new UriResourceLambdaAnyImpl(null, null);
        }
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.ODataIdentifier);
        String lambbdaVariable = this.tokenizer.getText();
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.COLON);
        this.lambdaVariables.addFirst(new UriResourceLambdaVarImpl(lambbdaVariable, lastResource == null ? this.referringType : lastResource.getType()));
        Expression lambdaPredicateExpr = this.parseExpression();
        this.lambdaVariables.removeFirst();
        ParserHelper.requireNext(this.tokenizer, UriTokenizer.TokenKind.CLOSE);
        if (lastTokenKind == UriTokenizer.TokenKind.ALL) {
            return new UriResourceLambdaAllImpl(lambbdaVariable, lambdaPredicateExpr);
        }
        if (lastTokenKind == UriTokenizer.TokenKind.ANY) {
            return new UriResourceLambdaAnyImpl(lambbdaVariable, lambdaPredicateExpr);
        }
        throw new UriParserSyntaxException("Unexpected token.", UriParserSyntaxException.MessageKeys.SYNTAX, new String[0]);
    }

    protected static EdmType getType(Expression expression) throws UriParserException {
        EdmType type;
        if (expression instanceof Literal) {
            type = ((Literal)expression).getType();
        } else if (expression instanceof TypeLiteral) {
            type = ((TypeLiteral)expression).getType();
        } else if (expression instanceof Enumeration) {
            type = ((Enumeration)expression).getType();
        } else if (expression instanceof Member) {
            type = ((Member)expression).getType();
        } else if (expression instanceof Unary) {
            type = ((UnaryImpl)expression).getType();
        } else if (expression instanceof Binary) {
            type = ((BinaryImpl)expression).getType();
        } else if (expression instanceof Method) {
            type = ((MethodImpl)expression).getType();
        } else if (expression instanceof Alias) {
            AliasQueryOption alias = ((AliasImpl)expression).getAlias();
            type = alias == null || alias.getValue() == null ? null : ExpressionParser.getType(alias.getValue());
        } else {
            if (expression instanceof LambdaRef) {
                throw new UriParserSemanticException("Type determination not implemented.", UriParserSemanticException.MessageKeys.NOT_IMPLEMENTED, expression.toString());
            }
            throw new UriParserSemanticException("Unknown expression type.", UriParserSemanticException.MessageKeys.NOT_IMPLEMENTED, expression.toString());
        }
        if (type != null && type.getKind() == EdmTypeKind.DEFINITION) {
            type = ((EdmTypeDefinition)type).getUnderlyingType();
        }
        return type;
    }

    private boolean isType(EdmType type, EdmPrimitiveTypeKind ... kinds) throws UriParserException {
        if (type == null) {
            return true;
        }
        for (EdmPrimitiveTypeKind kind : kinds) {
            if (!type.equals(this.odata.createPrimitiveTypeInstance(kind))) continue;
            return true;
        }
        return false;
    }

    private void checkType(Expression expression, EdmPrimitiveTypeKind ... kinds) throws UriParserException {
        EdmType type = ExpressionParser.getType(expression);
        if (!this.isType(type, kinds)) {
            throw new UriParserSemanticException("Incompatible types.", UriParserSemanticException.MessageKeys.TYPES_NOT_COMPATIBLE, type == null ? "" : type.getFullQualifiedName().getFullQualifiedNameAsString(), Arrays.deepToString((Object[])kinds));
        }
    }

    private void checkNoCollection(Expression expression) throws UriParserException {
        if (expression instanceof Member && ((Member)expression).isCollection()) {
            throw new UriParserSemanticException("Collection not allowed.", UriParserSemanticException.MessageKeys.COLLECTION_NOT_ALLOWED, new String[0]);
        }
    }

    protected void checkIntegerType(Expression expression) throws UriParserException {
        this.checkNoCollection(expression);
        this.checkType(expression, EdmPrimitiveTypeKind.Int64, EdmPrimitiveTypeKind.Int32, EdmPrimitiveTypeKind.Int16, EdmPrimitiveTypeKind.Byte, EdmPrimitiveTypeKind.SByte);
    }

    protected void checkNumericType(Expression expression) throws UriParserException {
        this.checkNoCollection(expression);
        this.checkType(expression, EdmPrimitiveTypeKind.Int64, EdmPrimitiveTypeKind.Int32, EdmPrimitiveTypeKind.Int16, EdmPrimitiveTypeKind.Byte, EdmPrimitiveTypeKind.SByte, EdmPrimitiveTypeKind.Decimal, EdmPrimitiveTypeKind.Single, EdmPrimitiveTypeKind.Double);
    }

    private void checkEqualityTypes(Expression left, Expression right) throws UriParserException {
        this.checkNoCollection(left);
        this.checkNoCollection(right);
        EdmType leftType = ExpressionParser.getType(left);
        EdmType rightType = ExpressionParser.getType(right);
        if (leftType == null || rightType == null || leftType.equals(rightType)) {
            return;
        }
        if (this.isType(leftType, EdmPrimitiveTypeKind.Byte, EdmPrimitiveTypeKind.SByte) && this.isType(rightType, EdmPrimitiveTypeKind.Byte, EdmPrimitiveTypeKind.SByte)) {
            return;
        }
        if (leftType.getKind() != EdmTypeKind.PRIMITIVE || rightType.getKind() != EdmTypeKind.PRIMITIVE || !((EdmPrimitiveType)leftType).isCompatible((EdmPrimitiveType)rightType) && !((EdmPrimitiveType)rightType).isCompatible((EdmPrimitiveType)leftType)) {
            throw new UriParserSemanticException("Incompatible types.", UriParserSemanticException.MessageKeys.TYPES_NOT_COMPATIBLE, leftType.getFullQualifiedName().getFullQualifiedNameAsString(), rightType.getFullQualifiedName().getFullQualifiedNameAsString());
        }
    }

    private EdmEnumType getEnumType(String primitiveValueLiteral) throws UriParserException {
        String enumTypeName = primitiveValueLiteral.substring(0, primitiveValueLiteral.indexOf(39));
        EdmEnumType type = this.edm.getEnumType(new FullQualifiedName(enumTypeName));
        if (type == null) {
            throw new UriParserSemanticException("Unknown Enum type '" + enumTypeName + "'.", UriParserSemanticException.MessageKeys.UNKNOWN_TYPE, enumTypeName);
        }
        return type;
    }

    private boolean isEnumType(Expression expression) throws UriParserException {
        EdmType expressionType = ExpressionParser.getType(expression);
        return expressionType == null || expressionType.getKind() == EdmTypeKind.ENUM || this.isType(expressionType, EdmPrimitiveTypeKind.Int16, EdmPrimitiveTypeKind.Int32, EdmPrimitiveTypeKind.Int64, EdmPrimitiveTypeKind.Byte, EdmPrimitiveTypeKind.SByte);
    }

    private Enumeration createEnumExpression(String primitiveValueLiteral) throws UriParserException {
        EdmEnumType enumType = this.getEnumType(primitiveValueLiteral);
        try {
            return new EnumerationImpl(enumType, Arrays.asList(enumType.fromUriLiteral(primitiveValueLiteral).split(",")));
        }
        catch (EdmPrimitiveTypeException e) {
            throw new UriParserSemanticException("Wrong enumeration value '" + primitiveValueLiteral + "'.", (Throwable)e, UriParserSemanticException.MessageKeys.UNKNOWN_PART, primitiveValueLiteral);
        }
    }

    private void checkRelationTypes(Expression left, Expression right) throws UriParserException {
        this.checkNoCollection(left);
        this.checkNoCollection(right);
        EdmType leftType = ExpressionParser.getType(left);
        EdmType rightType = ExpressionParser.getType(right);
        this.checkType(left, EdmPrimitiveTypeKind.Int16, EdmPrimitiveTypeKind.Int32, EdmPrimitiveTypeKind.Int64, EdmPrimitiveTypeKind.Byte, EdmPrimitiveTypeKind.SByte, EdmPrimitiveTypeKind.Decimal, EdmPrimitiveTypeKind.Single, EdmPrimitiveTypeKind.Double, EdmPrimitiveTypeKind.Boolean, EdmPrimitiveTypeKind.Guid, EdmPrimitiveTypeKind.String, EdmPrimitiveTypeKind.Date, EdmPrimitiveTypeKind.TimeOfDay, EdmPrimitiveTypeKind.DateTimeOffset, EdmPrimitiveTypeKind.Duration);
        this.checkType(right, EdmPrimitiveTypeKind.Int16, EdmPrimitiveTypeKind.Int32, EdmPrimitiveTypeKind.Int64, EdmPrimitiveTypeKind.Byte, EdmPrimitiveTypeKind.SByte, EdmPrimitiveTypeKind.Decimal, EdmPrimitiveTypeKind.Single, EdmPrimitiveTypeKind.Double, EdmPrimitiveTypeKind.Boolean, EdmPrimitiveTypeKind.Guid, EdmPrimitiveTypeKind.String, EdmPrimitiveTypeKind.Date, EdmPrimitiveTypeKind.TimeOfDay, EdmPrimitiveTypeKind.DateTimeOffset, EdmPrimitiveTypeKind.Duration);
        if (leftType == null || rightType == null) {
            return;
        }
        if (!((EdmPrimitiveType)leftType).isCompatible((EdmPrimitiveType)rightType) && !((EdmPrimitiveType)rightType).isCompatible((EdmPrimitiveType)leftType)) {
            throw new UriParserSemanticException("Incompatible types.", UriParserSemanticException.MessageKeys.TYPES_NOT_COMPATIBLE, leftType.getFullQualifiedName().getFullQualifiedNameAsString(), rightType.getFullQualifiedName().getFullQualifiedNameAsString());
        }
    }

    private EdmType getAddSubTypeAndCheckLeftAndRight(Expression left, Expression right, boolean isSub) throws UriParserException {
        this.checkNoCollection(left);
        this.checkNoCollection(right);
        EdmType leftType = ExpressionParser.getType(left);
        EdmType rightType = ExpressionParser.getType(right);
        if (this.isType(leftType, EdmPrimitiveTypeKind.Int16, EdmPrimitiveTypeKind.Int32, EdmPrimitiveTypeKind.Int64, EdmPrimitiveTypeKind.Byte, EdmPrimitiveTypeKind.SByte, EdmPrimitiveTypeKind.Decimal, EdmPrimitiveTypeKind.Single, EdmPrimitiveTypeKind.Double) && this.isType(rightType, EdmPrimitiveTypeKind.Int16, EdmPrimitiveTypeKind.Int32, EdmPrimitiveTypeKind.Int64, EdmPrimitiveTypeKind.Byte, EdmPrimitiveTypeKind.SByte, EdmPrimitiveTypeKind.Decimal, EdmPrimitiveTypeKind.Single, EdmPrimitiveTypeKind.Double)) {
            if (this.isType(leftType, EdmPrimitiveTypeKind.Decimal, EdmPrimitiveTypeKind.Single, EdmPrimitiveTypeKind.Double) || this.isType(rightType, EdmPrimitiveTypeKind.Decimal, EdmPrimitiveTypeKind.Single, EdmPrimitiveTypeKind.Double)) {
                return this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Double);
            }
            if (this.isType(leftType, EdmPrimitiveTypeKind.Int64) || this.isType(rightType, EdmPrimitiveTypeKind.Int64)) {
                return this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Decimal);
            }
            if (this.isType(leftType, EdmPrimitiveTypeKind.Int32) || this.isType(rightType, EdmPrimitiveTypeKind.Int32)) {
                return this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Int64);
            }
            if (this.isType(leftType, EdmPrimitiveTypeKind.Int16) || this.isType(rightType, EdmPrimitiveTypeKind.Int16)) {
                return this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Int32);
            }
            return this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Int16);
        }
        if ((this.isType(leftType, EdmPrimitiveTypeKind.DateTimeOffset) || this.isType(leftType, EdmPrimitiveTypeKind.Date) || this.isType(leftType, EdmPrimitiveTypeKind.Duration)) && this.isType(rightType, EdmPrimitiveTypeKind.Duration)) {
            return leftType;
        }
        if (isSub && (this.isType(leftType, EdmPrimitiveTypeKind.DateTimeOffset) && this.isType(rightType, EdmPrimitiveTypeKind.DateTimeOffset) || this.isType(leftType, EdmPrimitiveTypeKind.Date) && this.isType(rightType, EdmPrimitiveTypeKind.Date))) {
            return this.odata.createPrimitiveTypeInstance(EdmPrimitiveTypeKind.Duration);
        }
        throw new UriParserSemanticException("Incompatible types.", UriParserSemanticException.MessageKeys.TYPES_NOT_COMPATIBLE, leftType.getFullQualifiedName().getFullQualifiedNameAsString(), rightType.getFullQualifiedName().getFullQualifiedNameAsString());
    }

    private void checkStructuredTypeFilter(EdmType type, EdmType filterType) throws UriParserException {
        if (!(filterType instanceof EdmStructuredType) || !((EdmStructuredType)filterType).compatibleTo(type)) {
            throw new UriParserSemanticException("Incompatible type filter.", UriParserSemanticException.MessageKeys.INCOMPATIBLE_TYPE_FILTER, filterType.getFullQualifiedName().getFullQualifiedNameAsString());
        }
    }

    static {
        EnumMap<UriTokenizer.TokenKind, Enum> temp = new EnumMap<UriTokenizer.TokenKind, Enum>(UriTokenizer.TokenKind.class);
        temp.put(UriTokenizer.TokenKind.OrOperator, BinaryOperatorKind.OR);
        temp.put(UriTokenizer.TokenKind.AndOperator, BinaryOperatorKind.AND);
        temp.put(UriTokenizer.TokenKind.EqualsOperator, BinaryOperatorKind.EQ);
        temp.put(UriTokenizer.TokenKind.NotEqualsOperator, BinaryOperatorKind.NE);
        temp.put(UriTokenizer.TokenKind.GreaterThanOperator, BinaryOperatorKind.GT);
        temp.put(UriTokenizer.TokenKind.GreaterThanOrEqualsOperator, BinaryOperatorKind.GE);
        temp.put(UriTokenizer.TokenKind.LessThanOperator, BinaryOperatorKind.LT);
        temp.put(UriTokenizer.TokenKind.LessThanOrEqualsOperator, BinaryOperatorKind.LE);
        temp.put(UriTokenizer.TokenKind.AddOperator, BinaryOperatorKind.ADD);
        temp.put(UriTokenizer.TokenKind.SubOperator, BinaryOperatorKind.SUB);
        temp.put(UriTokenizer.TokenKind.MulOperator, BinaryOperatorKind.MUL);
        temp.put(UriTokenizer.TokenKind.DivOperator, BinaryOperatorKind.DIV);
        temp.put(UriTokenizer.TokenKind.ModOperator, BinaryOperatorKind.MOD);
        tokenToBinaryOperator = Collections.unmodifiableMap(temp);
        temp = new EnumMap(UriTokenizer.TokenKind.class);
        temp.put(UriTokenizer.TokenKind.CeilingMethod, MethodKind.CEILING);
        temp.put(UriTokenizer.TokenKind.ConcatMethod, MethodKind.CONCAT);
        temp.put(UriTokenizer.TokenKind.ContainsMethod, MethodKind.CONTAINS);
        temp.put(UriTokenizer.TokenKind.DateMethod, MethodKind.DATE);
        temp.put(UriTokenizer.TokenKind.DayMethod, MethodKind.DAY);
        temp.put(UriTokenizer.TokenKind.EndswithMethod, MethodKind.ENDSWITH);
        temp.put(UriTokenizer.TokenKind.FloorMethod, MethodKind.FLOOR);
        temp.put(UriTokenizer.TokenKind.FractionalsecondsMethod, MethodKind.FRACTIONALSECONDS);
        temp.put(UriTokenizer.TokenKind.GeoDistanceMethod, MethodKind.GEODISTANCE);
        temp.put(UriTokenizer.TokenKind.GeoIntersectsMethod, MethodKind.GEOINTERSECTS);
        temp.put(UriTokenizer.TokenKind.GeoLengthMethod, MethodKind.GEOLENGTH);
        temp.put(UriTokenizer.TokenKind.HourMethod, MethodKind.HOUR);
        temp.put(UriTokenizer.TokenKind.IndexofMethod, MethodKind.INDEXOF);
        temp.put(UriTokenizer.TokenKind.LengthMethod, MethodKind.LENGTH);
        temp.put(UriTokenizer.TokenKind.MaxdatetimeMethod, MethodKind.MAXDATETIME);
        temp.put(UriTokenizer.TokenKind.MindatetimeMethod, MethodKind.MINDATETIME);
        temp.put(UriTokenizer.TokenKind.MinuteMethod, MethodKind.MINUTE);
        temp.put(UriTokenizer.TokenKind.MonthMethod, MethodKind.MONTH);
        temp.put(UriTokenizer.TokenKind.NowMethod, MethodKind.NOW);
        temp.put(UriTokenizer.TokenKind.RoundMethod, MethodKind.ROUND);
        temp.put(UriTokenizer.TokenKind.SecondMethod, MethodKind.SECOND);
        temp.put(UriTokenizer.TokenKind.StartswithMethod, MethodKind.STARTSWITH);
        temp.put(UriTokenizer.TokenKind.SubstringMethod, MethodKind.SUBSTRING);
        temp.put(UriTokenizer.TokenKind.TimeMethod, MethodKind.TIME);
        temp.put(UriTokenizer.TokenKind.TolowerMethod, MethodKind.TOLOWER);
        temp.put(UriTokenizer.TokenKind.TotaloffsetminutesMethod, MethodKind.TOTALOFFSETMINUTES);
        temp.put(UriTokenizer.TokenKind.TotalsecondsMethod, MethodKind.TOTALSECONDS);
        temp.put(UriTokenizer.TokenKind.ToupperMethod, MethodKind.TOUPPER);
        temp.put(UriTokenizer.TokenKind.TrimMethod, MethodKind.TRIM);
        temp.put(UriTokenizer.TokenKind.YearMethod, MethodKind.YEAR);
        temp.put(UriTokenizer.TokenKind.SubstringofMethod, MethodKind.SUBSTRINGOF);
        tokenToMethod = Collections.unmodifiableMap(temp);
    }
}

