/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.olingo.commons.api.ex.ODataError;
import org.apache.olingo.commons.api.ex.ODataErrorDetail;
import org.apache.olingo.server.api.serializer.SerializerException;

public class ODataErrorSerializer {
    public void writeErrorDocument(JsonGenerator json, ODataError error) throws IOException, SerializerException {
        if (error == null) {
            throw new SerializerException("ODataError object MUST NOT be null!", SerializerException.MessageKeys.NULL_INPUT, new String[0]);
        }
        json.writeStartObject();
        json.writeFieldName("error");
        json.writeStartObject();
        this.writeODataError(json, error.getCode(), error.getMessage(), error.getTarget());
        this.writeODataAdditionalProperties(json, error.getAdditionalProperties());
        if (error.getDetails() != null) {
            json.writeArrayFieldStart("details");
            for (ODataErrorDetail detail : error.getDetails()) {
                json.writeStartObject();
                this.writeODataError(json, detail.getCode(), detail.getMessage(), detail.getTarget());
                this.writeODataAdditionalProperties(json, detail.getAdditionalProperties());
                json.writeEndObject();
            }
            json.writeEndArray();
        }
        json.writeEndObject();
        json.writeEndObject();
    }

    private void writeODataAdditionalProperties(JsonGenerator json, Map<String, Object> additionalProperties) throws IOException {
        if (additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : additionalProperties.entrySet()) {
                Object value = additionalProperty.getValue();
                if (value instanceof List) {
                    List list = (List)value;
                    json.writeArrayFieldStart(additionalProperty.getKey());
                    for (Map entry : list) {
                        json.writeStartObject();
                        this.writeODataAdditionalProperties(json, entry);
                        json.writeEndObject();
                    }
                    json.writeEndArray();
                    continue;
                }
                if (value instanceof Map) {
                    this.writeODataAdditionalProperties(json, (Map)value);
                    continue;
                }
                json.writeObjectField(additionalProperty.getKey(), value);
            }
        }
    }

    private void writeODataError(JsonGenerator json, String code, String message, String target) throws IOException {
        json.writeFieldName("code");
        if (code == null) {
            json.writeNull();
        } else {
            json.writeString(code);
        }
        json.writeFieldName("message");
        if (message == null) {
            json.writeNull();
        } else {
            json.writeString(message);
        }
        if (target != null) {
            json.writeStringField("target", target);
        }
    }
}

