/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.queryoption.expression;

import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.uri.queryoption.expression.Enumeration;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitException;
import org.apache.olingo.server.api.uri.queryoption.expression.ExpressionVisitor;

public class EnumerationImpl
implements Enumeration {
    private final EdmEnumType type;
    private final List<String> values;

    public EnumerationImpl(EdmEnumType type, List<String> values) {
        this.type = type;
        this.values = values;
    }

    @Override
    public EdmEnumType getType() {
        return this.type;
    }

    @Override
    public List<String> getValues() {
        return this.values == null ? Collections.emptyList() : Collections.unmodifiableList(this.values);
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) throws ExpressionVisitException, ODataApplicationException {
        return visitor.visitEnum(this.type, this.values);
    }

    public String toString() {
        return this.type == null ? "NULL" : this.type.getFullQualifiedName().getFullQualifiedNameAsString() + this.getValues();
    }
}

