/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.cud;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.cud.ODataReferenceAddingRequest;
import org.apache.olingo.client.api.communication.response.ODataReferenceAddingResponse;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.serialization.ODataSerializerException;
import org.apache.olingo.client.api.serialization.ODataWriter;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;

public class ODataReferenceAddingRequestImpl
extends AbstractODataBasicRequest<ODataReferenceAddingResponse>
implements ODataReferenceAddingRequest {
    final ResWrap<URI> reference;

    ODataReferenceAddingRequestImpl(ODataClient odataClient, HttpMethod method, URI uri, ResWrap<URI> reference) {
        super(odataClient, method, uri);
        this.reference = reference;
    }

    @Override
    public ContentType getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    @Override
    public InputStream getPayload() {
        if (this.reference == null) {
            return null;
        }
        ODataWriter writer = this.odataClient.getWriter();
        try {
            return writer.writeReference(this.reference, ContentType.parse(this.getContentType()));
        }
        catch (ODataSerializerException e) {
            LOG.warn("Error serializing reference {}", this.reference);
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public ODataReferenceAddingResponse execute() {
        InputStream input = this.getPayload();
        ((HttpEntityEnclosingRequestBase)this.request).setEntity(URIUtils.buildInputStreamEntity(this.odataClient, input));
        try {
            ODataReferenceAddingResponseImpl oDataReferenceAddingResponseImpl = new ODataReferenceAddingResponseImpl(this.odataClient, this.httpClient, this.doExecute());
            return oDataReferenceAddingResponseImpl;
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    private class ODataReferenceAddingResponseImpl
    extends AbstractODataResponse
    implements ODataReferenceAddingResponse {
        private ODataReferenceAddingResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.close();
        }
    }
}

