/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.cud;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.cud.ODataValueUpdateRequest;
import org.apache.olingo.client.api.communication.response.ODataValueUpdateResponse;
import org.apache.olingo.client.api.domain.ClientPrimitiveValue;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;

public class ODataValueUpdateRequestImpl
extends AbstractODataBasicRequest<ODataValueUpdateResponse>
implements ODataValueUpdateRequest {
    private final ClientPrimitiveValue value;

    ODataValueUpdateRequestImpl(ODataClient odataClient, HttpMethod method, URI targetURI, ClientPrimitiveValue value) {
        super(odataClient, method, targetURI);
        this.value = value;
    }

    @Override
    public ContentType getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultValueFormat();
    }

    @Override
    public ODataValueUpdateResponse execute() {
        InputStream input = this.getPayload();
        ((HttpEntityEnclosingRequestBase)this.request).setEntity(URIUtils.buildInputStreamEntity(this.odataClient, input));
        try {
            ODataValueUpdateResponseImpl oDataValueUpdateResponseImpl = new ODataValueUpdateResponseImpl(this.odataClient, this.httpClient, this.doExecute());
            return oDataValueUpdateResponseImpl;
        }
        finally {
            IOUtils.closeQuietly(input);
        }
    }

    @Override
    public InputStream getPayload() {
        return IOUtils.toInputStream(this.value.toString());
    }

    private class ODataValueUpdateResponseImpl
    extends AbstractODataResponse
    implements ODataValueUpdateResponse {
        private ClientPrimitiveValue resValue;

        private ODataValueUpdateResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.resValue = null;
        }

        @Override
        public ClientPrimitiveValue getBody() {
            if (this.resValue == null) {
                ContentType contentType = ContentType.parse(ODataValueUpdateRequestImpl.this.getAccept());
                try {
                    this.resValue = this.odataClient.getObjectFactory().newPrimitiveValueBuilder().setType(contentType.isCompatible(ContentType.TEXT_PLAIN) ? EdmPrimitiveTypeKind.String : EdmPrimitiveTypeKind.Stream).setValue(this.getRawResponse()).build();
                }
                catch (Exception e) {
                    throw new HttpClientException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.resValue;
        }
    }
}

