/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.commons.api.edm.provider.CsdlAnnotations;

@JsonDeserialize(using=AnnotationsDeserializer.class)
class ClientCsdlAnnotations
extends CsdlAnnotations
implements Serializable {
    private static final long serialVersionUID = -5961207981571644200L;

    ClientCsdlAnnotations() {
    }

    static class AnnotationsDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlAnnotations> {
        AnnotationsDeserializer() {
        }

        @Override
        protected ClientCsdlAnnotations doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlAnnotations annotations = new ClientCsdlAnnotations();
            while (jp.getCurrentToken() != null && jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Target".equals(jp.getCurrentName())) {
                        annotations.setTarget(jp.nextTextValue());
                    } else if ("Qualifier".equals(jp.getCurrentName())) {
                        annotations.setQualifier(jp.nextTextValue());
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        annotations.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return annotations;
        }
    }
}

