/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.core.serialization.JsonDeserializer;
import org.apache.olingo.commons.api.ex.ODataErrorDetail;

public class JsonODataErrorDetailDeserializer
extends JsonDeserializer {
    public JsonODataErrorDetailDeserializer(boolean serverMode) {
        super(serverMode);
    }

    protected ResWrap<ODataErrorDetail> doDeserialize(JsonParser parser) throws IOException {
        ODataErrorDetail error = new ODataErrorDetail();
        JsonNode errorNode = (JsonNode)parser.getCodec().readTree(parser);
        if (errorNode.has("code")) {
            error.setCode(errorNode.get("code").textValue());
        }
        if (errorNode.has("message")) {
            JsonNode message = errorNode.get("message");
            if (message.isValueNode()) {
                error.setMessage(message.textValue());
            } else if (message.isObject()) {
                error.setMessage(message.get("value").asText());
            }
        }
        if (errorNode.has("target")) {
            error.setTarget(errorNode.get("target").textValue());
        }
        return new ResWrap<ODataErrorDetail>(null, null, error);
    }
}

