/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.batch;

import java.net.URI;
import java.util.List;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.deserializer.batch.BatchDeserializerException;
import org.apache.olingo.server.core.deserializer.batch.BatchParserCommon;
import org.apache.olingo.server.core.deserializer.batch.Header;
import org.apache.olingo.server.core.deserializer.batch.HeaderField;

public class BatchTransformatorCommon {
    private BatchTransformatorCommon() {
    }

    public static void validateContentType(Header headers, ContentType expected) throws BatchDeserializerException {
        List<String> contentTypes = headers.getHeaders("Content-Type");
        if (contentTypes.isEmpty()) {
            throw new BatchDeserializerException("Missing content type", BatchDeserializerException.MessageKeys.MISSING_CONTENT_TYPE, Integer.toString(headers.getLineNumber()));
        }
        BatchParserCommon.parseContentType(contentTypes.get(0), expected, headers.getLineNumber());
    }

    public static void validateContentTransferEncoding(Header headers) throws BatchDeserializerException {
        List<String> contentTransferValues;
        HeaderField contentTransferField = headers.getHeaderField("Content-Transfer-Encoding");
        if (!(contentTransferField == null || (contentTransferValues = contentTransferField.getValues()).size() <= 1 && "binary".equalsIgnoreCase(contentTransferValues.get(0)))) {
            throw new BatchDeserializerException("Invalid Content-Transfer-Encoding header", BatchDeserializerException.MessageKeys.INVALID_CONTENT_TRANSFER_ENCODING, Integer.toString(headers.getLineNumber()));
        }
    }

    public static int getContentLength(Header headers) throws BatchDeserializerException {
        HeaderField contentLengthField = headers.getHeaderField("Content-Length");
        if (contentLengthField != null && contentLengthField.getValues().size() == 1) {
            try {
                int contentLength = Integer.parseInt(contentLengthField.getValues().get(0));
                if (contentLength < 0) {
                    throw new BatchDeserializerException("Invalid content length", BatchDeserializerException.MessageKeys.INVALID_CONTENT_LENGTH, Integer.toString(contentLengthField.getLineNumber()));
                }
                return contentLength;
            }
            catch (NumberFormatException e) {
                throw new BatchDeserializerException("Invalid content length", (Throwable)e, BatchDeserializerException.MessageKeys.INVALID_CONTENT_LENGTH, Integer.toString(contentLengthField.getLineNumber()));
            }
        }
        return -1;
    }

    public static void validateHost(Header headers, String baseUri) throws BatchDeserializerException {
        HeaderField hostField = headers.getHeaderField("Host");
        if (!(hostField == null || hostField.getValues().size() <= 1 && URI.create(baseUri).getAuthority().equalsIgnoreCase(hostField.getValues().get(0).trim()))) {
            throw new BatchDeserializerException("Invalid Host header", BatchDeserializerException.MessageKeys.INVALID_HOST, Integer.toString(headers.getLineNumber()));
        }
    }
}

