/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.etag;

import java.util.Collection;
import java.util.Collections;
import org.apache.olingo.server.api.etag.ETagHelper;
import org.apache.olingo.server.api.etag.PreconditionException;
import org.apache.olingo.server.core.etag.ETagInformation;
import org.apache.olingo.server.core.etag.ETagParser;

public class ETagHelperImpl
implements ETagHelper {
    @Override
    public boolean checkReadPreconditions(String eTag, Collection<String> ifMatchHeaders, Collection<String> ifNoneMatchHeaders) throws PreconditionException {
        if (eTag != null) {
            ETagInformation ifMatch = this.createETagInformation(ifMatchHeaders);
            if (!ifMatch.isMatchedBy(eTag) && !ifMatch.getETags().isEmpty()) {
                throw new PreconditionException("The If-Match precondition is not fulfilled.", PreconditionException.MessageKeys.FAILED, new String[0]);
            }
            return this.createETagInformation(ifNoneMatchHeaders).isMatchedBy(eTag);
        }
        return false;
    }

    @Override
    public void checkChangePreconditions(String eTag, Collection<String> ifMatchHeaders, Collection<String> ifNoneMatchHeaders) throws PreconditionException {
        if (eTag != null) {
            ETagInformation ifMatch = this.createETagInformation(ifMatchHeaders);
            ETagInformation ifNoneMatch = this.createETagInformation(ifNoneMatchHeaders);
            if (!ifMatch.isMatchedBy(eTag) && !ifMatch.getETags().isEmpty() || ifNoneMatch.isMatchedBy(eTag)) {
                throw new PreconditionException("The preconditions are not fulfilled.", PreconditionException.MessageKeys.FAILED, new String[0]);
            }
        }
    }

    protected ETagInformation createETagInformation(Collection<String> values) {
        Collection<String> eTags = ETagParser.parse(values);
        boolean isAll = eTags.size() == 1 && "*".equals(eTags.iterator().next());
        return new ETagInformation(isAll, isAll ? Collections.emptySet() : Collections.unmodifiableCollection(eTags));
    }
}

