/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.uri.parser;

import java.util.Collection;
import java.util.Map;
import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.uri.queryoption.AliasQueryOption;
import org.apache.olingo.server.api.uri.queryoption.OrderByOption;
import org.apache.olingo.server.api.uri.queryoption.expression.Expression;
import org.apache.olingo.server.core.uri.parser.ExpressionParser;
import org.apache.olingo.server.core.uri.parser.UriParserException;
import org.apache.olingo.server.core.uri.parser.UriTokenizer;
import org.apache.olingo.server.core.uri.queryoption.OrderByItemImpl;
import org.apache.olingo.server.core.uri.queryoption.OrderByOptionImpl;
import org.apache.olingo.server.core.uri.validator.UriValidationException;

public class OrderByParser {
    private final Edm edm;
    private final OData odata;

    public OrderByParser(Edm edm, OData odata) {
        this.edm = edm;
        this.odata = odata;
    }

    public OrderByOption parse(UriTokenizer tokenizer, EdmStructuredType referencedType, Collection<String> crossjoinEntitySetNames, Map<String, AliasQueryOption> aliases) throws UriParserException, UriValidationException {
        OrderByOptionImpl orderByOption = new OrderByOptionImpl();
        do {
            Expression orderByExpression = new ExpressionParser(this.edm, this.odata).parse(tokenizer, referencedType, crossjoinEntitySetNames, aliases);
            OrderByItemImpl item = new OrderByItemImpl();
            item.setExpression(orderByExpression);
            if (tokenizer.next(UriTokenizer.TokenKind.AscSuffix)) {
                item.setDescending(false);
            } else if (tokenizer.next(UriTokenizer.TokenKind.DescSuffix)) {
                item.setDescending(true);
            }
            orderByOption.addOrder(item);
        } while (tokenizer.next(UriTokenizer.TokenKind.COMMA));
        return orderByOption;
    }
}

