/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo4;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.olingo4.api.Olingo4App;
import org.apache.camel.component.olingo4.api.Olingo4ResponseHandler;
import org.apache.camel.util.ObjectHelper;
import org.apache.olingo.commons.api.edm.Edm;

public class Olingo4AppWrapper {
    private final Olingo4App olingo4App;
    private volatile Edm edm;

    public Olingo4AppWrapper(Olingo4App olingo4App) {
        ObjectHelper.notNull(olingo4App, "olingo4App");
        this.olingo4App = olingo4App;
    }

    public Olingo4App getOlingo4App() {
        return this.olingo4App;
    }

    public void close() {
        this.olingo4App.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Edm getEdm(Map<String, String> endpointHttpHeaders) throws RuntimeCamelException {
        Edm localEdm = this.edm;
        if (localEdm == null) {
            Olingo4AppWrapper olingo4AppWrapper = this;
            synchronized (olingo4AppWrapper) {
                localEdm = this.edm;
                if (localEdm == null) {
                    final CountDownLatch latch = new CountDownLatch(1);
                    final Exception[] error = new Exception[1];
                    this.olingo4App.read(null, "$metadata", null, endpointHttpHeaders, new Olingo4ResponseHandler<Edm>(){

                        @Override
                        public void onResponse(Edm response, Map<String, String> responseHeaders) {
                            Olingo4AppWrapper.this.edm = response;
                            latch.countDown();
                        }

                        @Override
                        public void onException(Exception ex) {
                            error[0] = ex;
                            latch.countDown();
                        }

                        @Override
                        public void onCanceled() {
                            error[0] = new RuntimeCamelException("OData HTTP request cancelled!");
                            latch.countDown();
                        }
                    });
                    try {
                        latch.await();
                        Exception ex = error[0];
                        if (ex != null) {
                            if (ex instanceof RuntimeCamelException) {
                                throw (RuntimeCamelException)ex;
                            }
                            String message = ex.getMessage() != null ? ex.getMessage() : ex.getClass().getName();
                            throw new RuntimeCamelException("Error reading EDM: " + message, ex);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeCamelException(e.getMessage(), e);
                    }
                    localEdm = this.edm;
                }
            }
        }
        return localEdm;
    }
}

