/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.header.ODataHeaders;
import org.apache.olingo.client.api.communication.request.ODataRequest;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.api.http.HttpClientException;
import org.apache.olingo.client.core.communication.request.AbstractRequest;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;

public abstract class AbstractODataRequest
extends AbstractRequest
implements ODataRequest {
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    protected final ODataClient odataClient;
    protected final HttpMethod method;
    protected final ODataHeaders odataHeaders;
    protected URI uri;
    protected HttpClient httpClient;
    protected HttpUriRequest request;

    protected AbstractODataRequest(ODataClient odataClient, HttpMethod method, URI uri) {
        this.odataClient = odataClient;
        this.method = method;
        this.odataHeaders = odataClient.newVersionHeaders();
        this.uri = uri;
        this.httpClient = this.getHttpClient(method, uri);
        this.request = odataClient.getConfiguration().getHttpUriRequestFactory().create(this.method, uri);
    }

    public abstract ContentType getDefaultFormat();

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public HttpUriRequest getHttpRequest() {
        return this.request;
    }

    @Override
    public void setURI(URI uri) {
        this.uri = uri;
        this.httpClient = this.getHttpClient(this.method, uri);
        this.request = this.odataClient.getConfiguration().getHttpUriRequestFactory().create(this.method, this.uri);
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.odataHeaders.getHeaderNames();
    }

    @Override
    public String getHeader(String name) {
        return this.odataHeaders.getHeader(name);
    }

    @Override
    public ODataRequest setAccept(String value) {
        this.odataHeaders.setHeader("Accept", value);
        return this;
    }

    @Override
    public ODataRequest setIfMatch(String value) {
        this.odataHeaders.setHeader("If-Match", value);
        return this;
    }

    @Override
    public ODataRequest setIfNoneMatch(String value) {
        this.odataHeaders.setHeader("If-None-Match", value);
        return this;
    }

    @Override
    public ODataRequest setPrefer(String value) {
        this.odataHeaders.setHeader("Prefer", value);
        return this;
    }

    @Override
    public ODataRequest setXHTTPMethod(String value) {
        this.odataHeaders.setHeader("X-HTTP-Method", value);
        return this;
    }

    @Override
    public ODataRequest setContentType(String value) {
        this.odataHeaders.setHeader("Content-Type", value);
        return this;
    }

    @Override
    public ODataRequest addCustomHeader(String name, String value) {
        this.odataHeaders.setHeader(name, value);
        return this;
    }

    @Override
    public String getAccept() {
        String acceptHead = this.odataHeaders.getHeader("Accept");
        return StringUtils.isBlank(acceptHead) ? this.getDefaultFormat().toContentTypeString() : acceptHead;
    }

    @Override
    public String getIfMatch() {
        return this.odataHeaders.getHeader("If-Match");
    }

    @Override
    public String getIfNoneMatch() {
        return this.odataHeaders.getHeader("If-None-Match");
    }

    @Override
    public String getPrefer() {
        return this.odataHeaders.getHeader("Prefer");
    }

    @Override
    public String getContentType() {
        String contentTypeHead = this.odataHeaders.getHeader("Content-Type");
        return StringUtils.isBlank(contentTypeHead) ? this.getDefaultFormat().toContentTypeString() : contentTypeHead;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    public ODataHeaders getHeader() {
        return this.odataHeaders;
    }

    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            StringBuilder requestBuilder = new StringBuilder();
            requestBuilder.append(this.getMethod().toString()).append(' ').append(this.uri.toString()).append(' ').append("HTTP/1.1");
            baos.write(requestBuilder.toString().getBytes(DEFAULT_CHARSET));
            baos.write(CRLF);
            if (StringUtils.isBlank(this.odataHeaders.getHeader("Content-Type"))) {
                this.setContentType(this.getContentType());
            }
            if (StringUtils.isBlank(this.odataHeaders.getHeader("Accept"))) {
                this.setAccept(this.getAccept());
            }
            for (String name : this.getHeaderNames()) {
                String value = this.getHeader(name);
                if (!StringUtils.isNotBlank(value)) continue;
                baos.write((name + ": " + value).getBytes(DEFAULT_CHARSET));
                baos.write(CRLF);
            }
            Object object = baos.toByteArray();
            return object;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly(baos);
        }
    }

    @Override
    public InputStream rawExecute() {
        HttpEntity httpEntity = null;
        try {
            httpEntity = this.doExecute().getEntity();
            return httpEntity == null ? null : httpEntity.getContent();
        }
        catch (IOException e) {
            EntityUtils.consumeQuietly(httpEntity);
            throw new HttpClientException(e);
        }
        catch (RuntimeException e) {
            this.request.abort();
            EntityUtils.consumeQuietly(httpEntity);
            throw new HttpClientException(e);
        }
    }

    protected HttpResponse doExecute() {
        HttpResponse response;
        this.checkRequest(this.odataClient, this.request);
        if (StringUtils.isBlank(this.odataHeaders.getHeader("Content-Type"))) {
            this.setContentType(this.getContentType());
        }
        if (StringUtils.isBlank(this.odataHeaders.getHeader("Accept"))) {
            this.setAccept(this.getAccept());
        }
        if (this.odataClient.getConfiguration().isKeyAsSegment()) {
            this.addCustomHeader("DataServiceUrlConventions", this.odataClient.newPreferences().keyAsSegment());
        }
        for (String key : this.getHeaderNames()) {
            this.request.addHeader(key, this.odataHeaders.getHeader(key));
        }
        if (LOG.isDebugEnabled()) {
            for (Header header : this.request.getAllHeaders()) {
                LOG.debug("HTTP header being sent: " + header);
            }
        }
        try {
            response = this.httpClient.execute(this.request);
        }
        catch (IOException e) {
            throw new HttpClientException(this.request.getURI().toASCIIString(), e);
        }
        catch (RuntimeException e) {
            this.request.abort();
            throw new HttpClientException(this.request.getURI().toASCIIString(), e);
        }
        try {
            this.checkResponse(this.odataClient, response, this.getAccept());
        }
        catch (ODataRuntimeException e) {
            this.closeHttpResponse(response);
            this.odataClient.getConfiguration().getHttpClientFactory().close(this.httpClient);
            throw e;
        }
        return response;
    }

    private void closeHttpResponse(HttpResponse response) {
        if (response instanceof CloseableHttpResponse) {
            try {
                ((CloseableHttpResponse)response).close();
            }
            catch (IOException e) {
                LOG.warn("Unable to close response: {}", (Object)response, (Object)e);
            }
        }
    }

    public <V extends ODataResponse> V getResponseTemplate() {
        for (Class<?> clazz : this.getClass().getDeclaredClasses()) {
            if (!ODataResponse.class.isAssignableFrom(clazz)) continue;
            try {
                Constructor<?> constructor = clazz.getDeclaredConstructor(this.getClass(), ODataClient.class, HttpClient.class, HttpResponse.class);
                constructor.setAccessible(true);
                return (V)((ODataResponse)constructor.newInstance(this, this.odataClient, this.httpClient, null));
            }
            catch (Exception e) {
                LOG.error("Error retrieving response class template instance", (Throwable)e);
            }
        }
        throw new IllegalStateException("No response class template has been found");
    }

    private HttpClient getHttpClient(HttpMethod method, URI uri) {
        HttpClient client = this.odataClient.getConfiguration().getHttpClientFactory().create(method, uri);
        if (this.odataClient.getConfiguration().isGzipCompression()) {
            client = new DecompressingHttpClient(client);
        }
        return client;
    }
}

